%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.4/input/regression/persian-key-signatures.ly"
\sourcefileline 0
\version "2.23.6"

\header {
  texidoc = "Test Persian key signatures."
}

\include "persian.ly"

Shur = \relative c' { c4 d ek f g a bf }
Shurk = \relative c' { c4 d ek f g ak bf }
Esfahan = \relative c' { f,4 g ak b c d ef }
Msegah = \relative c' { c4 d ek fo g a bf }
Chah = \relative c' { cs4 d ek fs g a bk }
Mahur = \relative c' { c4 d e f g a b }
Delk = \relative c' { f4 g a bf c dk ef }


showKey =
  #(define-music-function
      (key from to music bar)
      (string? ly:pitch? ly:pitch? ly:music? string?)
    #{
      \key $to #(eval-string key)
      <>^\markup { $key
                   \concat { "(" #(note-name->string to) ")" } }
      \transpose $from $to { #music }
      \bar $bar
    #})


{
  \cadenzaOn

  \showKey "shur" d c \Shur "|"
  \showKey "shurk" d d \Shurk "|"
  \showKey "esfahan" c e \Esfahan "|"
  \showKey "mokhalefsegah" g f \Msegah "|"
  \showKey "chahargah" d g \Chah "|"
  \showKey "mahur" c a \Mahur "||"
  \showKey "delkashMahur" f b \Delk "|."
}

\layout {
  \context {
    \Staff
    printKeyCancellation = ##f
    explicitKeySignatureVisibility = ##(#f #t #t)
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
