/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao.json;

import ca.sqlpower.dao.MessageDecoder;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SPJSONMessageDecoder
implements MessageDecoder<String> {
    private static final Logger logger = Logger.getLogger(SPJSONMessageDecoder.class);
    private SPPersister persister;

    public SPJSONMessageDecoder(@Nonnull SPPersister persister) {
        this.persister = persister;
    }

    @Override
    public void decode(@Nonnull String message) throws SPPersistenceException {
        this.decode(new JSONTokener(message));
    }

    @Override
    public void decode(JSONTokener tokener) throws SPPersistenceException {
        String uuid = null;
        JSONObject jsonObject = null;
        try {
            SPPersister sPPersister = this.persister;
            synchronized (sPPersister) {
                char q;
                char c = tokener.nextClean();
                if (c == '[') {
                    q = ']';
                } else if (c == '(') {
                    q = ')';
                } else {
                    throw tokener.syntaxError("A JSONArray text must start with '['");
                }
                if (tokener.nextClean() == ']') {
                    return;
                }
                tokener.back();
                int index = 0;
                block9: while (true) {
                    if (tokener.nextClean() == ',') {
                        tokener.back();
                        throw new JSONException("JSONArray[" + index + "] not found.");
                    }
                    tokener.back();
                    Object nextValue = tokener.nextValue();
                    if (nextValue instanceof JSONObject) {
                        jsonObject = (JSONObject)nextValue;
                        logger.debug((Object)("Decoding Message: " + jsonObject));
                        uuid = jsonObject.getString("uuid");
                        this.decode(jsonObject);
                        ++index;
                    } else {
                        throw new JSONException("JSONArray[" + index + "] is not a JSONObject.");
                    }
                    c = tokener.nextClean();
                    switch (c) {
                        case ',': 
                        case ';': {
                            if (tokener.nextClean() == ']') {
                                return;
                            }
                            tokener.back();
                            continue block9;
                        }
                        case ')': 
                        case ']': {
                            if (q != c) {
                                throw tokener.syntaxError("Expected a '" + new Character(q) + "'");
                            }
                            return;
                        }
                    }
                    break;
                }
                throw tokener.syntaxError("Expected a ',' or ']'");
            }
        }
        catch (JSONException e) {
            if (jsonObject != null) {
                logger.error((Object)("Error decoding JSONObject " + jsonObject));
            }
            throw new SPPersistenceException(uuid, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(JSONArray json) throws SPPersistenceException {
        JSONObject jsonObject = null;
        String uuid = null;
        try {
            SPPersister sPPersister = this.persister;
            synchronized (sPPersister) {
                for (int i = 0; i < json.length(); ++i) {
                    jsonObject = json.getJSONObject(i);
                    logger.debug((Object)("Decoding Message: " + jsonObject));
                    uuid = jsonObject.getString("uuid");
                    this.decode(jsonObject);
                }
            }
        }
        catch (JSONException e) {
            if (jsonObject != null) {
                logger.error((Object)("Error decoding JSONObject " + jsonObject));
            }
            throw new SPPersistenceException(uuid, e);
        }
    }

    private static Object getNullable(@Nonnull JSONObject jo, String propName) throws JSONException {
        Object value = jo.get(propName);
        if (value == JSONObject.NULL) {
            return null;
        }
        return value;
    }

    public static Object getWithType(@Nonnull JSONObject jo, SPPersister.DataType type, String propName) throws JSONException {
        if (SPJSONMessageDecoder.getNullable(jo, propName) == null) {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                return jo.getBoolean(propName);
            }
            case DOUBLE: {
                return jo.getDouble(propName);
            }
            case INTEGER: {
                return jo.getInt(propName);
            }
            case LONG: {
                return jo.getLong(propName);
            }
            case SHORT: {
                return jo.getShort(propName);
            }
            case FLOAT: {
                return Float.valueOf(jo.getFloat(propName));
            }
            case PNG_IMG: {
                byte[] decodedBytes;
                SPJSONMessageDecoder.getNullable(jo, propName);
                String base64Data = jo.getString(propName);
                try {
                    decodedBytes = Base64.decodeBase64((byte[])base64Data.getBytes("ascii"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("ASCII should always be supported!", e);
                }
                return new ByteArrayInputStream(decodedBytes);
            }
        }
        return SPJSONMessageDecoder.getNullable(jo, propName);
    }

    @Override
    private void decode(JSONObject jsonObject) throws SPPersistenceException {
        String uuid = null;
        try {
            uuid = jsonObject.getString("uuid");
            SPPersister.SPPersistMethod method = SPPersister.SPPersistMethod.valueOf(jsonObject.getString("method"));
            switch (method) {
                case begin: {
                    this.persister.begin();
                    break;
                }
                case commit: {
                    this.persister.commit();
                    break;
                }
                case persistObject: {
                    String parentUUID = jsonObject.getString("parentUUID");
                    if (parentUUID.equals("")) {
                        // empty if block
                    }
                    String type = jsonObject.getString("type");
                    int index = jsonObject.getInt("index");
                    this.persister.persistObject(parentUUID, type, uuid, index);
                    break;
                }
                case changeProperty: {
                    String propertyName = jsonObject.getString("propertyName");
                    SPPersister.DataType propertyType = SPPersister.DataType.valueOf(jsonObject.getString("type"));
                    Object newValue = SPJSONMessageDecoder.getWithType(jsonObject, propertyType, "newValue");
                    Object oldValue = SPJSONMessageDecoder.getWithType(jsonObject, propertyType, "oldValue");
                    this.persister.persistProperty(uuid, propertyName, propertyType, oldValue, newValue);
                    break;
                }
                case persistProperty: {
                    String propertyName = jsonObject.getString("propertyName");
                    SPPersister.DataType propertyType = SPPersister.DataType.valueOf(jsonObject.getString("type"));
                    Object newValue = SPJSONMessageDecoder.getWithType(jsonObject, propertyType, "newValue");
                    if (newValue == null) {
                        logger.debug((Object)("newValue was null for propertyName " + propertyName));
                    }
                    this.persister.persistProperty(uuid, propertyName, propertyType, newValue);
                    break;
                }
                case removeObject: {
                    String parentUUID = jsonObject.getString("parentUUID");
                    if (parentUUID.equals("")) {
                        throw new SPPersistenceException(null, "Cannot persist object with null UUID");
                    }
                    this.persister.removeObject(parentUUID, uuid);
                    break;
                }
                case rollback: {
                    this.persister.rollback();
                    break;
                }
                default: {
                    throw new SPPersistenceException(uuid, "Does not support SP persistence method " + (Object)((Object)method));
                }
            }
        }
        catch (JSONException e) {
            if (jsonObject != null) {
                logger.error((Object)("Error decoding JSONObject " + jsonObject));
            }
            throw new SPPersistenceException(uuid, e);
        }
    }
}

