/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xsdvalidator;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xsdvalidator.Messages;
import org.pentaho.di.trans.steps.xsdvalidator.XsdValidatorData;
import org.pentaho.di.trans.steps.xsdvalidator.XsdValidatorMeta;
import org.xml.sax.SAXException;

public class XsdValidator
extends BaseStep
implements StepInterface {
    private XsdValidatorMeta meta;
    private XsdValidatorData data;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public XsdValidator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] row;
        block45: {
            block46: {
                block43: {
                    this.meta = (XsdValidatorMeta)smi;
                    this.data = (XsdValidatorData)sdi;
                    row = this.getRow();
                    if (row == null) {
                        this.setOutputDone();
                        return false;
                    }
                    if (!this.first) break block45;
                    this.first = false;
                    this.data.outputRowMeta = this.getInputRowMeta().clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    if (this.meta.getXMLStream() == null) break block46;
                    this.data.xmlindex = this.getInputRowMeta().indexOfValue(this.meta.getXMLStream());
                    if (this.data.xmlindex < 0) {
                        this.logError(Messages.getString("XsdValidator.Log.ErrorFindingField") + "[" + this.meta.getXMLStream() + "]");
                        throw new KettleStepException(Messages.getString("XsdValidator.Exception.CouldnotFindField", this.meta.getXMLStream()));
                    }
                    if (this.meta.getResultfieldname() == null) {
                        this.logError(Messages.getString("XsdValidator.Log.ErrorResultFieldMissing"));
                        throw new KettleStepException(Messages.getString("XsdValidator.Exception.ErrorResultFieldMissing"));
                    }
                    if (this.meta.getXSDSource().equals(this.meta.SPECIFY_FILENAME)) {
                        if (this.meta.getXSDFilename() == null) {
                            this.logError(Messages.getString("XsdValidator.Log.ErrorXSDFileMissing"));
                            throw new KettleStepException(Messages.getString("XsdValidator.Exception.ErrorXSDFileMissing"));
                        }
                        FileObject xsdfile = null;
                        xsdfile = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getXSDFilename()));
                        if (!xsdfile.exists()) {
                            this.logError(Messages.getString("XsdValidator.Log.Error.XSDFileNotExists"));
                            throw new KettleStepException(Messages.getString("XsdValidator.Exception.XSDFileNotExists"));
                        }
                        Object var7_6 = null;
                        try {
                            if (xsdfile != null) {
                                xsdfile.close();
                            }
                            break block43;
                        }
                        catch (IOException e) {}
                        break block43;
                        {
                            catch (Exception e) {
                                this.logError(Messages.getString("XsdValidator.Log.Error.GettingXSDFile"));
                                throw new KettleStepException(Messages.getString("XsdValidator.Exception.GettingXSDFile"));
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_7 = null;
                            try {
                                if (xsdfile != null) {
                                    xsdfile.close();
                                }
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                if (this.meta.getXSDSource().equals(this.meta.SPECIFY_FIELDNAME)) {
                    if (this.meta.getXSDDefinedField() == null) {
                        this.logError(Messages.getString("XsdValidator.Log.Error.XSDFieldMissing"));
                        throw new KettleStepException(Messages.getString("XsdValidator.Exception.XSDFieldMissing"));
                    }
                    this.data.xsdindex = this.getInputRowMeta().indexOfValue(this.meta.getXSDDefinedField());
                    if (this.data.xsdindex < 0) {
                        this.logError(Messages.getString("XsdValidator.Log.ErrorFindingXSDField", this.meta.getXSDDefinedField()));
                        throw new KettleStepException(Messages.getString("XsdValidator.Exception.ErrorFindingXSDField", this.meta.getXSDDefinedField()));
                    }
                }
                break block45;
            }
            this.logError(Messages.getString("XsdValidator.Log.Error.XmlStreamFieldMissing"));
            throw new KettleStepException(Messages.getString("XsdValidator.Exception.XmlStreamFieldMissing"));
        }
        boolean sendToErrorRow = false;
        String errorMessage = null;
        try {
            String validationmsg;
            boolean isvalid;
            block44: {
                String XMLFieldvalue = this.getInputRowMeta().getString(row, this.data.xmlindex);
                isvalid = false;
                String xsdfilename = null;
                if (this.meta.getXSDSource().equals(this.meta.SPECIFY_FILENAME)) {
                    xsdfilename = this.environmentSubstitute(this.meta.getXSDFilename());
                } else if (this.meta.getXSDSource().equals(this.meta.SPECIFY_FIELDNAME)) {
                    xsdfilename = this.getInputRowMeta().getString(row, this.data.xsdindex);
                }
                FileObject xsdfile = null;
                validationmsg = null;
                SchemaFactory factoryXSDValidator = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                xsdfile = KettleVFS.getFileObject((String)xsdfilename);
                File XSDFile = new File(KettleVFS.getFilename((FileObject)xsdfile));
                StreamSource sourceXML = new StreamSource(new StringReader(XMLFieldvalue));
                if (this.meta.getXMLSourceFile()) {
                    File xmlfileValidator = new File(XMLFieldvalue);
                    if (!xmlfileValidator.exists()) {
                        this.logError(Messages.getString("XsdValidator.Log.Error.XMLfileMissing", XMLFieldvalue));
                        throw new KettleStepException(Messages.getString("XsdValidator.Exception.XMLfileMissing", XMLFieldvalue));
                    }
                    sourceXML = new StreamSource(xmlfileValidator);
                }
                Schema SchematXSD = factoryXSDValidator.newSchema(XSDFile);
                if (this.meta.getXSDSource().equals(this.meta.NO_NEED)) {
                    SchematXSD = factoryXSDValidator.newSchema();
                }
                Validator XSDValidator = SchematXSD.newValidator();
                XSDValidator.validate(sourceXML);
                isvalid = true;
                Object var17_25 = null;
                try {
                    if (xsdfile != null) {
                        xsdfile.close();
                    }
                    break block44;
                }
                catch (IOException e) {}
                break block44;
                {
                    catch (SAXException ex) {
                        validationmsg = ex.getMessage();
                        this.logError("SAX Exception : " + ex);
                        Object var17_26 = null;
                        try {
                            if (xsdfile != null) {
                                xsdfile.close();
                            }
                            break block44;
                        }
                        catch (IOException e) {}
                        break block44;
                    }
                    catch (IOException ex) {
                        validationmsg = ex.getMessage();
                        this.logError("SAX Exception : " + ex);
                        Object var17_27 = null;
                        try {
                            if (xsdfile != null) {
                                xsdfile.close();
                            }
                            break block44;
                        }
                        catch (IOException e) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var17_28 = null;
                    try {
                        if (xsdfile != null) {
                            xsdfile.close();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Object[] outputRowData = null;
            Object[] outputRowData2 = null;
            outputRowData = this.meta.getOutputStringField() ? (isvalid ? RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)this.environmentSubstitute(this.meta.getIfXmlValid())) : RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)this.environmentSubstitute(this.meta.getIfXmlInvalid()))) : RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)isvalid);
            outputRowData2 = this.meta.useAddValidationMessage() ? RowDataUtil.addValueData((Object[])outputRowData, (int)(this.getInputRowMeta().size() + 1), (Object)validationmsg) : outputRowData;
            if (this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("XsdValidator.Log.ReadRow") + " " + this.getInputRowMeta().getString(row));
            }
            this.putRow(this.data.outputRowMeta, outputRowData2);
        }
        catch (KettleException e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                sendToErrorRow = true;
                errorMessage = e.toString();
            }
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "XSD001");
            }
            this.logError(Messages.getString("XsdValidator.ErrorProcesing : " + e.getMessage()));
            throw new KettleStepException(Messages.getString("XsdValidator.ErrorProcesing"), (Throwable)e);
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XsdValidatorMeta)smi;
        this.data = (XsdValidatorData)sdi;
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XsdValidatorMeta)smi;
        this.data = (XsdValidatorData)sdi;
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

