/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.htmlparser.jericho.Config;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.network.HttpHeaderField;
import org.zaproxy.zap.spider.Spider;
import org.zaproxy.zap.spider.SpiderTask;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderGitParser;
import org.zaproxy.zap.spider.parser.SpiderHtmlFormParser;
import org.zaproxy.zap.spider.parser.SpiderHtmlParser;
import org.zaproxy.zap.spider.parser.SpiderODataAtomParser;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.spider.parser.SpiderParserListener;
import org.zaproxy.zap.spider.parser.SpiderRedirectParser;
import org.zaproxy.zap.spider.parser.SpiderResourceFound;
import org.zaproxy.zap.spider.parser.SpiderRobotstxtParser;
import org.zaproxy.zap.spider.parser.SpiderSVNEntriesParser;
import org.zaproxy.zap.spider.parser.SpiderSitemapXMLParser;
import org.zaproxy.zap.spider.parser.SpiderTextParser;

public class SpiderController
implements SpiderParserListener {
    private LinkedList<FetchFilter> fetchFilters;
    private LinkedList<ParseFilter> parseFilters;
    private ParseFilter defaultParseFilter;
    private LinkedList<SpiderParser> parsers;
    private List<SpiderParser> parsersUnmodifiableView;
    private Spider spider;
    private Set<String> visitedResources;
    private static final Logger log = LogManager.getLogger(SpiderController.class);

    protected SpiderController(Spider spider, List<SpiderParser> customParsers) {
        this.spider = spider;
        this.fetchFilters = new LinkedList();
        this.parseFilters = new LinkedList();
        this.visitedResources = new HashSet<String>();
        this.prepareDefaultParsers();
        for (SpiderParser parser : customParsers) {
            this.addSpiderParser(parser);
        }
    }

    private void prepareDefaultParsers() {
        SpiderParser parser;
        this.parsers = new LinkedList();
        if (this.spider.getSpiderParam().isParseRobotsTxt()) {
            parser = new SpiderRobotstxtParser(this.spider.getSpiderParam());
            this.parsers.add(parser);
        }
        if (this.spider.getSpiderParam().isParseSitemapXml()) {
            if (log.isDebugEnabled()) {
                log.debug("Adding SpiderSitemapXMLParser");
            }
            parser = new SpiderSitemapXMLParser(this.spider.getSpiderParam());
            this.parsers.add(parser);
        } else if (log.isDebugEnabled()) {
            log.debug("NOT Adding SpiderSitemapXMLParser");
        }
        if (this.spider.getSpiderParam().isParseSVNEntries()) {
            parser = new SpiderSVNEntriesParser(this.spider.getSpiderParam());
            this.parsers.add(parser);
        }
        if (this.spider.getSpiderParam().isParseGit()) {
            parser = new SpiderGitParser(this.spider.getSpiderParam());
            this.parsers.add(parser);
        }
        parser = new SpiderRedirectParser();
        this.parsers.add(parser);
        parser = new SpiderHtmlParser(this.spider.getSpiderParam());
        this.parsers.add(parser);
        parser = new SpiderHtmlFormParser(this.spider.getSpiderParam(), this.spider.getExtensionSpider().getValueGenerator());
        this.parsers.add(parser);
        Config.CurrentCompatibilityMode.setFormFieldNameCaseInsensitive(false);
        parser = new SpiderODataAtomParser();
        this.parsers.add(parser);
        parser = new SpiderTextParser();
        this.parsers.add(parser);
        this.parsersUnmodifiableView = Collections.unmodifiableList(this.parsers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSeed(URI uri, String method) {
        SpiderResourceFound resourceFound = SpiderResourceFound.builder().setUri(uri.toString()).setMethod(method).build();
        String resourceIdentifier = "";
        try {
            resourceIdentifier = this.buildCanonicalResourceIdentifier(uri, resourceFound);
        }
        catch (URIException e) {
            return;
        }
        Set<String> e = this.visitedResources;
        synchronized (e) {
            if (this.visitedResources.contains(resourceIdentifier)) {
                log.debug("URI already visited: " + uri);
                return;
            }
            this.visitedResources.add(resourceIdentifier);
        }
        SpiderTask task = new SpiderTask(this.spider, resourceFound, uri);
        this.spider.submitTask(task);
        this.spider.notifyListenersFoundURI(uri.toString(), method, FetchFilter.FetchStatus.SEED);
    }

    protected LinkedList<FetchFilter> getFetchFilters() {
        return this.fetchFilters;
    }

    public void addFetchFilter(FetchFilter filter) {
        log.debug("Loading fetch filter: " + filter.getClass().getSimpleName());
        this.fetchFilters.add(filter);
    }

    protected LinkedList<ParseFilter> getParseFilters() {
        return this.parseFilters;
    }

    public void addParseFilter(ParseFilter filter) {
        log.debug("Loading parse filter: " + filter.getClass().getSimpleName());
        this.parseFilters.add(filter);
    }

    protected void setDefaultParseFilter(ParseFilter filter) {
        log.debug("Setting Default filter: " + filter.getClass().getSimpleName());
        this.defaultParseFilter = filter;
    }

    protected ParseFilter getDefaultParseFilter() {
        return this.defaultParseFilter;
    }

    public void init() {
        this.visitedResources.clear();
        for (SpiderParser parser : this.parsers) {
            parser.addSpiderParserListener(this);
        }
    }

    public void reset() {
        this.visitedResources.clear();
        for (SpiderParser parser : this.parsers) {
            parser.removeSpiderParserListener(this);
        }
    }

    private String buildCanonicalResourceIdentifier(URI uri, SpiderResourceFound resourceFound) throws URIException {
        StringBuilder identifierBuilder = new StringBuilder(50);
        String visitedURI = URLCanonicalizer.buildCleanedParametersURIRepresentation(uri, this.spider.getSpiderParam().getHandleParameters(), this.spider.getSpiderParam().isHandleODataParametersVisited());
        identifierBuilder.append(resourceFound.getMethod());
        identifierBuilder.append(" ");
        identifierBuilder.append(visitedURI);
        identifierBuilder.append("\n");
        identifierBuilder.append(this.getCanonicalHeadersString(resourceFound.getHeaders()));
        identifierBuilder.append("\n");
        identifierBuilder.append(resourceFound.getBody());
        return identifierBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceFound(SpiderResourceFound resourceFound) {
        log.debug("New {} resource found: {}", (Object)resourceFound.getMethod(), (Object)resourceFound.getUri());
        URI uriV = this.createURI(resourceFound.getUri());
        if (uriV == null) {
            return;
        }
        String resourceIdentifier = "";
        try {
            resourceIdentifier = this.buildCanonicalResourceIdentifier(uriV, resourceFound);
        }
        catch (URIException e) {
            return;
        }
        Set<String> e = this.visitedResources;
        synchronized (e) {
            if (this.visitedResources.contains(resourceIdentifier)) {
                log.debug("Resource already visited: {}", (Object)resourceIdentifier.trim());
                return;
            }
            this.visitedResources.add(resourceIdentifier);
        }
        for (FetchFilter f : this.fetchFilters) {
            FetchFilter.FetchStatus s = f.checkFilter(uriV);
            if (s == FetchFilter.FetchStatus.VALID) continue;
            log.debug("URI: " + uriV + " was filtered by a filter with reason: " + (Object)((Object)s));
            this.spider.notifyListenersFoundURI(resourceFound.getUri(), resourceFound.getMethod(), s);
            return;
        }
        if (resourceFound.isShouldIgnore()) {
            log.debug("URI: " + uriV + " is valid, but will not be fetched, by parser recommendation.");
            this.spider.notifyListenersFoundURI(resourceFound.getUri(), resourceFound.getMethod(), FetchFilter.FetchStatus.VALID);
            return;
        }
        this.spider.notifyListenersFoundURI(resourceFound.getUri(), resourceFound.getMethod(), FetchFilter.FetchStatus.VALID);
        SpiderTask task = new SpiderTask(this.spider, resourceFound, uriV);
        this.spider.submitTask(task);
    }

    private String getCanonicalHeadersString(List<HttpHeaderField> headers) {
        return headers.stream().sorted((h1, h2) -> h1.getName().compareTo(h2.getName())).map(h -> h.getName().trim().toLowerCase() + "=" + h.getValue().trim().toLowerCase()).distinct().collect(Collectors.joining("|"));
    }

    private URI createURI(String uri) {
        URI uriV = null;
        try {
            uriV = new URI(uri, true);
        }
        catch (URIException e) {
            try {
                log.debug("Second try...");
                uriV = new URI(uri, false);
            }
            catch (Exception ex) {
                log.error("Error while converting to uri: " + uri, (Throwable)ex);
                return null;
            }
        }
        catch (Exception e) {
            log.error("Error while converting to uri: " + uri, (Throwable)e);
            return null;
        }
        return uriV;
    }

    public List<SpiderParser> getParsers() {
        return this.parsersUnmodifiableView;
    }

    public void addSpiderParser(SpiderParser parser) {
        log.debug("Loading custom Spider Parser: " + parser.getClass().getSimpleName());
        this.parsers.addFirst(parser);
    }
}

