/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.view.TabbedPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakPanel;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointMessage;
import org.zaproxy.zap.utils.Stats;
import org.zaproxy.zap.view.TabbedPanel2;
import org.zaproxy.zap.view.ZapToggleButton;

public class BreakPanelToolbarFactory {
    private ContinueButtonAction continueButtonAction;
    private StepButtonAction stepButtonAction;
    private DropButtonAction dropButtonAction;
    private AddBreakpointButtonAction addBreakpointButtonAction;
    private BreakRequestsButtonAction breakRequestsButtonAction;
    private BreakResponsesButtonAction breakResponsesButtonAction;
    private BreakAllButtonAction breakAllButtonAction;
    private SetBreakOnJavaScriptAction setBreakOnJavaScriptAction;
    private SetBreakOnCssAndFontsAction setBreakOnCssAndFontsAction;
    private SetBreakOnMultimediaAction setBreakOnMultimediaAction;
    private SetBreakOnlyOnScopeAction setOnlyBreakOnScopeAction;
    private boolean cont = false;
    private boolean step = false;
    private boolean stepping = false;
    private boolean drop = false;
    private boolean isBreakRequest = false;
    private boolean isBreakResponse = false;
    private boolean isBreakAll = false;
    private boolean isBreakOnJavaScript = true;
    private boolean isBreakOnCssAndFonts = true;
    private boolean isBreakOnMultimedia = true;
    private BreakPanel breakPanel = null;
    private BreakpointsParam breakpointsParams;
    private int mode = 0;
    private List<BreakpointMessageInterface> ignoreRulesEnable;
    private HttpBreakpointMessage ignoreJavascriptBreakpointMessage;
    private HttpBreakpointMessage ignoreCssAndFontsBreakpointMessage;
    private HttpBreakpointMessage ignoreMultimediaBreakpointMessage;
    private int countCaughtMessages;
    private final Object countLock = new Object();

    public BreakPanelToolbarFactory(BreakpointsParam breakpointsParams, BreakPanel breakPanel) {
        this.continueButtonAction = new ContinueButtonAction();
        this.stepButtonAction = new StepButtonAction();
        this.dropButtonAction = new DropButtonAction();
        this.addBreakpointButtonAction = new AddBreakpointButtonAction();
        this.breakRequestsButtonAction = new BreakRequestsButtonAction();
        this.breakResponsesButtonAction = new BreakResponsesButtonAction();
        this.breakAllButtonAction = new BreakAllButtonAction();
        this.setBreakOnJavaScriptAction = new SetBreakOnJavaScriptAction();
        this.setBreakOnCssAndFontsAction = new SetBreakOnCssAndFontsAction();
        this.setBreakOnMultimediaAction = new SetBreakOnMultimediaAction();
        this.setOnlyBreakOnScopeAction = new SetBreakOnlyOnScopeAction();
        this.breakpointsParams = breakpointsParams;
        this.breakPanel = breakPanel;
        this.ignoreRulesEnable = new ArrayList<BreakpointMessageInterface>(3);
        this.ignoreJavascriptBreakpointMessage = new HttpBreakpointMessage(breakpointsParams.getJavascriptUrlRegex(), HttpBreakpointMessage.Location.url, HttpBreakpointMessage.Match.regex, false, true);
        this.ignoreRulesEnable.add(this.ignoreJavascriptBreakpointMessage);
        this.ignoreCssAndFontsBreakpointMessage = new HttpBreakpointMessage(breakpointsParams.getCssAndFontsUrlRegex(), HttpBreakpointMessage.Location.url, HttpBreakpointMessage.Match.regex, false, true);
        this.ignoreRulesEnable.add(this.ignoreCssAndFontsBreakpointMessage);
        this.ignoreMultimediaBreakpointMessage = new HttpBreakpointMessage(breakpointsParams.getMultimediaUrlRegex(), HttpBreakpointMessage.Location.url, HttpBreakpointMessage.Match.regex, false, true);
        this.ignoreRulesEnable.add(this.ignoreMultimediaBreakpointMessage);
    }

    public List<BreakpointMessageInterface> getIgnoreRulesEnableList() {
        return this.ignoreRulesEnable;
    }

    private void setActiveIcon(boolean active) {
        if (active) {
            this.breakPanel.setTabFocus();
        }
        if (this.breakPanel.getParent() instanceof TabbedPanel) {
            TabbedPanel parent = (TabbedPanel)this.breakPanel.getParent();
            if (active) {
                parent.setIconAt(parent.indexOfComponent(this.breakPanel), new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/101.png")));
            } else {
                parent.setIconAt(parent.indexOfComponent(this.breakPanel), new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/101grey.png")));
            }
            if (parent instanceof TabbedPanel2) {
                ((TabbedPanel2)parent).setTabLocked(this.breakPanel, !active);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointHit() {
        Object object = this.countLock;
        synchronized (object) {
            ++this.countCaughtMessages;
        }
        this.resetRequestSerialization(true);
        this.setActiveIcon(true);
        this.setContinue(false);
    }

    public boolean isBreakRequest() {
        return this.isBreakRequest || this.isBreakAll;
    }

    public boolean isBreakResponse() {
        return this.isBreakResponse || this.isBreakAll;
    }

    public boolean isBreakAll() {
        return this.isBreakAll;
    }

    public JButton getBtnStep() {
        return new JButton(this.stepButtonAction);
    }

    public JButton getBtnContinue() {
        return new JButton(this.continueButtonAction);
    }

    public JButton getBtnDrop() {
        return new JButton(this.dropButtonAction);
    }

    private int askForDropConfirmation() {
        String title = Constant.messages.getString("brk.dialogue.confirmDropMessage.title");
        String message = Constant.messages.getString("brk.dialogue.confirmDropMessage.message");
        JCheckBox checkBox = new JCheckBox(Constant.messages.getString("brk.dialogue.confirmDropMessage.option.dontAskAgain"));
        String confirmButtonLabel = Constant.messages.getString("brk.dialogue.confirmDropMessage.button.confirm.label");
        String cancelButtonLabel = Constant.messages.getString("brk.dialogue.confirmDropMessage.button.cancel.label");
        int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), new Object[]{message, " ", checkBox}, title, 2, 3, null, new String[]{confirmButtonLabel, cancelButtonLabel}, null);
        if (checkBox.isSelected()) {
            this.breakpointsParams.setConfirmDropMessage(false);
        }
        return option;
    }

    public JToggleButton getBtnBreakRequest() {
        ZapToggleButton btnBreakRequest = new ZapToggleButton(this.breakRequestsButtonAction);
        btnBreakRequest.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/105r.png")));
        btnBreakRequest.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.request.unset"));
        return btnBreakRequest;
    }

    public JToggleButton getBtnBreakResponse() {
        ZapToggleButton btnBreakResponse = new ZapToggleButton(this.breakResponsesButtonAction);
        btnBreakResponse.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/106r.png")));
        btnBreakResponse.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.response.unset"));
        return btnBreakResponse;
    }

    public JToggleButton getBtnBreakAll() {
        ZapToggleButton btnBreakAll = new ZapToggleButton(this.breakAllButtonAction);
        btnBreakAll.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/151.png")));
        btnBreakAll.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.all.unset"));
        return btnBreakAll;
    }

    public JToggleButton getBtnBreakOnJavaScript() {
        ZapToggleButton btnBreakOnJavaScript = new ZapToggleButton(this.setBreakOnJavaScriptAction);
        btnBreakOnJavaScript.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/breakTypes/javascriptNotBreaking.png")));
        btnBreakOnJavaScript.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.brkjavascript.set"));
        return btnBreakOnJavaScript;
    }

    public JToggleButton getBtnBreakOnCssAndFonts() {
        ZapToggleButton btnBreakOnCssAndFonts = new ZapToggleButton(this.setBreakOnCssAndFontsAction);
        btnBreakOnCssAndFonts.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/breakTypes/cssAndFontsNotBreaking.png")));
        btnBreakOnCssAndFonts.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.brkcssfonts.set"));
        return btnBreakOnCssAndFonts;
    }

    public JToggleButton getBtnBreakOnMultimedia() {
        ZapToggleButton btnBreakOnMultimedia = new ZapToggleButton(this.setBreakOnMultimediaAction);
        btnBreakOnMultimedia.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/breakTypes/multimediaNotBreaking.png")));
        btnBreakOnMultimedia.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.brkmultimedia.set"));
        return btnBreakOnMultimedia;
    }

    public JToggleButton getBtnOnlyBreakOnScope() {
        ZapToggleButton btnOnlyBreakOnScope = new ZapToggleButton(this.setOnlyBreakOnScopeAction);
        btnOnlyBreakOnScope.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/fugue/target.png")));
        btnOnlyBreakOnScope.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.brkOnlyOnScope.unset"));
        return btnOnlyBreakOnScope;
    }

    public JButton getBtnBreakPoint() {
        return new JButton(this.addBreakpointButtonAction);
    }

    public boolean isStepping() {
        return this.stepping;
    }

    private void resetRequestSerialization(boolean forceSerialize) {
        if (Control.getSingleton() == null) {
            return;
        }
        if (forceSerialize || this.isBreakRequest() || this.isBreakResponse() || this.isBreakAll) {
            Control.getSingleton().getProxy().setSerialize(true);
        } else {
            Control.getSingleton().getProxy().setSerialize(false);
        }
    }

    public void setBreakRequest(boolean brk) {
        this.isBreakRequest = brk;
        this.resetRequestSerialization(false);
        this.breakRequestsButtonAction.setSelected(this.isBreakRequest);
    }

    public void setBreakResponse(boolean brk) {
        this.isBreakResponse = brk;
        this.resetRequestSerialization(false);
        this.breakResponsesButtonAction.setSelected(this.isBreakResponse);
    }

    public void setBreakAll(boolean brk) {
        this.isBreakAll = brk;
        if (!brk) {
            this.stepping = false;
        }
        this.resetRequestSerialization(false);
        this.breakAllButtonAction.setSelected(this.isBreakAll);
    }

    public void setBreakOnJavaScript(boolean brk) {
        this.isBreakOnJavaScript = brk;
        this.setBreakOnJavaScriptAction.setSelected(!this.isBreakOnJavaScript);
        this.ignoreJavascriptBreakpointMessage.setEnabled(!this.isBreakOnJavaScript);
    }

    public void setBreakOnCssAndFonts(boolean brk) {
        this.isBreakOnCssAndFonts = brk;
        this.setBreakOnCssAndFontsAction.setSelected(!this.isBreakOnCssAndFonts);
        this.ignoreCssAndFontsBreakpointMessage.setEnabled(!this.isBreakOnCssAndFonts);
    }

    public void setBreakOnMultimedia(boolean brk) {
        this.isBreakOnMultimedia = brk;
        this.setBreakOnMultimediaAction.setSelected(!this.isBreakOnMultimedia);
        this.ignoreMultimediaBreakpointMessage.setEnabled(!this.isBreakOnMultimedia);
    }

    public void setOnlyBreakOnScope(boolean brk) {
        this.breakpointsParams.setInScopeOnly(brk);
        this.setOnlyBreakOnScopeAction.setSelected(brk);
    }

    private void toggleBreakRequest() {
        this.setBreakRequest(!this.isBreakRequest);
    }

    private void toggleBreakResponse() {
        this.setBreakResponse(!this.isBreakResponse);
    }

    private void toggleBreakAll() {
        this.setBreakAll(!this.isBreakAll);
    }

    private void toggleBreakOnJavascript() {
        this.setBreakOnJavaScript(!this.isBreakOnJavaScript);
    }

    private void toggleBreakOnCssAndFonts() {
        this.setBreakOnCssAndFonts(!this.isBreakOnCssAndFonts);
    }

    private void toggleBreakOnMultimedia() {
        this.setBreakOnMultimedia(!this.isBreakOnMultimedia);
    }

    private void toggleBreakOnScopeOnly() {
        this.setOnlyBreakOnScope(!this.breakpointsParams.isInScopeOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHoldMessage() {
        if (this.isHoldMessageImpl()) {
            return true;
        }
        Object object = this.countLock;
        synchronized (object) {
            --this.countCaughtMessages;
            if (this.countCaughtMessages == 0) {
                this.setButtonsAndIconState(false);
            }
        }
        return false;
    }

    private boolean isHoldMessageImpl() {
        if (this.step) {
            this.stepping = true;
            this.step = false;
            return false;
        }
        if (this.cont) {
            this.stepping = false;
            this.resetRequestSerialization(false);
            return false;
        }
        return !this.drop;
    }

    public boolean isContinue() {
        return this.cont;
    }

    public void setBreakEnabled(boolean enabled) {
        if (!enabled) {
            this.isBreakRequest = false;
            this.isBreakResponse = false;
            this.isBreakAll = false;
            this.setContinue(true);
        }
        this.breakRequestsButtonAction.setSelected(false);
        this.breakRequestsButtonAction.setEnabled(enabled);
        this.breakResponsesButtonAction.setSelected(false);
        this.breakResponsesButtonAction.setEnabled(enabled);
        this.breakAllButtonAction.setSelected(false);
        this.breakAllButtonAction.setEnabled(enabled);
    }

    private void setButtonsAndIconState(boolean enabled) {
        this.stepButtonAction.setEnabled(enabled);
        this.continueButtonAction.setEnabled(enabled);
        this.dropButtonAction.setEnabled(enabled);
        if (!enabled) {
            this.setActiveIcon(false);
        }
    }

    protected void setContinue(boolean isContinue) {
        this.cont = isContinue;
        this.setButtonsAndIconState(!isContinue);
    }

    protected void step() {
        this.step = true;
        Stats.incCounter("stats.break.step");
    }

    protected void drop() {
        if (this.breakpointsParams.isConfirmDropMessage() && this.askForDropConfirmation() != 0) {
            return;
        }
        this.drop = true;
        Stats.incCounter("stats.break.drop");
    }

    public boolean isToBeDropped() {
        if (this.drop) {
            this.drop = false;
            return true;
        }
        return false;
    }

    public void init() {
        this.cont = false;
        this.step = false;
        this.stepping = false;
        this.drop = false;
        this.isBreakRequest = false;
        this.isBreakResponse = false;
        this.isBreakAll = false;
        this.setShowIgnoreFilesButtons(false);
        this.countCaughtMessages = 0;
    }

    public void reset() {
        if (this.isBreakRequest()) {
            this.toggleBreakRequest();
        }
        if (this.isBreakResponse()) {
            this.toggleBreakResponse();
        }
        if (this.isBreakAll()) {
            this.toggleBreakAll();
        }
        this.setContinue(true);
    }

    public void setButtonMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        if (this.mode == 1) {
            if (this.isBreakAll) {
                this.setBreakAll(false);
                this.setBreakRequest(true);
                this.setBreakResponse(true);
            }
        } else if (this.isBreakRequest || this.isBreakResponse) {
            this.setBreakRequest(false);
            this.setBreakResponse(false);
            this.setBreakAll(true);
        }
        this.mode = mode;
    }

    public void setShowIgnoreFilesButtons(boolean showButtons) {
        if (!showButtons) {
            this.setBreakOnJavaScript(true);
            this.setBreakOnCssAndFonts(true);
            this.setBreakOnMultimedia(true);
            this.setOnlyBreakOnScope(this.breakpointsParams.isInScopeOnly());
        }
    }

    public void updateIgnoreFileTypesRegexs() {
        this.ignoreJavascriptBreakpointMessage.setString(this.breakpointsParams.getJavascriptUrlRegex());
        this.ignoreCssAndFontsBreakpointMessage.setString(this.breakpointsParams.getCssAndFontsUrlRegex());
        this.ignoreMultimediaBreakpointMessage.setString(this.breakpointsParams.getMultimediaUrlRegex());
    }

    private static abstract class SelectableAbstractAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SelectableAbstractAction(String name, Icon icon) {
            super(name, icon);
        }

        public void setSelected(boolean selected) {
            this.putValue("SwingSelectedKey", selected);
        }
    }

    private class SetBreakOnlyOnScopeAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public SetBreakOnlyOnScopeAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/fugue/target-grey.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.brkOnlyOnScope.set"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.toggleBreakOnScopeOnly();
        }
    }

    private class SetBreakOnMultimediaAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public SetBreakOnMultimediaAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/breakTypes/multimedia.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.brkmultimedia.unset"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.toggleBreakOnMultimedia();
        }
    }

    private class SetBreakOnCssAndFontsAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public SetBreakOnCssAndFontsAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/breakTypes/cssAndFonts.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.brkcssfonts.unset"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.toggleBreakOnCssAndFonts();
        }
    }

    private class SetBreakOnJavaScriptAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public SetBreakOnJavaScriptAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/breakTypes/javascript.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.brkjavascript.unset"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.toggleBreakOnJavascript();
        }
    }

    private class BreakAllButtonAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public BreakAllButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/152.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.all.set"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.toggleBreakAll();
        }
    }

    private class BreakResponsesButtonAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public BreakResponsesButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/106.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.response.set"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.toggleBreakResponse();
        }
    }

    private class BreakRequestsButtonAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public BreakRequestsButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/105.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.request.set"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.toggleBreakRequest();
        }
    }

    private class AddBreakpointButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AddBreakpointButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/break_add.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.brkpoint"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.breakPanel.showNewBreakPointDialog();
        }
    }

    private class DropButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DropButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/150.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.bin"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.drop();
        }
    }

    private class StepButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public StepButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/143.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.step"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BreakPanelToolbarFactory.this.breakPanel.isValidState()) {
                return;
            }
            if (BreakPanelToolbarFactory.this.mode == 1 && !BreakPanelToolbarFactory.this.isBreakAll) {
                BreakPanelToolbarFactory.this.setContinue(true);
            } else {
                BreakPanelToolbarFactory.this.step();
            }
        }
    }

    private class ContinueButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ContinueButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/131.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.cont"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BreakPanelToolbarFactory.this.breakPanel.isValidState()) {
                return;
            }
            BreakPanelToolbarFactory.this.setContinue(true);
            BreakPanelToolbarFactory.this.setBreakAll(false);
            BreakPanelToolbarFactory.this.setBreakRequest(false);
            BreakPanelToolbarFactory.this.setBreakResponse(false);
        }
    }
}

