/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.traccar.model.BaseModel;

public class ExtendedModel
extends BaseModel {
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = Objects.requireNonNullElseGet(attributes, LinkedHashMap::new);
    }

    public void set(String key, Boolean value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, Byte value) {
        if (value != null) {
            this.attributes.put(key, value.intValue());
        }
    }

    public void set(String key, Short value) {
        if (value != null) {
            this.attributes.put(key, value.intValue());
        }
    }

    public void set(String key, Integer value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, Long value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, Float value) {
        if (value != null) {
            this.attributes.put(key, value.doubleValue());
        }
    }

    public void set(String key, Double value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, String value) {
        if (value != null && !value.isEmpty()) {
            this.attributes.put(key, value);
        }
    }

    public void add(Map.Entry<String, Object> entry) {
        if (entry != null && entry.getValue() != null) {
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    public String getString(String key, String defaultValue) {
        return this.parseAsString(this.attributes.get(key), defaultValue);
    }

    public String getString(String key) {
        return this.parseAsString(this.attributes.get(key), null);
    }

    public double getDouble(String key) {
        return ExtendedModel.parseAsDouble(this.attributes.get(key), 0.0);
    }

    public boolean getBoolean(String key) {
        return ExtendedModel.parseAsBoolean(this.attributes.get(key), false);
    }

    public int getInteger(String key) {
        return ExtendedModel.parseAsInteger(this.attributes.get(key), 0);
    }

    public long getLong(String key) {
        return ExtendedModel.parseAsLong(this.attributes.get(key), 0L);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public String removeString(String key) {
        return this.parseAsString(this.attributes.remove(key), null);
    }

    public Double removeDouble(String key) {
        return ExtendedModel.parseAsDouble(this.attributes.remove(key), null);
    }

    public Boolean removeBoolean(String key) {
        return ExtendedModel.parseAsBoolean(this.attributes.remove(key), null);
    }

    public Integer removeInteger(String key) {
        return ExtendedModel.parseAsInteger(this.attributes.remove(key), null);
    }

    public Long removeLong(String key) {
        return ExtendedModel.parseAsLong(this.attributes.remove(key), null);
    }

    private String parseAsString(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    private static Double parseAsDouble(Object value, Double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return numberValue.doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    private static Boolean parseAsBoolean(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        return Boolean.parseBoolean(value.toString());
    }

    private static Integer parseAsInteger(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return numberValue.intValue();
        }
        return Integer.parseInt(value.toString());
    }

    private static Long parseAsLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return numberValue.longValue();
        }
        return Long.parseLong(value.toString());
    }
}

