/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.LinkedList;
import org.traccar.api.BaseObjectResource;
import org.traccar.model.BaseModel;
import org.traccar.model.User;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

public class SimpleObjectResource<T extends BaseModel>
extends BaseObjectResource<T> {
    private final String sortField;

    public SimpleObjectResource(Class<T> baseClass, String sortField) {
        super(baseClass);
        this.sortField = sortField;
    }

    @GET
    public Collection<T> get(@QueryParam(value="all") boolean all, @QueryParam(value="userId") long userId) throws StorageException {
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        if (all) {
            if (this.permissionsService.notAdmin(this.getUserId())) {
                conditions.add(new Condition.Permission(User.class, this.getUserId(), this.baseClass));
            }
        } else {
            if (userId == 0L) {
                userId = this.getUserId();
            } else {
                this.permissionsService.checkUser(this.getUserId(), userId);
            }
            conditions.add(new Condition.Permission(User.class, userId, this.baseClass));
        }
        return this.storage.getObjects(this.baseClass, new Request(new Columns.All(), Condition.merge(conditions), this.sortField != null ? new Order(this.sortField) : null));
    }
}

