/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PskServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ServerKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskServerKeyExchangeSerializer
extends ServerKeyExchangeSerializer<PskServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskServerKeyExchangeMessage msg;

    public PskServerKeyExchangeSerializer(PskServerKeyExchangeMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing PSKServerKeyExchangeMessage");
        this.writePSKIdentityHintLength(this.msg);
        this.writePSKIdentityHint(this.msg);
        return this.getAlreadySerialized();
    }

    private void writePSKIdentityHintLength(PskServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getIdentityHintLength().getValue(), 2);
        LOGGER.debug("SerializedPSKIdentityLength: " + msg.getIdentityHintLength().getValue());
    }

    private void writePSKIdentityHint(PskServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getIdentityHint().getValue());
        LOGGER.debug("SerializedPSKIdentity: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getIdentityHint().getValue())));
    }
}

