/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.tlsattacker.core.protocol.message.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DtlsHandshakeMessageFragmentPreparator
extends HandshakeMessagePreparator<DtlsHandshakeMessageFragment> {
    private static final Logger LOGGER = LogManager.getLogger();
    private DtlsHandshakeMessageFragment msg;

    public DtlsHandshakeMessageFragmentPreparator(Chooser chooser, DtlsHandshakeMessageFragment message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    protected void prepareHandshakeMessageContents() {
        this.msg.setContent(this.msg.getFragmentContentConfig());
        this.msg.setMessageSeq(this.msg.getMessageSequenceConfig());
        this.msg.setFragmentOffset(this.msg.getOffsetConfig());
        this.msg.setFragmentLength(this.msg.getHandshakeMessageLengthConfig());
        this.msg.setEpoch(this.chooser.getContext().getDtlsWriteEpoch());
    }

    @Override
    protected void prepareMessageLength(int length) {
        LOGGER.debug("Setting length of DtlsHandshakeMessage fragment to: " + ((byte[])this.msg.getContent().getValue()).length);
        this.msg.setLength(((byte[])this.msg.getContent().getValue()).length);
    }
}

