/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.BigIntegers;

public class DHClientKeyExchangePreparator<T extends DHClientKeyExchangeMessage>
extends ClientKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected BigInteger clientPublicKey;
    protected byte[] premasterSecret;
    protected byte[] random;
    protected byte[] masterSecret;
    protected final T msg;

    public DHClientKeyExchangePreparator(Chooser chooser, T msg) {
        super(chooser, (ClientKeyExchangeMessage)msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing DHClientExchangeMessage");
        this.prepareAfterParse(true);
        this.prepareDhParams();
    }

    protected void setDhParams(boolean clientMode) {
        this.setComputationPrivateKey(this.msg, clientMode);
        this.setComputationPublicKey(this.msg, clientMode);
    }

    protected void prepareDhParams() {
        this.preparePremasterSecret(this.msg);
        this.preparePublicKey(this.msg);
        this.preparePublicKeyLength(this.msg);
        this.prepareClientServerRandom(this.msg);
    }

    protected BigInteger calculatePublicKey(BigInteger generator, BigInteger modulus, BigInteger privateKey) {
        if (modulus.compareTo(BigInteger.ZERO) == 0) {
            LOGGER.warn("Modulus is ZERO. Returning 0 publicKey");
            return BigInteger.ZERO;
        }
        return generator.modPow(privateKey.abs(), modulus.abs());
    }

    protected byte[] calculatePremasterSecret(BigInteger modulus, BigInteger privateKey, BigInteger publicKey) {
        if (modulus.compareTo(BigInteger.ZERO) == 0) {
            LOGGER.warn("Modulus is ZERO. Returning empty premaster Secret");
            return new byte[0];
        }
        return BigIntegers.asUnsignedByteArray((BigInteger)publicKey.modPow(privateKey.abs(), modulus.abs()));
    }

    protected void setComputationGenerator(T msg) {
        ((DHClientKeyExchangeMessage)msg).getComputations().setGenerator(this.chooser.getServerDhGenerator());
        LOGGER.debug("Generator: " + ((DHClientKeyExchangeMessage)msg).getComputations().getGenerator().getValue());
    }

    protected void setComputationModulus(T msg) {
        ((DHClientKeyExchangeMessage)msg).getComputations().setModulus(this.chooser.getServerDhModulus());
        LOGGER.debug("Modulus: " + ((DHClientKeyExchangeMessage)msg).getComputations().getModulus().getValue());
    }

    protected void preparePremasterSecret(T msg) {
        ((DHClientKeyExchangeMessage)msg).getComputations().setPremasterSecret(this.premasterSecret);
        this.premasterSecret = (byte[])((DHClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue();
        LOGGER.debug("PremasterSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])((DHClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue())));
    }

    protected void preparePublicKey(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKey(ArrayConverter.bigIntegerToByteArray((BigInteger)this.clientPublicKey));
        LOGGER.debug("PublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue())));
    }

    protected void preparePublicKeyLength(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKeyLength(((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue()).length);
        LOGGER.debug("PublicKeyLength: " + ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    protected void prepareClientServerRandom(T msg) {
        this.random = ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        ((DHClientKeyExchangeMessage)msg).getComputations().setClientServerRandom(this.random);
        this.random = (byte[])((DHClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue();
        LOGGER.debug("ClientServerRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])((DHClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue())));
    }

    @Override
    public void prepareAfterParse(boolean clientMode) {
        ((DHClientKeyExchangeMessage)this.msg).prepareComputations();
        this.prepareClientServerRandom(this.msg);
        this.setComputationGenerator(this.msg);
        this.setComputationModulus(this.msg);
        this.setComputationPrivateKey(this.msg, clientMode);
        if (clientMode) {
            this.clientPublicKey = this.calculatePublicKey((BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getGenerator().getValue(), (BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getModulus().getValue(), (BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue());
            this.preparePublicKey(this.msg);
        }
        this.setComputationPublicKey(this.msg, clientMode);
        this.premasterSecret = this.calculatePremasterSecret((BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getModulus().getValue(), (BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue(), (BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getPublicKey().getValue());
        this.preparePremasterSecret(this.msg);
    }

    protected void setComputationPrivateKey(T msg, boolean clientMode) {
        if (clientMode) {
            ((DHClientKeyExchangeMessage)msg).getComputations().setPrivateKey(this.chooser.getDhClientPrivateKey());
        } else {
            ((DHClientKeyExchangeMessage)msg).getComputations().setPrivateKey(this.chooser.getDhServerPrivateKey());
        }
        LOGGER.debug("Computation PrivateKey: " + ((BigInteger)((DHClientKeyExchangeMessage)msg).getComputations().getPrivateKey().getValue()).toString());
    }

    protected void setComputationPublicKey(T msg, boolean clientMode) {
        if (clientMode) {
            ((DHClientKeyExchangeMessage)msg).getComputations().setPublicKey(this.chooser.getDhServerPublicKey());
        } else {
            ((DHClientKeyExchangeMessage)msg).getComputations().setPublicKey(new BigInteger(1, (byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue()));
        }
        LOGGER.debug("Computation PublicKey: " + ((BigInteger)((DHClientKeyExchangeMessage)msg).getComputations().getPublicKey().getValue()).toString());
    }
}

