/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.udp;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.udp.stream.UdpInputStream;
import de.rub.nds.tlsattacker.transport.udp.stream.UdpOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;

public class ClientUdpTransportHandler
extends TransportHandler {
    private final String hostname;
    private final int port;
    private DatagramSocket socket;

    public ClientUdpTransportHandler(Connection connection) {
        super(connection.getTimeout().intValue(), ConnectionEndType.CLIENT, false);
        this.hostname = connection.getHostname();
        this.port = connection.getPort();
    }

    public ClientUdpTransportHandler(long timeout, String hostname, int port) {
        super(timeout, ConnectionEndType.CLIENT, false);
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public void closeConnection() throws IOException {
        this.socket.close();
        this.inStream.close();
        this.outStream.close();
    }

    @Override
    public void initialize() throws IOException {
        this.socket = new DatagramSocket();
        this.socket.connect(new InetSocketAddress(this.hostname, this.port));
        this.socket.setSoTimeout((int)this.getTimeout());
        this.setStreams(new PushbackInputStream(new UdpInputStream(this.socket, false)), new UdpOutputStream(this.socket));
    }

    public int getLocalPort() throws IOException {
        if (this.socket.isConnected()) {
            return this.socket.getLocalPort();
        }
        throw new IOException("Cannot retrieve local Port. Socket not connected");
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.socket.isClosed();
    }

    @Override
    public void closeClientConnection() throws IOException {
        this.closeConnection();
    }
}

