/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.ctp;

import ca.odell.glazedlists.impl.ctp.CTPConnection;
import ca.odell.glazedlists.impl.ctp.CTPHandler;
import ca.odell.glazedlists.impl.ctp.CTPHandlerFactory;
import ca.odell.glazedlists.impl.ctp.OpenConnection;
import ca.odell.glazedlists.impl.ctp.StartServer;
import ca.odell.glazedlists.impl.nio.NIODaemon;
import ca.odell.glazedlists.impl.nio.NIOServer;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public final class CTPConnectionManager
implements NIOServer {
    private static final int DEFAULT_PORT = 5309;
    private int listenPort = -1;
    private CTPHandlerFactory handlerFactory;
    private NIODaemon nioDaemon = null;

    public CTPConnectionManager(CTPHandlerFactory handlerFactory) {
        this(handlerFactory, 5309);
    }

    public CTPConnectionManager(CTPHandlerFactory handlerFactory, int listenPort) {
        this.handlerFactory = handlerFactory;
        this.listenPort = listenPort;
    }

    public synchronized boolean start() throws IOException {
        if (this.nioDaemon != null) {
            throw new IllegalStateException();
        }
        this.nioDaemon = new NIODaemon();
        this.nioDaemon.start();
        try {
            this.nioDaemon.invokeAndWait(new StartServer(this, this.listenPort));
        }
        catch (RuntimeException e) {
            this.nioDaemon.stop();
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        return true;
    }

    public void stop() {
        this.nioDaemon.stop();
    }

    public NIODaemon getNIODaemon() {
        return this.nioDaemon;
    }

    public void handleAccept(SelectionKey key, Selector selector) {
        SocketChannel channel = null;
        SelectionKey channelKey = null;
        try {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            channel = server.accept();
            if (channel == null) {
                return;
            }
            channel.configureBlocking(false);
            channelKey = channel.register(selector, 0);
        }
        catch (IOException e) {
            return;
        }
        CTPHandler handler = this.handlerFactory.constructHandler();
        CTPConnection server = CTPConnection.server(channelKey, handler, this);
        channelKey.attach(server);
        server.handleConnect();
    }

    public void connect(CTPHandler handler, String host, int port) {
        this.nioDaemon.invokeLater(new OpenConnection(this, handler, host, port));
    }

    public void connect(CTPHandler handler, String host) {
        this.connect(handler, host, 5309);
    }
}

