/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.MaxCollector;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class MaxFunction {
    public static final String name = "max";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The max function requires 1 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof DateValueStream) {
            return new DateMaxFunction((DateValueStream)param);
        }
        if (param instanceof IntValueStream) {
            return new IntMaxFunction((IntValueStream)param);
        }
        if (param instanceof LongValueStream) {
            return new LongMaxFunction((LongValueStream)param);
        }
        if (param instanceof FloatValueStream) {
            return new FloatMaxFunction((FloatValueStream)param);
        }
        if (param instanceof DoubleValueStream) {
            return new DoubleMaxFunction((DoubleValueStream)param);
        }
        if (param instanceof StringValueStream) {
            return new StringMaxFunction((StringValueStream)param);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The max function requires a comparable parameter. Incorrect parameter: " + params[0].getExpressionStr());
    };

    static class StringMaxFunction
    extends StringValue.AbstractStringValue
    implements ReductionFunction {
        private MaxCollector.StringMaxCollector collector;
        public static final String name = "max";
        private final String exprStr;

        public StringMaxFunction(StringValueStream param) {
            this.collector = new MaxCollector.StringMaxCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("max", param);
        }

        @Override
        public String getString() {
            return this.collector.exists() ? this.collector.max() : null;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MaxCollector.StringMaxCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "max";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class DateMaxFunction
    extends DateValue.AbstractDateValue
    implements ReductionFunction {
        private MaxCollector.LongMaxCollector collector;
        public static final String name = "max";
        private final String exprStr;

        public DateMaxFunction(LongValueStream param) {
            this.collector = new MaxCollector.LongMaxCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("max", param);
        }

        @Override
        public long getLong() {
            return this.collector.exists() ? this.collector.max() : 0L;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MaxCollector.LongMaxCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "max";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class DoubleMaxFunction
    extends DoubleValue.AbstractDoubleValue
    implements ReductionFunction {
        private MaxCollector.DoubleMaxCollector collector;
        public static final String name = "max";
        private final String exprStr;

        public DoubleMaxFunction(DoubleValueStream param) {
            this.collector = new MaxCollector.DoubleMaxCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("max", param);
        }

        @Override
        public double getDouble() {
            return this.collector.exists() ? this.collector.max() : 0.0;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MaxCollector.DoubleMaxCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "max";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class FloatMaxFunction
    extends FloatValue.AbstractFloatValue
    implements ReductionFunction {
        private MaxCollector.FloatMaxCollector collector;
        public static final String name = "max";
        private final String exprStr;

        public FloatMaxFunction(FloatValueStream param) {
            this.collector = new MaxCollector.FloatMaxCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("max", param);
        }

        @Override
        public float getFloat() {
            return this.collector.exists() ? this.collector.max() : 0.0f;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MaxCollector.FloatMaxCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "max";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class LongMaxFunction
    extends LongValue.AbstractLongValue
    implements ReductionFunction {
        private MaxCollector.LongMaxCollector collector;
        public static final String name = "max";
        private final String exprStr;

        public LongMaxFunction(LongValueStream param) {
            this.collector = new MaxCollector.LongMaxCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("max", param);
        }

        @Override
        public long getLong() {
            return this.collector.exists() ? this.collector.max() : 0L;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MaxCollector.LongMaxCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "max";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class IntMaxFunction
    extends IntValue.AbstractIntValue
    implements ReductionFunction {
        private MaxCollector.IntMaxCollector collector;
        public static final String name = "max";
        private final String exprStr;

        public IntMaxFunction(IntValueStream param) {
            this.collector = new MaxCollector.IntMaxCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("max", param);
        }

        @Override
        public int getInt() {
            return this.collector.exists() ? this.collector.max() : 0;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MaxCollector.IntMaxCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "max";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }
}

