'''OpenGL extension MESA.bgra

This module customises the behaviour of the 
OpenGL.raw.GLES2.MESA.bgra to provide a more 
Python-friendly API

Overview (from the spec)
	
	MESA_bgra extends the list of combinations host-memory color formats
	with internal formats to include BGRA and BGR as acceptable formats
	with RGB8/SRGB8 and RGBA/sRGB8_ALPHA8 as internal formats respectively.
	This feature is of interest in virtualized environments, where the host
	supports OpenGL ES only, and the virtualized guest is supposed to support
	a subset of OpenGL including textures created with the format BGRA.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/MESA/bgra.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.MESA.bgra import *
from OpenGL.raw.GLES2.MESA.bgra import _EXTENSION_NAME

def glInitBgraMESA():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION