# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("dhcpsapi.dll")
prototypes = \
    {
        #
        'DhcpAddFilterV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"AddrPatt": SimStruct({"MatchHWType": SimTypeInt(signed=True, label="Int32"), "HWType": SimTypeChar(label="Byte"), "IsWildcard": SimTypeInt(signed=True, label="Int32"), "Length": SimTypeChar(label="Byte"), "Pattern": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 255)}, name="DHCP_ADDR_PATTERN", pack=False, align=None), "Comment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ListType": SimTypeInt(signed=False, label="DHCP_FILTER_LIST_TYPE")}, name="DHCP_FILTER_ADD_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "AddFilterInfo", "ForceFlag"]),
        #
        'DhcpDeleteFilterV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"MatchHWType": SimTypeInt(signed=True, label="Int32"), "HWType": SimTypeChar(label="Byte"), "IsWildcard": SimTypeInt(signed=True, label="Int32"), "Length": SimTypeChar(label="Byte"), "Pattern": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 255)}, name="DHCP_ADDR_PATTERN", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "DeleteFilterInfo"]),
        #
        'DhcpSetFilterV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"EnforceAllowList": SimTypeInt(signed=True, label="Int32"), "EnforceDenyList": SimTypeInt(signed=True, label="Int32")}, name="DHCP_FILTER_GLOBAL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "GlobalFilterInfo"]),
        #
        'DhcpGetFilterV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"EnforceAllowList": SimTypeInt(signed=True, label="Int32"), "EnforceDenyList": SimTypeInt(signed=True, label="Int32")}, name="DHCP_FILTER_GLOBAL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "GlobalFilterInfo"]),
        #
        'DhcpEnumFilterV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"MatchHWType": SimTypeInt(signed=True, label="Int32"), "HWType": SimTypeChar(label="Byte"), "IsWildcard": SimTypeInt(signed=True, label="Int32"), "Length": SimTypeChar(label="Byte"), "Pattern": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 255)}, name="DHCP_ADDR_PATTERN", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="DHCP_FILTER_LIST_TYPE"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "pEnumRecords": SimTypePointer(SimStruct({"AddrPatt": SimStruct({"MatchHWType": SimTypeInt(signed=True, label="Int32"), "HWType": SimTypeChar(label="Byte"), "IsWildcard": SimTypeInt(signed=True, label="Int32"), "Length": SimTypeChar(label="Byte"), "Pattern": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 255)}, name="DHCP_ADDR_PATTERN", pack=False, align=None), "Comment": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_FILTER_RECORD", pack=False, align=None), offset=0)}, name="DHCP_FILTER_ENUM_INFO", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ResumeHandle", "PreferredMaximum", "ListType", "EnumFilterInfo", "ElementsRead", "ElementsTotal"]),
        #
        'DhcpCreateSubnet': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SubnetAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "SubnetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SubnetComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "SubnetState": SimTypeInt(signed=False, label="DHCP_SUBNET_STATE")}, name="DHCP_SUBNET_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "SubnetInfo"]),
        #
        'DhcpSetSubnetInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SubnetAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "SubnetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SubnetComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "SubnetState": SimTypeInt(signed=False, label="DHCP_SUBNET_STATE")}, name="DHCP_SUBNET_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "SubnetInfo"]),
        #
        'DhcpGetSubnetInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"SubnetAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "SubnetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SubnetComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "SubnetState": SimTypeInt(signed=False, label="DHCP_SUBNET_STATE")}, name="DHCP_SUBNET_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "SubnetInfo"]),
        #
        'DhcpEnumSubnets': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)}, name="DHCP_IP_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ResumeHandle", "PreferredMaximum", "EnumInfo", "ElementsRead", "ElementsTotal"]),
        #
        'DhcpAddSubnetElement': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "SecondaryHost": SimTypePointer(SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0)}, name="DHCP_IP_RESERVATION", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "IpUsedCluster": SimTypePointer(SimStruct({"ClusterAddress": SimTypeInt(signed=False, label="UInt32"), "ClusterMask": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_CLUSTER", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "AddElementInfo"]),
        #
        'DhcpEnumSubnetElements': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "SecondaryHost": SimTypePointer(SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0)}, name="DHCP_IP_RESERVATION", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "IpUsedCluster": SimTypePointer(SimStruct({"ClusterAddress": SimTypeInt(signed=False, label="UInt32"), "ClusterMask": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_CLUSTER", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA", pack=False, align=None), offset=0)}, name="DHCP_SUBNET_ELEMENT_INFO_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "EnumElementType", "ResumeHandle", "PreferredMaximum", "EnumElementInfo", "ElementsRead", "ElementsTotal"]),
        #
        'DhcpRemoveSubnetElement': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "SecondaryHost": SimTypePointer(SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0)}, name="DHCP_IP_RESERVATION", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "IpUsedCluster": SimTypePointer(SimStruct({"ClusterAddress": SimTypeInt(signed=False, label="UInt32"), "ClusterMask": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_CLUSTER", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DHCP_FORCE_FLAG")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "RemoveElementInfo", "ForceFlag"]),
        #
        'DhcpDeleteSubnet': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="DHCP_FORCE_FLAG")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ForceFlag"]),
        #
        'DhcpCreateOption': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "OptionID", "OptionInfo"]),
        #
        'DhcpSetOptionInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "OptionID", "OptionInfo"]),
        #
        'DhcpGetOptionInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "OptionID", "OptionInfo"]),
        #
        'DhcpEnumOptions': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Options": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)}, name="DHCP_OPTION_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ResumeHandle", "PreferredMaximum", "Options", "OptionsRead", "OptionsTotal"]),
        #
        'DhcpRemoveOption': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "OptionID"]),
        #
        'DhcpSetOptionValue': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "OptionID", "ScopeInfo", "OptionValue"]),
        #
        'DhcpSetOptionValues': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Values": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0)}, name="DHCP_OPTION_VALUE_ARRAY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ScopeInfo", "OptionValues"]),
        #
        'DhcpGetOptionValue': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "OptionID", "ScopeInfo", "OptionValue"]),
        #
        'DhcpEnumOptionValues': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Values": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0)}, name="DHCP_OPTION_VALUE_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ScopeInfo", "ResumeHandle", "PreferredMaximum", "OptionValues", "OptionsRead", "OptionsTotal"]),
        #
        'DhcpRemoveOptionValue': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "OptionID", "ScopeInfo"]),
        #
        'DhcpCreateClientInfoVQ': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32")}, name="DHCP_CLIENT_INFO_VQ", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpSetClientInfoVQ': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32")}, name="DHCP_CLIENT_INFO_VQ", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpGetClientInfoVQ': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SearchType": SimTypeInt(signed=False, label="DHCP_SEARCH_INFO_TYPE"), "SearchInfo": SimUnion({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_SEARCH_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32")}, name="DHCP_CLIENT_INFO_VQ", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SearchInfo", "ClientInfo"]),
        #
        'DhcpEnumSubnetClientsVQ': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Clients": SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32")}, name="DHCP_CLIENT_INFO_VQ", pack=False, align=None), offset=0), offset=0)}, name="DHCP_CLIENT_INFO_ARRAY_VQ", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ResumeHandle", "PreferredMaximum", "ClientInfo", "ClientsRead", "ClientsTotal"]),
        #
        'DhcpEnumSubnetClientsFilterStatusInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Clients": SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32"), "FilterStatus": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_CLIENT_FILTER_STATUS_INFO", pack=False, align=None), offset=0), offset=0)}, name="DHCP_CLIENT_FILTER_STATUS_INFO_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ResumeHandle", "PreferredMaximum", "ClientInfo", "ClientsRead", "ClientsTotal"]),
        #
        'DhcpCreateClientInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None)}, name="DHCP_CLIENT_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpSetClientInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None)}, name="DHCP_CLIENT_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpGetClientInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SearchType": SimTypeInt(signed=False, label="DHCP_SEARCH_INFO_TYPE"), "SearchInfo": SimUnion({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_SEARCH_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None)}, name="DHCP_CLIENT_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SearchInfo", "ClientInfo"]),
        #
        'DhcpDeleteClientInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SearchType": SimTypeInt(signed=False, label="DHCP_SEARCH_INFO_TYPE"), "SearchInfo": SimUnion({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_SEARCH_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpEnumSubnetClients': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Clients": SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None)}, name="DHCP_CLIENT_INFO", pack=False, align=None), offset=0), offset=0)}, name="DHCP_CLIENT_INFO_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ResumeHandle", "PreferredMaximum", "ClientInfo", "ClientsRead", "ClientsTotal"]),
        #
        'DhcpGetClientOptions': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumOptions": SimTypeInt(signed=False, label="UInt32"), "Options": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0)}, name="DHCP_OPTION_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientIpAddress", "ClientSubnetMask", "ClientOptions"]),
        #
        'DhcpGetMibInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Discovers": SimTypeInt(signed=False, label="UInt32"), "Offers": SimTypeInt(signed=False, label="UInt32"), "Requests": SimTypeInt(signed=False, label="UInt32"), "Acks": SimTypeInt(signed=False, label="UInt32"), "Naks": SimTypeInt(signed=False, label="UInt32"), "Declines": SimTypeInt(signed=False, label="UInt32"), "Releases": SimTypeInt(signed=False, label="UInt32"), "ServerStartTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "Scopes": SimTypeInt(signed=False, label="UInt32"), "ScopeInfo": SimTypePointer(SimStruct({"Subnet": SimTypeInt(signed=False, label="UInt32"), "NumAddressesInuse": SimTypeInt(signed=False, label="UInt32"), "NumAddressesFree": SimTypeInt(signed=False, label="UInt32"), "NumPendingOffers": SimTypeInt(signed=False, label="UInt32")}, name="SCOPE_MIB_INFO", pack=False, align=None), offset=0)}, name="DHCP_MIB_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "MibInfo"]),
        #
        'DhcpServerSetConfig': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"APIProtocolSupport": SimTypeInt(signed=False, label="UInt32"), "DatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DatabasePath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupInterval": SimTypeInt(signed=False, label="UInt32"), "DatabaseLoggingFlag": SimTypeInt(signed=False, label="UInt32"), "RestoreFlag": SimTypeInt(signed=False, label="UInt32"), "DatabaseCleanupInterval": SimTypeInt(signed=False, label="UInt32"), "DebugFlag": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_SERVER_CONFIG_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "FieldsToSet", "ConfigInfo"]),
        #
        'DhcpServerGetConfig': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"APIProtocolSupport": SimTypeInt(signed=False, label="UInt32"), "DatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DatabasePath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupInterval": SimTypeInt(signed=False, label="UInt32"), "DatabaseLoggingFlag": SimTypeInt(signed=False, label="UInt32"), "RestoreFlag": SimTypeInt(signed=False, label="UInt32"), "DatabaseCleanupInterval": SimTypeInt(signed=False, label="UInt32"), "DebugFlag": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_SERVER_CONFIG_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ConfigInfo"]),
        #
        'DhcpScanDatabase': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumScanItems": SimTypeInt(signed=False, label="UInt32"), "ScanItems": SimTypePointer(SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "ScanFlag": SimTypeInt(signed=False, label="DHCP_SCAN_FLAG")}, name="DHCP_SCAN_ITEM", pack=False, align=None), offset=0)}, name="DHCP_SCAN_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "FixFlag", "ScanList"]),
        #
        'DhcpRpcFreeMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["BufferPointer"]),
        #
        'DhcpGetVersion': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "MajorVersion", "MinorVersion"]),
        #
        'DhcpAddSubnetElementV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "SecondaryHost": SimTypePointer(SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0), "bAllowedClientTypes": SimTypeChar(label="Byte")}, name="DHCP_IP_RESERVATION_V4", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "IpUsedCluster": SimTypePointer(SimStruct({"ClusterAddress": SimTypeInt(signed=False, label="UInt32"), "ClusterMask": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_CLUSTER", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA_V4", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "AddElementInfo"]),
        #
        'DhcpEnumSubnetElementsV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "SecondaryHost": SimTypePointer(SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0), "bAllowedClientTypes": SimTypeChar(label="Byte")}, name="DHCP_IP_RESERVATION_V4", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "IpUsedCluster": SimTypePointer(SimStruct({"ClusterAddress": SimTypeInt(signed=False, label="UInt32"), "ClusterMask": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_CLUSTER", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA_V4", pack=False, align=None), offset=0)}, name="DHCP_SUBNET_ELEMENT_INFO_ARRAY_V4", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "EnumElementType", "ResumeHandle", "PreferredMaximum", "EnumElementInfo", "ElementsRead", "ElementsTotal"]),
        #
        'DhcpRemoveSubnetElementV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "SecondaryHost": SimTypePointer(SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0), "bAllowedClientTypes": SimTypeChar(label="Byte")}, name="DHCP_IP_RESERVATION_V4", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "IpUsedCluster": SimTypePointer(SimStruct({"ClusterAddress": SimTypeInt(signed=False, label="UInt32"), "ClusterMask": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_CLUSTER", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA_V4", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DHCP_FORCE_FLAG")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "RemoveElementInfo", "ForceFlag"]),
        #
        'DhcpCreateClientInfoV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte")}, name="DHCP_CLIENT_INFO_V4", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpSetClientInfoV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte")}, name="DHCP_CLIENT_INFO_V4", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpGetClientInfoV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SearchType": SimTypeInt(signed=False, label="DHCP_SEARCH_INFO_TYPE"), "SearchInfo": SimUnion({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_SEARCH_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte")}, name="DHCP_CLIENT_INFO_V4", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SearchInfo", "ClientInfo"]),
        #
        'DhcpEnumSubnetClientsV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Clients": SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte")}, name="DHCP_CLIENT_INFO_V4", pack=False, align=None), offset=0), offset=0)}, name="DHCP_CLIENT_INFO_ARRAY_V4", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ResumeHandle", "PreferredMaximum", "ClientInfo", "ClientsRead", "ClientsTotal"]),
        #
        'DhcpServerSetConfigV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"APIProtocolSupport": SimTypeInt(signed=False, label="UInt32"), "DatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DatabasePath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupInterval": SimTypeInt(signed=False, label="UInt32"), "DatabaseLoggingFlag": SimTypeInt(signed=False, label="UInt32"), "RestoreFlag": SimTypeInt(signed=False, label="UInt32"), "DatabaseCleanupInterval": SimTypeInt(signed=False, label="UInt32"), "DebugFlag": SimTypeInt(signed=False, label="UInt32"), "dwPingRetries": SimTypeInt(signed=False, label="UInt32"), "cbBootTableString": SimTypeInt(signed=False, label="UInt32"), "wszBootTableString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fAuditLog": SimTypeInt(signed=True, label="Int32")}, name="DHCP_SERVER_CONFIG_INFO_V4", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "FieldsToSet", "ConfigInfo"]),
        #
        'DhcpServerGetConfigV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"APIProtocolSupport": SimTypeInt(signed=False, label="UInt32"), "DatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DatabasePath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupInterval": SimTypeInt(signed=False, label="UInt32"), "DatabaseLoggingFlag": SimTypeInt(signed=False, label="UInt32"), "RestoreFlag": SimTypeInt(signed=False, label="UInt32"), "DatabaseCleanupInterval": SimTypeInt(signed=False, label="UInt32"), "DebugFlag": SimTypeInt(signed=False, label="UInt32"), "dwPingRetries": SimTypeInt(signed=False, label="UInt32"), "cbBootTableString": SimTypeInt(signed=False, label="UInt32"), "wszBootTableString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fAuditLog": SimTypeInt(signed=True, label="Int32")}, name="DHCP_SERVER_CONFIG_INFO_V4", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ConfigInfo"]),
        #
        'DhcpSetSuperScopeV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "SuperScopeName", "ChangeExisting"]),
        #
        'DhcpDeleteSuperScopeV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SuperScopeName"]),
        #
        'DhcpGetSuperScopeInfoV4': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cEntries": SimTypeInt(signed=False, label="UInt32"), "pEntries": SimTypePointer(SimStruct({"SubnetAddress": SimTypeInt(signed=False, label="UInt32"), "SuperScopeNumber": SimTypeInt(signed=False, label="UInt32"), "NextInSuperScope": SimTypeInt(signed=False, label="UInt32"), "SuperScopeName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_SUPER_SCOPE_TABLE_ENTRY", pack=False, align=None), offset=0)}, name="DHCP_SUPER_SCOPE_TABLE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SuperScopeTable"]),
        #
        'DhcpEnumSubnetClientsV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Clients": SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte")}, name="DHCP_CLIENT_INFO_V5", pack=False, align=None), offset=0), offset=0)}, name="DHCP_CLIENT_INFO_ARRAY_V5", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ResumeHandle", "PreferredMaximum", "ClientInfo", "ClientsRead", "ClientsTotal"]),
        #
        'DhcpCreateOptionV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionId", "ClassName", "VendorName", "OptionInfo"]),
        #
        'DhcpSetOptionInfoV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "ClassName", "VendorName", "OptionInfo"]),
        #
        'DhcpGetOptionInfoV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "ClassName", "VendorName", "OptionInfo"]),
        #
        'DhcpEnumOptionsV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Options": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)}, name="DHCP_OPTION_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "ClassName", "VendorName", "ResumeHandle", "PreferredMaximum", "Options", "OptionsRead", "OptionsTotal"]),
        #
        'DhcpRemoveOptionV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "ClassName", "VendorName"]),
        #
        'DhcpSetOptionValueV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionId", "ClassName", "VendorName", "ScopeInfo", "OptionValue"]),
        #
        'DhcpSetOptionValuesV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Values": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0)}, name="DHCP_OPTION_VALUE_ARRAY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "ClassName", "VendorName", "ScopeInfo", "OptionValues"]),
        #
        'DhcpGetOptionValueV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "ClassName", "VendorName", "ScopeInfo", "OptionValue"]),
        #
        'DhcpGetOptionValueV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE6"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedIpSubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_RESERVED_SCOPE6", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO6", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "ClassName", "VendorName", "ScopeInfo", "OptionValue"]),
        #
        'DhcpEnumOptionValuesV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Values": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0)}, name="DHCP_OPTION_VALUE_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "ClassName", "VendorName", "ScopeInfo", "ResumeHandle", "PreferredMaximum", "OptionValues", "OptionsRead", "OptionsTotal"]),
        #
        'DhcpRemoveOptionValueV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "ClassName", "VendorName", "ScopeInfo"]),
        #
        'DhcpCreateClass': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassDataLength": SimTypeInt(signed=False, label="UInt32"), "IsVendor": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "ClassData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_CLASS_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ReservedMustBeZero", "ClassInfo"]),
        #
        'DhcpModifyClass': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassDataLength": SimTypeInt(signed=False, label="UInt32"), "IsVendor": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "ClassData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_CLASS_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ReservedMustBeZero", "ClassInfo"]),
        #
        'DhcpDeleteClass': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ReservedMustBeZero", "ClassName"]),
        #
        'DhcpGetClassInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassDataLength": SimTypeInt(signed=False, label="UInt32"), "IsVendor": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "ClassData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_CLASS_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassDataLength": SimTypeInt(signed=False, label="UInt32"), "IsVendor": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "ClassData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_CLASS_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ReservedMustBeZero", "PartialClassInfo", "FilledClassInfo"]),
        #
        'DhcpEnumClasses': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Classes": SimTypePointer(SimStruct({"ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassDataLength": SimTypeInt(signed=False, label="UInt32"), "IsVendor": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "ClassData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_CLASS_INFO", pack=False, align=None), offset=0)}, name="DHCP_CLASS_INFO_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ReservedMustBeZero", "ResumeHandle", "PreferredMaximum", "ClassInfoArray", "nRead", "nTotal"]),
        #
        'DhcpGetAllOptions': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "NonVendorOptions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Options": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)}, name="DHCP_OPTION_ARRAY", pack=False, align=None), offset=0), "NumVendorOptions": SimTypeInt(signed=False, label="UInt32"), "VendorOptions": SimTypePointer(SimStruct({"Option": SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="DHCP_ALL_OPTIONS", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionStruct"]),
        #
        'DhcpGetAllOptionsV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "NonVendorOptions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Options": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)}, name="DHCP_OPTION_ARRAY", pack=False, align=None), offset=0), "NumVendorOptions": SimTypeInt(signed=False, label="UInt32"), "VendorOptions": SimTypePointer(SimStruct({"Option": SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="DHCP_ALL_OPTIONS", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionStruct"]),
        #
        'DhcpGetAllOptionValues': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "NumElements": SimTypeInt(signed=False, label="UInt32"), "Options": SimTypePointer(SimStruct({"ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsVendor": SimTypeInt(signed=True, label="Int32"), "OptionsArray": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Values": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0)}, name="DHCP_OPTION_VALUE_ARRAY", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="DHCP_ALL_OPTION_VALUES", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "ScopeInfo", "Values"]),
        #
        'DhcpGetAllOptionValuesV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE6"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedIpSubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_RESERVED_SCOPE6", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO6", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "NumElements": SimTypeInt(signed=False, label="UInt32"), "Options": SimTypePointer(SimStruct({"ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsVendor": SimTypeInt(signed=True, label="Int32"), "OptionsArray": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Values": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0)}, name="DHCP_OPTION_VALUE_ARRAY", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="DHCP_ALL_OPTION_VALUES", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "ScopeInfo", "Values"]),
        #
        'DhcpEnumServers': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "NumElements": SimTypeInt(signed=False, label="UInt32"), "Servers": SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "ServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ServerAddress": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="UInt32"), "DsLocation": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DsLocType": SimTypeInt(signed=False, label="UInt32")}, name="DHCPDS_SERVER", pack=False, align=None), offset=0)}, name="DHCPDS_SERVERS", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Flags", "IdInfo", "Servers", "CallbackFn", "CallbackData"]),
        #
        'DhcpAddServer': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "ServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ServerAddress": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="UInt32"), "DsLocation": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DsLocType": SimTypeInt(signed=False, label="UInt32")}, name="DHCPDS_SERVER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Flags", "IdInfo", "NewServer", "CallbackFn", "CallbackData"]),
        #
        'DhcpDeleteServer': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "ServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ServerAddress": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="UInt32"), "DsLocation": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DsLocType": SimTypeInt(signed=False, label="UInt32")}, name="DHCPDS_SERVER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Flags", "IdInfo", "NewServer", "CallbackFn", "CallbackData"]),
        #
        'DhcpGetServerBindingInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "fBoundToDHCPServer": SimTypeInt(signed=True, label="Int32"), "AdapterPrimaryAddress": SimTypeInt(signed=False, label="UInt32"), "AdapterSubnetAddress": SimTypeInt(signed=False, label="UInt32"), "IfDescription": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IfIdSize": SimTypeInt(signed=False, label="UInt32"), "IfId": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BIND_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_BIND_ELEMENT_ARRAY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "BindElementsInfo"]),
        #
        'DhcpSetServerBindingInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "fBoundToDHCPServer": SimTypeInt(signed=True, label="Int32"), "AdapterPrimaryAddress": SimTypeInt(signed=False, label="UInt32"), "AdapterSubnetAddress": SimTypeInt(signed=False, label="UInt32"), "IfDescription": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IfIdSize": SimTypeInt(signed=False, label="UInt32"), "IfId": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BIND_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_BIND_ELEMENT_ARRAY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "BindElementInfo"]),
        #
        'DhcpAddSubnetElementV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32"), "BootpAllocated": SimTypeInt(signed=False, label="UInt32"), "MaxBootpAllowed": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_BOOTP_IP_RANGE", pack=False, align=None), offset=0), "SecondaryHost": SimTypePointer(SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0), "bAllowedClientTypes": SimTypeChar(label="Byte")}, name="DHCP_IP_RESERVATION_V4", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "IpUsedCluster": SimTypePointer(SimStruct({"ClusterAddress": SimTypeInt(signed=False, label="UInt32"), "ClusterMask": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_CLUSTER", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA_V5", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "AddElementInfo"]),
        #
        'DhcpEnumSubnetElementsV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32"), "BootpAllocated": SimTypeInt(signed=False, label="UInt32"), "MaxBootpAllowed": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_BOOTP_IP_RANGE", pack=False, align=None), offset=0), "SecondaryHost": SimTypePointer(SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0), "bAllowedClientTypes": SimTypeChar(label="Byte")}, name="DHCP_IP_RESERVATION_V4", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "IpUsedCluster": SimTypePointer(SimStruct({"ClusterAddress": SimTypeInt(signed=False, label="UInt32"), "ClusterMask": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_CLUSTER", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA_V5", pack=False, align=None), offset=0)}, name="DHCP_SUBNET_ELEMENT_INFO_ARRAY_V5", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "EnumElementType", "ResumeHandle", "PreferredMaximum", "EnumElementInfo", "ElementsRead", "ElementsTotal"]),
        #
        'DhcpRemoveSubnetElementV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32"), "BootpAllocated": SimTypeInt(signed=False, label="UInt32"), "MaxBootpAllowed": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_BOOTP_IP_RANGE", pack=False, align=None), offset=0), "SecondaryHost": SimTypePointer(SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0), "bAllowedClientTypes": SimTypeChar(label="Byte")}, name="DHCP_IP_RESERVATION_V4", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0), "IpUsedCluster": SimTypePointer(SimStruct({"ClusterAddress": SimTypeInt(signed=False, label="UInt32"), "ClusterMask": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_CLUSTER", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA_V5", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DHCP_FORCE_FLAG")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "RemoveElementInfo", "ForceFlag"]),
        #
        'DhcpV4EnumSubnetReservations': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimTypePointer(SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedForClient": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ReservedClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ReservedClientDesc": SimTypePointer(SimTypeChar(label="Char"), offset=0), "bAllowedClientTypes": SimTypeChar(label="Byte"), "fOptionsPresent": SimTypeChar(label="Byte")}, name="DHCP_IP_RESERVATION_INFO", pack=False, align=None), offset=0), offset=0)}, name="DHCP_RESERVATION_INFO_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ResumeHandle", "PreferredMaximum", "EnumElementInfo", "ElementsRead", "ElementsTotal"]),
        #
        'DhcpCreateOptionV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionId", "ClassName", "VendorName", "OptionInfo"]),
        #
        'DhcpRemoveOptionV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "ClassName", "VendorName"]),
        #
        'DhcpEnumOptionsV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Options": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)}, name="DHCP_OPTION_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "ClassName", "VendorName", "ResumeHandle", "PreferredMaximum", "Options", "OptionsRead", "OptionsTotal"]),
        #
        'DhcpRemoveOptionValueV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE6"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedIpSubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_RESERVED_SCOPE6", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO6", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "ClassName", "VendorName", "ScopeInfo"]),
        #
        'DhcpGetOptionInfoV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "ClassName", "VendorName", "OptionInfo"]),
        #
        'DhcpSetOptionInfoV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "OptionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "OptionComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultValue": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), "OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_TYPE")}, name="DHCP_OPTION", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "ClassName", "VendorName", "OptionInfo"]),
        #
        'DhcpSetOptionValueV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE6"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedIpSubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_RESERVED_SCOPE6", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO6", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionId", "ClassName", "VendorName", "ScopeInfo", "OptionValue"]),
        #
        'DhcpGetSubnetInfoVQ': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"SubnetAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "SubnetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SubnetComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "SubnetState": SimTypeInt(signed=False, label="DHCP_SUBNET_STATE"), "QuarantineOn": SimTypeInt(signed=False, label="UInt32"), "Reserved1": SimTypeInt(signed=False, label="UInt32"), "Reserved2": SimTypeInt(signed=False, label="UInt32"), "Reserved3": SimTypeLongLong(signed=True, label="Int64"), "Reserved4": SimTypeLongLong(signed=True, label="Int64")}, name="DHCP_SUBNET_INFO_VQ", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "SubnetInfo"]),
        #
        'DhcpCreateSubnetVQ': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SubnetAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "SubnetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SubnetComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "SubnetState": SimTypeInt(signed=False, label="DHCP_SUBNET_STATE"), "QuarantineOn": SimTypeInt(signed=False, label="UInt32"), "Reserved1": SimTypeInt(signed=False, label="UInt32"), "Reserved2": SimTypeInt(signed=False, label="UInt32"), "Reserved3": SimTypeLongLong(signed=True, label="Int64"), "Reserved4": SimTypeLongLong(signed=True, label="Int64")}, name="DHCP_SUBNET_INFO_VQ", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "SubnetInfo"]),
        #
        'DhcpSetSubnetInfoVQ': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SubnetAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "SubnetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SubnetComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "SubnetState": SimTypeInt(signed=False, label="DHCP_SUBNET_STATE"), "QuarantineOn": SimTypeInt(signed=False, label="UInt32"), "Reserved1": SimTypeInt(signed=False, label="UInt32"), "Reserved2": SimTypeInt(signed=False, label="UInt32"), "Reserved3": SimTypeLongLong(signed=True, label="Int64"), "Reserved4": SimTypeLongLong(signed=True, label="Int64")}, name="DHCP_SUBNET_INFO_VQ", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "SubnetInfo"]),
        #
        'DhcpEnumOptionValuesV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE6"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedIpSubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_RESERVED_SCOPE6", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO6", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Values": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0)}, name="DHCP_OPTION_VALUE_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "ClassName", "VendorName", "ScopeInfo", "ResumeHandle", "PreferredMaximum", "OptionValues", "OptionsRead", "OptionsTotal"]),
        #
        'DhcpDsInit': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        #
        'DhcpDsCleanup': SimTypeFunction([], SimTypeBottom(label="Void")),
        #
        'DhcpSetThreadOptions': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Flags", "Reserved"]),
        #
        'DhcpGetThreadOptions': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pFlags", "Reserved"]),
        #
        'DhcpServerQueryAttribute': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"DhcpAttribId": SimTypeInt(signed=False, label="UInt32"), "DhcpAttribType": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DhcpAttribBool": SimTypeInt(signed=True, label="Int32"), "DhcpAttribUlong": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="DHCP_ATTRIB", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddr", "dwReserved", "DhcpAttribId", "pDhcpAttrib"]),
        #
        'DhcpServerQueryAttributes': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "DhcpAttribs": SimTypePointer(SimStruct({"DhcpAttribId": SimTypeInt(signed=False, label="UInt32"), "DhcpAttribType": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DhcpAttribBool": SimTypeInt(signed=True, label="Int32"), "DhcpAttribUlong": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="DHCP_ATTRIB", pack=False, align=None), offset=0)}, name="DHCP_ATTRIB_ARRAY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddr", "dwReserved", "dwAttribCount", "pDhcpAttribs", "pDhcpAttribArr"]),
        #
        'DhcpServerRedoAuthorization': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddr", "dwReserved"]),
        #
        'DhcpAuditLogSetParams': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "AuditLogDir", "DiskCheckInterval", "MaxLogFilesSize", "MinSpaceOnDisk"]),
        #
        'DhcpAuditLogGetParams': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "AuditLogDir", "DiskCheckInterval", "MaxLogFilesSize", "MinSpaceOnDisk"]),
        #
        'DhcpServerQueryDnsRegCredentials': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "UnameSize", "Uname", "DomainSize", "Domain"]),
        #
        'DhcpServerSetDnsRegCredentials': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Uname", "Domain", "Passwd"]),
        #
        'DhcpServerSetDnsRegCredentialsV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Uname", "Domain", "Passwd"]),
        #
        'DhcpServerBackupDatabase': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Path"]),
        #
        'DhcpServerRestoreDatabase': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Path"]),
        #
        'DhcpServerSetConfigVQ': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"APIProtocolSupport": SimTypeInt(signed=False, label="UInt32"), "DatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DatabasePath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupInterval": SimTypeInt(signed=False, label="UInt32"), "DatabaseLoggingFlag": SimTypeInt(signed=False, label="UInt32"), "RestoreFlag": SimTypeInt(signed=False, label="UInt32"), "DatabaseCleanupInterval": SimTypeInt(signed=False, label="UInt32"), "DebugFlag": SimTypeInt(signed=False, label="UInt32"), "dwPingRetries": SimTypeInt(signed=False, label="UInt32"), "cbBootTableString": SimTypeInt(signed=False, label="UInt32"), "wszBootTableString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fAuditLog": SimTypeInt(signed=True, label="Int32"), "QuarantineOn": SimTypeInt(signed=True, label="Int32"), "QuarDefFail": SimTypeInt(signed=False, label="UInt32"), "QuarRuntimeStatus": SimTypeInt(signed=True, label="Int32")}, name="DHCP_SERVER_CONFIG_INFO_VQ", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "FieldsToSet", "ConfigInfo"]),
        #
        'DhcpServerGetConfigVQ': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"APIProtocolSupport": SimTypeInt(signed=False, label="UInt32"), "DatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DatabasePath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupInterval": SimTypeInt(signed=False, label="UInt32"), "DatabaseLoggingFlag": SimTypeInt(signed=False, label="UInt32"), "RestoreFlag": SimTypeInt(signed=False, label="UInt32"), "DatabaseCleanupInterval": SimTypeInt(signed=False, label="UInt32"), "DebugFlag": SimTypeInt(signed=False, label="UInt32"), "dwPingRetries": SimTypeInt(signed=False, label="UInt32"), "cbBootTableString": SimTypeInt(signed=False, label="UInt32"), "wszBootTableString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fAuditLog": SimTypeInt(signed=True, label="Int32"), "QuarantineOn": SimTypeInt(signed=True, label="Int32"), "QuarDefFail": SimTypeInt(signed=False, label="UInt32"), "QuarRuntimeStatus": SimTypeInt(signed=True, label="Int32")}, name="DHCP_SERVER_CONFIG_INFO_VQ", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ConfigInfo"]),
        #
        'DhcpGetServerSpecificStrings': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"DefaultVendorClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DefaultUserClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_SERVER_SPECIFIC_STRINGS", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ServerSpecificStrings"]),
        #
        'DhcpServerAuditlogParamsFree': SimTypeFunction([SimTypePointer(SimStruct({"APIProtocolSupport": SimTypeInt(signed=False, label="UInt32"), "DatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DatabasePath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BackupInterval": SimTypeInt(signed=False, label="UInt32"), "DatabaseLoggingFlag": SimTypeInt(signed=False, label="UInt32"), "RestoreFlag": SimTypeInt(signed=False, label="UInt32"), "DatabaseCleanupInterval": SimTypeInt(signed=False, label="UInt32"), "DebugFlag": SimTypeInt(signed=False, label="UInt32"), "dwPingRetries": SimTypeInt(signed=False, label="UInt32"), "cbBootTableString": SimTypeInt(signed=False, label="UInt32"), "wszBootTableString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fAuditLog": SimTypeInt(signed=True, label="Int32"), "QuarantineOn": SimTypeInt(signed=True, label="Int32"), "QuarDefFail": SimTypeInt(signed=False, label="UInt32"), "QuarRuntimeStatus": SimTypeInt(signed=True, label="Int32")}, name="DHCP_SERVER_CONFIG_INFO_VQ", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["ConfigInfo"]),
        #
        'DhcpCreateSubnetV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypePointer(SimStruct({"SubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "Prefix": SimTypeInt(signed=False, label="UInt32"), "Preference": SimTypeShort(signed=False, label="UInt16"), "SubnetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SubnetComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "State": SimTypeInt(signed=False, label="UInt32"), "ScopeId": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_SUBNET_INFO_V6", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "SubnetInfo"]),
        #
        'DhcpDeleteSubnetV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypeInt(signed=False, label="DHCP_FORCE_FLAG")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ForceFlag"]),
        #
        'DhcpEnumSubnetsV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), offset=0)}, name="DHCPV6_IP_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ResumeHandle", "PreferredMaximum", "EnumInfo", "ElementsRead", "ElementsTotal"]),
        #
        'DhcpAddSubnetElementV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE_V6"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "EndAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_IP_RANGE_V6", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0), "InterfaceId": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RESERVATION_V6", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "EndAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_IP_RANGE_V6", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA_V6", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "AddElementInfo"]),
        #
        'DhcpRemoveSubnetElementV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE_V6"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "EndAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_IP_RANGE_V6", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0), "InterfaceId": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RESERVATION_V6", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "EndAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_IP_RANGE_V6", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA_V6", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DHCP_FORCE_FLAG")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "RemoveElementInfo", "ForceFlag"]),
        #
        'DhcpEnumSubnetElementsV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE_V6"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ElementType": SimTypeInt(signed=False, label="DHCP_SUBNET_ELEMENT_TYPE_V6"), "Element": SimUnion({"IpRange": SimTypePointer(SimStruct({"StartAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "EndAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_IP_RANGE_V6", pack=False, align=None), offset=0), "ReservedIp": SimTypePointer(SimStruct({"ReservedIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedForClient": SimTypePointer(SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), offset=0), "InterfaceId": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RESERVATION_V6", pack=False, align=None), offset=0), "ExcludeIpRange": SimTypePointer(SimStruct({"StartAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "EndAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_IP_RANGE_V6", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="DHCP_SUBNET_ELEMENT_DATA_V6", pack=False, align=None), offset=0)}, name="DHCP_SUBNET_ELEMENT_INFO_ARRAY_V6", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "EnumElementType", "ResumeHandle", "PreferredMaximum", "EnumElementInfo", "ElementsRead", "ElementsTotal"]),
        #
        'DhcpGetSubnetInfoV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypePointer(SimTypePointer(SimStruct({"SubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "Prefix": SimTypeInt(signed=False, label="UInt32"), "Preference": SimTypeShort(signed=False, label="UInt16"), "SubnetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SubnetComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "State": SimTypeInt(signed=False, label="UInt32"), "ScopeId": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_SUBNET_INFO_V6", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "SubnetInfo"]),
        #
        'DhcpEnumSubnetClientsV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypePointer(SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Clients": SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ClientDUID": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "AddressType": SimTypeInt(signed=False, label="UInt32"), "IAID": SimTypeInt(signed=False, label="UInt32"), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientValidLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "ClientPrefLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO_V6", pack=False, align=None)}, name="DHCP_CLIENT_INFO_V6", pack=False, align=None), offset=0), offset=0)}, name="DHCP_CLIENT_INFO_ARRAY_V6", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ResumeHandle", "PreferredMaximum", "ClientInfo", "ClientsRead", "ClientsTotal"]),
        #
        'DhcpServerGetConfigV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE6"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedIpSubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_RESERVED_SCOPE6", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO6", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"UnicastFlag": SimTypeInt(signed=True, label="Int32"), "RapidCommitFlag": SimTypeInt(signed=True, label="Int32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "T1": SimTypeInt(signed=False, label="UInt32"), "T2": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetimeIATA": SimTypeInt(signed=False, label="UInt32"), "ValidLifetimeIATA": SimTypeInt(signed=False, label="UInt32"), "fAuditLog": SimTypeInt(signed=True, label="Int32")}, name="DHCP_SERVER_CONFIG_INFO_V6", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ScopeInfo", "ConfigInfo"]),
        #
        'DhcpServerSetConfigV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE6"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ReservedIpSubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None)}, name="DHCP_RESERVED_SCOPE6", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO6", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"UnicastFlag": SimTypeInt(signed=True, label="Int32"), "RapidCommitFlag": SimTypeInt(signed=True, label="Int32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "T1": SimTypeInt(signed=False, label="UInt32"), "T2": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetimeIATA": SimTypeInt(signed=False, label="UInt32"), "ValidLifetimeIATA": SimTypeInt(signed=False, label="UInt32"), "fAuditLog": SimTypeInt(signed=True, label="Int32")}, name="DHCP_SERVER_CONFIG_INFO_V6", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ScopeInfo", "FieldsToSet", "ConfigInfo"]),
        #
        'DhcpSetSubnetInfoV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypePointer(SimStruct({"SubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "Prefix": SimTypeInt(signed=False, label="UInt32"), "Preference": SimTypeShort(signed=False, label="UInt16"), "SubnetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SubnetComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "State": SimTypeInt(signed=False, label="UInt32"), "ScopeId": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_SUBNET_INFO_V6", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "SubnetInfo"]),
        #
        'DhcpGetMibInfoV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Solicits": SimTypeInt(signed=False, label="UInt32"), "Advertises": SimTypeInt(signed=False, label="UInt32"), "Requests": SimTypeInt(signed=False, label="UInt32"), "Renews": SimTypeInt(signed=False, label="UInt32"), "Rebinds": SimTypeInt(signed=False, label="UInt32"), "Replies": SimTypeInt(signed=False, label="UInt32"), "Confirms": SimTypeInt(signed=False, label="UInt32"), "Declines": SimTypeInt(signed=False, label="UInt32"), "Releases": SimTypeInt(signed=False, label="UInt32"), "Informs": SimTypeInt(signed=False, label="UInt32"), "ServerStartTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "Scopes": SimTypeInt(signed=False, label="UInt32"), "ScopeInfo": SimTypePointer(SimStruct({"Subnet": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "NumAddressesInuse": SimTypeLongLong(signed=False, label="UInt64"), "NumAddressesFree": SimTypeLongLong(signed=False, label="UInt64"), "NumPendingAdvertises": SimTypeLongLong(signed=False, label="UInt64")}, name="SCOPE_MIB_INFO_V6", pack=False, align=None), offset=0)}, name="DHCP_MIB_INFO_V6", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "MibInfo"]),
        #
        'DhcpGetServerBindingInfoV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "fBoundToDHCPServer": SimTypeInt(signed=True, label="Int32"), "AdapterPrimaryAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "AdapterSubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "IfDescription": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IpV6IfIndex": SimTypeInt(signed=False, label="UInt32"), "IfIdSize": SimTypeInt(signed=False, label="UInt32"), "IfId": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCPV6_BIND_ELEMENT", pack=False, align=None), offset=0)}, name="DHCPV6_BIND_ELEMENT_ARRAY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "BindElementsInfo"]),
        #
        'DhcpSetServerBindingInfoV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "fBoundToDHCPServer": SimTypeInt(signed=True, label="Int32"), "AdapterPrimaryAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "AdapterSubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "IfDescription": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IpV6IfIndex": SimTypeInt(signed=False, label="UInt32"), "IfIdSize": SimTypeInt(signed=False, label="UInt32"), "IfId": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCPV6_BIND_ELEMENT", pack=False, align=None), offset=0)}, name="DHCPV6_BIND_ELEMENT_ARRAY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "BindElementInfo"]),
        #
        'DhcpSetClientInfoV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ClientIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ClientDUID": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "AddressType": SimTypeInt(signed=False, label="UInt32"), "IAID": SimTypeInt(signed=False, label="UInt32"), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientValidLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "ClientPrefLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO_V6", pack=False, align=None)}, name="DHCP_CLIENT_INFO_V6", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpGetClientInfoV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SearchType": SimTypeInt(signed=False, label="DHCP_SEARCH_INFO_TYPE_V6"), "SearchInfo": SimUnion({"ClientIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ClientDUID": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_SEARCH_INFO_V6", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ClientDUID": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "AddressType": SimTypeInt(signed=False, label="UInt32"), "IAID": SimTypeInt(signed=False, label="UInt32"), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientValidLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "ClientPrefLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO_V6", pack=False, align=None)}, name="DHCP_CLIENT_INFO_V6", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SearchInfo", "ClientInfo"]),
        #
        'DhcpDeleteClientInfoV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SearchType": SimTypeInt(signed=False, label="DHCP_SEARCH_INFO_TYPE_V6"), "SearchInfo": SimUnion({"ClientIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ClientDUID": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_SEARCH_INFO_V6", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpCreateClassV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassDataLength": SimTypeInt(signed=False, label="UInt32"), "IsVendor": SimTypeInt(signed=True, label="Int32"), "EnterpriseNumber": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "ClassData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_CLASS_INFO_V6", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ReservedMustBeZero", "ClassInfo"]),
        #
        'DhcpModifyClassV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassDataLength": SimTypeInt(signed=False, label="UInt32"), "IsVendor": SimTypeInt(signed=True, label="Int32"), "EnterpriseNumber": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "ClassData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_CLASS_INFO_V6", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ReservedMustBeZero", "ClassInfo"]),
        #
        'DhcpDeleteClassV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ReservedMustBeZero", "ClassName"]),
        #
        'DhcpEnumClassesV6': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Classes": SimTypePointer(SimStruct({"ClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClassDataLength": SimTypeInt(signed=False, label="UInt32"), "IsVendor": SimTypeInt(signed=True, label="Int32"), "EnterpriseNumber": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "ClassData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_CLASS_INFO_V6", pack=False, align=None), offset=0)}, name="DHCP_CLASS_INFO_ARRAY_V6", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ReservedMustBeZero", "ResumeHandle", "PreferredMaximum", "ClassInfoArray", "nRead", "nTotal"]),
        #
        'DhcpSetSubnetDelayOffer': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "TimeDelayInMilliseconds"]),
        #
        'DhcpGetSubnetDelayOffer': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "TimeDelayInMilliseconds"]),
        #
        'DhcpGetMibInfoV5': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Discovers": SimTypeInt(signed=False, label="UInt32"), "Offers": SimTypeInt(signed=False, label="UInt32"), "Requests": SimTypeInt(signed=False, label="UInt32"), "Acks": SimTypeInt(signed=False, label="UInt32"), "Naks": SimTypeInt(signed=False, label="UInt32"), "Declines": SimTypeInt(signed=False, label="UInt32"), "Releases": SimTypeInt(signed=False, label="UInt32"), "ServerStartTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QtnNumLeases": SimTypeInt(signed=False, label="UInt32"), "QtnPctQtnLeases": SimTypeInt(signed=False, label="UInt32"), "QtnProbationLeases": SimTypeInt(signed=False, label="UInt32"), "QtnNonQtnLeases": SimTypeInt(signed=False, label="UInt32"), "QtnExemptLeases": SimTypeInt(signed=False, label="UInt32"), "QtnCapableClients": SimTypeInt(signed=False, label="UInt32"), "QtnIASErrors": SimTypeInt(signed=False, label="UInt32"), "DelayedOffers": SimTypeInt(signed=False, label="UInt32"), "ScopesWithDelayedOffers": SimTypeInt(signed=False, label="UInt32"), "Scopes": SimTypeInt(signed=False, label="UInt32"), "ScopeInfo": SimTypePointer(SimStruct({"Subnet": SimTypeInt(signed=False, label="UInt32"), "NumAddressesInuse": SimTypeInt(signed=False, label="UInt32"), "NumAddressesFree": SimTypeInt(signed=False, label="UInt32"), "NumPendingOffers": SimTypeInt(signed=False, label="UInt32")}, name="SCOPE_MIB_INFO_V5", pack=False, align=None), offset=0)}, name="DHCP_MIB_INFO_V5", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "MibInfo"]),
        #
        'DhcpAddSecurityGroup': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pServer"]),
        #
        'DhcpV4GetOptionValue': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "PolicyName", "VendorName", "ScopeInfo", "OptionValue"]),
        #
        'DhcpV4SetOptionValue': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionId", "PolicyName", "VendorName", "ScopeInfo", "OptionValue"]),
        #
        'DhcpV4SetOptionValues': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Values": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0)}, name="DHCP_OPTION_VALUE_ARRAY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "PolicyName", "VendorName", "ScopeInfo", "OptionValues"]),
        #
        'DhcpV4RemoveOptionValue': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "OptionID", "PolicyName", "VendorName", "ScopeInfo"]),
        #
        'DhcpV4GetAllOptionValues': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ScopeType": SimTypeInt(signed=False, label="DHCP_OPTION_SCOPE_TYPE"), "ScopeInfo": SimUnion({"DefaultScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "GlobalScopeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SubnetScopeInfo": SimTypeInt(signed=False, label="UInt32"), "ReservedScopeInfo": SimStruct({"ReservedIpAddress": SimTypeInt(signed=False, label="UInt32"), "ReservedIpSubnetAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_RESERVED_SCOPE", pack=False, align=None), "MScopeInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_SCOPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "NumElements": SimTypeInt(signed=False, label="UInt32"), "Options": SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsVendor": SimTypeInt(signed=True, label="Int32"), "OptionsArray": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Values": SimTypePointer(SimStruct({"OptionID": SimTypeInt(signed=False, label="UInt32"), "Value": SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"OptionType": SimTypeInt(signed=False, label="DHCP_OPTION_DATA_TYPE"), "Element": SimUnion({"ByteOption": SimTypeChar(label="Byte"), "WordOption": SimTypeShort(signed=False, label="UInt16"), "DWordOption": SimTypeInt(signed=False, label="UInt32"), "DWordDWordOption": SimStruct({"DWord1": SimTypeInt(signed=False, label="UInt32"), "DWord2": SimTypeInt(signed=False, label="UInt32")}, name="DWORD_DWORD", pack=False, align=None), "IpAddressOption": SimTypeInt(signed=False, label="UInt32"), "StringDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "EncapsulatedDataOption": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "Ipv6AddressDataOption": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_OPTION_DATA_ELEMENT", pack=False, align=None), offset=0)}, name="DHCP_OPTION_DATA", pack=False, align=None)}, name="DHCP_OPTION_VALUE", pack=False, align=None), offset=0)}, name="DHCP_OPTION_VALUE_ARRAY", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="DHCP_ALL_OPTION_VALUES_PB", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "ScopeInfo", "Values"]),
        #
        'DhcpV4FailoverCreateRelationship': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"PrimaryServer": SimTypeInt(signed=False, label="UInt32"), "SecondaryServer": SimTypeInt(signed=False, label="UInt32"), "Mode": SimTypeInt(signed=False, label="DHCP_FAILOVER_MODE"), "ServerType": SimTypeInt(signed=False, label="DHCP_FAILOVER_SERVER"), "State": SimTypeInt(signed=False, label="FSM_STATE"), "PrevState": SimTypeInt(signed=False, label="FSM_STATE"), "Mclt": SimTypeInt(signed=False, label="UInt32"), "SafePeriod": SimTypeInt(signed=False, label="UInt32"), "RelationshipName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SecondaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pScopes": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)}, name="DHCP_IP_ARRAY", pack=False, align=None), offset=0), "Percentage": SimTypeChar(label="Byte"), "SharedSecret": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_FAILOVER_RELATIONSHIP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "pRelationship"]),
        #
        'DhcpV4FailoverSetRelationship': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"PrimaryServer": SimTypeInt(signed=False, label="UInt32"), "SecondaryServer": SimTypeInt(signed=False, label="UInt32"), "Mode": SimTypeInt(signed=False, label="DHCP_FAILOVER_MODE"), "ServerType": SimTypeInt(signed=False, label="DHCP_FAILOVER_SERVER"), "State": SimTypeInt(signed=False, label="FSM_STATE"), "PrevState": SimTypeInt(signed=False, label="FSM_STATE"), "Mclt": SimTypeInt(signed=False, label="UInt32"), "SafePeriod": SimTypeInt(signed=False, label="UInt32"), "RelationshipName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SecondaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pScopes": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)}, name="DHCP_IP_ARRAY", pack=False, align=None), offset=0), "Percentage": SimTypeChar(label="Byte"), "SharedSecret": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_FAILOVER_RELATIONSHIP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "Flags", "pRelationship"]),
        #
        'DhcpV4FailoverDeleteRelationship': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "pRelationshipName"]),
        #
        'DhcpV4FailoverGetRelationship': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"PrimaryServer": SimTypeInt(signed=False, label="UInt32"), "SecondaryServer": SimTypeInt(signed=False, label="UInt32"), "Mode": SimTypeInt(signed=False, label="DHCP_FAILOVER_MODE"), "ServerType": SimTypeInt(signed=False, label="DHCP_FAILOVER_SERVER"), "State": SimTypeInt(signed=False, label="FSM_STATE"), "PrevState": SimTypeInt(signed=False, label="FSM_STATE"), "Mclt": SimTypeInt(signed=False, label="UInt32"), "SafePeriod": SimTypeInt(signed=False, label="UInt32"), "RelationshipName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SecondaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pScopes": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)}, name="DHCP_IP_ARRAY", pack=False, align=None), offset=0), "Percentage": SimTypeChar(label="Byte"), "SharedSecret": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_FAILOVER_RELATIONSHIP", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "pRelationshipName", "pRelationship"]),
        #
        'DhcpV4FailoverEnumRelationship': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "pRelationships": SimTypePointer(SimStruct({"PrimaryServer": SimTypeInt(signed=False, label="UInt32"), "SecondaryServer": SimTypeInt(signed=False, label="UInt32"), "Mode": SimTypeInt(signed=False, label="DHCP_FAILOVER_MODE"), "ServerType": SimTypeInt(signed=False, label="DHCP_FAILOVER_SERVER"), "State": SimTypeInt(signed=False, label="FSM_STATE"), "PrevState": SimTypeInt(signed=False, label="FSM_STATE"), "Mclt": SimTypeInt(signed=False, label="UInt32"), "SafePeriod": SimTypeInt(signed=False, label="UInt32"), "RelationshipName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SecondaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pScopes": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)}, name="DHCP_IP_ARRAY", pack=False, align=None), offset=0), "Percentage": SimTypeChar(label="Byte"), "SharedSecret": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_FAILOVER_RELATIONSHIP", pack=False, align=None), offset=0)}, name="DHCP_FAILOVER_RELATIONSHIP_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ResumeHandle", "PreferredMaximum", "pRelationship", "RelationshipRead", "RelationshipTotal"]),
        #
        'DhcpV4FailoverAddScopeToRelationship': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"PrimaryServer": SimTypeInt(signed=False, label="UInt32"), "SecondaryServer": SimTypeInt(signed=False, label="UInt32"), "Mode": SimTypeInt(signed=False, label="DHCP_FAILOVER_MODE"), "ServerType": SimTypeInt(signed=False, label="DHCP_FAILOVER_SERVER"), "State": SimTypeInt(signed=False, label="FSM_STATE"), "PrevState": SimTypeInt(signed=False, label="FSM_STATE"), "Mclt": SimTypeInt(signed=False, label="UInt32"), "SafePeriod": SimTypeInt(signed=False, label="UInt32"), "RelationshipName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SecondaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pScopes": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)}, name="DHCP_IP_ARRAY", pack=False, align=None), offset=0), "Percentage": SimTypeChar(label="Byte"), "SharedSecret": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_FAILOVER_RELATIONSHIP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "pRelationship"]),
        #
        'DhcpV4FailoverDeleteScopeFromRelationship': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"PrimaryServer": SimTypeInt(signed=False, label="UInt32"), "SecondaryServer": SimTypeInt(signed=False, label="UInt32"), "Mode": SimTypeInt(signed=False, label="DHCP_FAILOVER_MODE"), "ServerType": SimTypeInt(signed=False, label="DHCP_FAILOVER_SERVER"), "State": SimTypeInt(signed=False, label="FSM_STATE"), "PrevState": SimTypeInt(signed=False, label="FSM_STATE"), "Mclt": SimTypeInt(signed=False, label="UInt32"), "SafePeriod": SimTypeInt(signed=False, label="UInt32"), "RelationshipName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SecondaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pScopes": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)}, name="DHCP_IP_ARRAY", pack=False, align=None), offset=0), "Percentage": SimTypeChar(label="Byte"), "SharedSecret": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_FAILOVER_RELATIONSHIP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "pRelationship"]),
        #
        'DhcpV4FailoverGetScopeRelationship': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"PrimaryServer": SimTypeInt(signed=False, label="UInt32"), "SecondaryServer": SimTypeInt(signed=False, label="UInt32"), "Mode": SimTypeInt(signed=False, label="DHCP_FAILOVER_MODE"), "ServerType": SimTypeInt(signed=False, label="DHCP_FAILOVER_SERVER"), "State": SimTypeInt(signed=False, label="FSM_STATE"), "PrevState": SimTypeInt(signed=False, label="FSM_STATE"), "Mclt": SimTypeInt(signed=False, label="UInt32"), "SafePeriod": SimTypeInt(signed=False, label="UInt32"), "RelationshipName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PrimaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SecondaryServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pScopes": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)}, name="DHCP_IP_ARRAY", pack=False, align=None), offset=0), "Percentage": SimTypeChar(label="Byte"), "SharedSecret": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_FAILOVER_RELATIONSHIP", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ScopeId", "pRelationship"]),
        #
        'DhcpV4FailoverGetScopeStatistics': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumAddr": SimTypeInt(signed=False, label="UInt32"), "AddrFree": SimTypeInt(signed=False, label="UInt32"), "AddrInUse": SimTypeInt(signed=False, label="UInt32"), "PartnerAddrFree": SimTypeInt(signed=False, label="UInt32"), "ThisAddrFree": SimTypeInt(signed=False, label="UInt32"), "PartnerAddrInUse": SimTypeInt(signed=False, label="UInt32"), "ThisAddrInUse": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_FAILOVER_STATISTICS", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ScopeId", "pStats"]),
        #
        'DhcpV4FailoverGetClientInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SearchType": SimTypeInt(signed=False, label="DHCP_SEARCH_INFO_TYPE"), "SearchInfo": SimUnion({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_SEARCH_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32"), "SentPotExpTime": SimTypeInt(signed=False, label="UInt32"), "AckPotExpTime": SimTypeInt(signed=False, label="UInt32"), "RecvPotExpTime": SimTypeInt(signed=False, label="UInt32"), "StartTime": SimTypeInt(signed=False, label="UInt32"), "CltLastTransTime": SimTypeInt(signed=False, label="UInt32"), "LastBndUpdTime": SimTypeInt(signed=False, label="UInt32"), "BndMsgStatus": SimTypeInt(signed=False, label="UInt32"), "PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeChar(label="Byte")}, name="DHCPV4_FAILOVER_CLIENT_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SearchInfo", "ClientInfo"]),
        #
        'DhcpV4FailoverGetSystemTime': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "pTime", "pMaxAllowedDeltaTime"]),
        #
        'DhcpV4FailoverGetAddressStatus': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "pStatus"]),
        #
        'DhcpV4FailoverTriggerAddrAllocation': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "pFailRelName"]),
        #
        'DhcpHlprCreateV4Policy': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PolicyName", "fGlobalPolicy", "Subnet", "ProcessingOrder", "RootOperator", "Description", "Enabled", "Policy"]),
        #
        'DhcpHlprCreateV4PolicyEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32"), "Properties": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)}, name="DHCP_POLICY_EX", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PolicyName", "fGlobalPolicy", "Subnet", "ProcessingOrder", "RootOperator", "Description", "Enabled", "Policy"]),
        #
        'DhcpHlprAddV4PolicyExpr': SimTypeFunction([SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Policy", "ParentExpr", "Operator", "ExprIndex"]),
        #
        'DhcpHlprAddV4PolicyCondition': SimTypeFunction([SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Policy", "ParentExpr", "Type", "OptionID", "SubOptionID", "VendorName", "Operator", "Value", "ValueLength", "ConditionIndex"]),
        #
        'DhcpHlprAddV4PolicyRange': SimTypeFunction([SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Policy", "Range"]),
        #
        'DhcpHlprResetV4PolicyExpr': SimTypeFunction([SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Policy"]),
        #
        'DhcpHlprModifyV4PolicyExpr': SimTypeFunction([SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Policy", "Operator"]),
        #
        'DhcpHlprFreeV4Policy': SimTypeFunction([SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Policy"]),
        #
        'DhcpHlprFreeV4PolicyArray': SimTypeFunction([SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0)}, name="DHCP_POLICY_ARRAY", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["PolicyArray"]),
        #
        'DhcpHlprFreeV4PolicyEx': SimTypeFunction([SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32"), "Properties": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)}, name="DHCP_POLICY_EX", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["PolicyEx"]),
        #
        'DhcpHlprFreeV4PolicyExArray': SimTypeFunction([SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32"), "Properties": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)}, name="DHCP_POLICY_EX", pack=False, align=None), offset=0)}, name="DHCP_POLICY_EX_ARRAY", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["PolicyExArray"]),
        #
        'DhcpHlprFreeV4DhcpProperty': SimTypeFunction([SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Property"]),
        #
        'DhcpHlprFreeV4DhcpPropertyArray': SimTypeFunction([SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["PropertyArray"]),
        #
        'DhcpHlprFindV4DhcpProperty': SimTypeFunction([SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE")], SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0), arg_names=["PropertyArray", "ID", "Type"]),
        #
        'DhcpHlprIsV4PolicySingleUC': SimTypeFunction([SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Policy"]),
        #
        'DhcpV4QueryPolicyEnforcement': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "fGlobalPolicy", "SubnetAddress", "Enabled"]),
        #
        'DhcpV4SetPolicyEnforcement': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "fGlobalPolicy", "SubnetAddress", "Enable"]),
        #
        'DhcpHlprIsV4PolicyWellFormed': SimTypeFunction([SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPolicy"]),
        #
        'DhcpHlprIsV4PolicyValid': SimTypeFunction([SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPolicy"]),
        #
        'DhcpV4CreatePolicy': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "pPolicy"]),
        #
        'DhcpV4GetPolicy': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "fGlobalPolicy", "SubnetAddress", "PolicyName", "Policy"]),
        #
        'DhcpV4SetPolicy': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "FieldsModified", "fGlobalPolicy", "SubnetAddress", "PolicyName", "Policy"]),
        #
        'DhcpV4DeletePolicy': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "fGlobalPolicy", "SubnetAddress", "PolicyName"]),
        #
        'DhcpV4EnumPolicies': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32")}, name="DHCP_POLICY", pack=False, align=None), offset=0)}, name="DHCP_POLICY_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ResumeHandle", "PreferredMaximum", "fGlobalPolicy", "SubnetAddress", "EnumInfo", "ElementsRead", "ElementsTotal"]),
        #
        'DhcpV4AddPolicyRange': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "PolicyName", "Range"]),
        #
        'DhcpV4RemovePolicyRange': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "PolicyName", "Range"]),
        #
        'DhcpV6SetStatelessStoreParams': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Status": SimTypeInt(signed=True, label="Int32"), "PurgeInterval": SimTypeInt(signed=False, label="UInt32")}, name="DHCPV6_STATELESS_PARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "fServerLevel", "SubnetAddress", "FieldModified", "Params"]),
        #
        'DhcpV6GetStatelessStoreParams': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypePointer(SimTypePointer(SimStruct({"Status": SimTypeInt(signed=True, label="Int32"), "PurgeInterval": SimTypeInt(signed=False, label="UInt32")}, name="DHCPV6_STATELESS_PARAMS", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "fServerLevel", "SubnetAddress", "Params"]),
        #
        'DhcpV6GetStatelessStatistics': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"NumScopes": SimTypeInt(signed=False, label="UInt32"), "ScopeStats": SimTypePointer(SimStruct({"SubnetAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "NumStatelessClientsAdded": SimTypeLongLong(signed=False, label="UInt64"), "NumStatelessClientsRemoved": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCPV6_STATELESS_SCOPE_STATS", pack=False, align=None), offset=0)}, name="DHCPV6_STATELESS_STATS", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "StatelessStats"]),
        #
        'DhcpV4CreateClientInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32"), "FilterStatus": SimTypeInt(signed=False, label="UInt32"), "PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_CLIENT_INFO_PB", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpV4EnumSubnetClients': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Clients": SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32"), "FilterStatus": SimTypeInt(signed=False, label="UInt32"), "PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_CLIENT_INFO_PB", pack=False, align=None), offset=0), offset=0)}, name="DHCP_CLIENT_INFO_PB_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ResumeHandle", "PreferredMaximum", "ClientInfo", "ClientsRead", "ClientsTotal"]),
        #
        'DhcpV4GetClientInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SearchType": SimTypeInt(signed=False, label="DHCP_SEARCH_INFO_TYPE"), "SearchInfo": SimUnion({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_SEARCH_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32"), "FilterStatus": SimTypeInt(signed=False, label="UInt32"), "PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_CLIENT_INFO_PB", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SearchInfo", "ClientInfo"]),
        #
        'DhcpV6CreateClientInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ClientIpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "ClientDUID": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "AddressType": SimTypeInt(signed=False, label="UInt32"), "IAID": SimTypeInt(signed=False, label="UInt32"), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientValidLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "ClientPrefLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO_V6", pack=False, align=None)}, name="DHCP_CLIENT_INFO_V6", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpV4GetFreeIPAddress': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)}, name="DHCP_IP_ARRAY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ScopeId", "StartIP", "EndIP", "NumFreeAddrReq", "IPAddrList"]),
        #
        'DhcpV6GetFreeIPAddress': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"HighOrderBits": SimTypeLongLong(signed=False, label="UInt64"), "LowOrderBits": SimTypeLongLong(signed=False, label="UInt64")}, name="DHCP_IPV6_ADDRESS", pack=False, align=None), offset=0)}, name="DHCPV6_IP_ARRAY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ScopeId", "StartIP", "EndIP", "NumFreeAddrReq", "IPAddrList"]),
        #
        'DhcpV4CreateClientInfoEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32"), "FilterStatus": SimTypeInt(signed=False, label="UInt32"), "PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Properties": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)}, name="DHCP_CLIENT_INFO_EX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ClientInfo"]),
        #
        'DhcpV4EnumSubnetClientsEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Clients": SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32"), "FilterStatus": SimTypeInt(signed=False, label="UInt32"), "PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Properties": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)}, name="DHCP_CLIENT_INFO_EX", pack=False, align=None), offset=0), offset=0)}, name="DHCP_CLIENT_INFO_EX_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SubnetAddress", "ResumeHandle", "PreferredMaximum", "ClientInfo", "ClientsRead", "ClientsTotal"]),
        #
        'DhcpV4GetClientInfoEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SearchType": SimTypeInt(signed=False, label="DHCP_SEARCH_INFO_TYPE"), "SearchInfo": SimUnion({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="DHCP_SEARCH_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ClientIpAddress": SimTypeInt(signed=False, label="UInt32"), "SubnetMask": SimTypeInt(signed=False, label="UInt32"), "ClientHardwareAddress": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None), "ClientName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ClientLeaseExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "OwnerHost": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "NetBiosName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "HostName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DHCP_HOST_INFO", pack=False, align=None), "bClientType": SimTypeChar(label="Byte"), "AddressState": SimTypeChar(label="Byte"), "Status": SimTypeInt(signed=False, label="QuarantineStatus"), "ProbationEnds": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="DATE_TIME", pack=False, align=None), "QuarantineCapable": SimTypeInt(signed=True, label="Int32"), "FilterStatus": SimTypeInt(signed=False, label="UInt32"), "PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Properties": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)}, name="DHCP_CLIENT_INFO_EX", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "SearchInfo", "ClientInfo"]),
        #
        'DhcpV4CreatePolicyEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32"), "Properties": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)}, name="DHCP_POLICY_EX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "PolicyEx"]),
        #
        'DhcpV4GetPolicyEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32"), "Properties": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)}, name="DHCP_POLICY_EX", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "GlobalPolicy", "SubnetAddress", "PolicyName", "Policy"]),
        #
        'DhcpV4SetPolicyEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32"), "Properties": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)}, name="DHCP_POLICY_EX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "FieldsModified", "GlobalPolicy", "SubnetAddress", "PolicyName", "Policy"]),
        #
        'DhcpV4EnumPoliciesEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"PolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "IsGlobalPolicy": SimTypeInt(signed=True, label="Int32"), "Subnet": SimTypeInt(signed=False, label="UInt32"), "ProcessingOrder": SimTypeInt(signed=False, label="UInt32"), "Conditions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="DHCP_POL_ATTR_TYPE"), "OptionID": SimTypeInt(signed=False, label="UInt32"), "SubOptionID": SimTypeInt(signed=False, label="UInt32"), "VendorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Operator": SimTypeInt(signed=False, label="DHCP_POL_COMPARATOR"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ValueLength": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_POL_COND", pack=False, align=None), offset=0)}, name="DHCP_POL_COND_ARRAY", pack=False, align=None), offset=0), "Expressions": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ParentExpr": SimTypeInt(signed=False, label="UInt32"), "Operator": SimTypeInt(signed=False, label="DHCP_POL_LOGIC_OPER")}, name="DHCP_POL_EXPR", pack=False, align=None), offset=0)}, name="DHCP_POL_EXPR_ARRAY", pack=False, align=None), offset=0), "Ranges": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"StartAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32")}, name="DHCP_IP_RANGE", pack=False, align=None), offset=0)}, name="DHCP_IP_RANGE_ARRAY", pack=False, align=None), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Enabled": SimTypeInt(signed=True, label="Int32"), "Properties": SimTypePointer(SimStruct({"NumElements": SimTypeInt(signed=False, label="UInt32"), "Elements": SimTypePointer(SimStruct({"ID": SimTypeInt(signed=False, label="DHCP_PROPERTY_ID"), "Type": SimTypeInt(signed=False, label="DHCP_PROPERTY_TYPE"), "Value": SimUnion({"ByteValue": SimTypeChar(label="Byte"), "WordValue": SimTypeShort(signed=False, label="UInt16"), "DWordValue": SimTypeInt(signed=False, label="UInt32"), "StringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BinaryValue": SimStruct({"DataLength": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DHCP_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="DHCP_PROPERTY", pack=False, align=None), offset=0)}, name="DHCP_PROPERTY_ARRAY", pack=False, align=None), offset=0)}, name="DHCP_POLICY_EX", pack=False, align=None), offset=0)}, name="DHCP_POLICY_EX_ARRAY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerIpAddress", "ResumeHandle", "PreferredMaximum", "GlobalPolicy", "SubnetAddress", "EnumInfo", "ElementsRead", "ElementsTotal"]),
    }

lib.set_prototypes(prototypes)
