/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.http.command;

import org.apache.karaf.http.core.ProxyService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="http", name="proxy-list", description="List the HTTP proxies")
@Service
public class ProxyListCommand
implements Action {
    @Reference
    private ProxyService proxyService;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("URL");
        table.column("ProxyTo");
        table.column("Balancing Policy");
        for (String url : this.proxyService.getProxies().keySet()) {
            table.addRow().addContent(new Object[]{url, this.proxyService.getProxies().get(url).getProxyTo(), this.proxyService.getProxies().get(url).getBalancingPolicy()});
        }
        table.print(System.out);
        return null;
    }
}

