/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.updatetask;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.netbeans.modules.cordova.updatetask.CordovaTask;
import org.netbeans.modules.cordova.updatetask.PluginTask;
import org.netbeans.modules.cordova.updatetask.SourceConfig;

public class ReadConfigTask
extends CordovaTask {
    public void execute() throws BuildException {
        try {
            File configFile = this.getConfigFile();
            SourceConfig config = new SourceConfig(configFile);
            String id = config.getId();
            String pkg = id.substring(0, id.lastIndexOf("."));
            this.setProperty("android.project.package", pkg);
            this.setProperty("android.project.package.folder", pkg.replace(".", "/"));
            this.setProperty("project.name", config.getName());
            this.setProperty("cordova.command", PluginTask.getCordovaCommand());
            String path = PluginTask.isWin() ? "env.Path" : "env.PATH";
            String pathKey = PluginTask.isWin() ? "Path" : "PATH";
            this.setProperty("cordova.path.key", pathKey);
            this.setProperty("cordova.path.value", PluginTask.isMac() ? this.getMacPath(path) : this.getProperty(path));
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private String getMacPath(String path) {
        ExecTask exec = (ExecTask)this.getProject().createTask("exec");
        exec.setExecutable("/bin/bash");
        exec.createArg().setLine("-lc env");
        exec.setOutputproperty("mac.path");
        exec.execute();
        String property = this.getProperty("mac.path");
        if (property != null) {
            for (String line : property.split(System.getProperty("line.separator"))) {
                if (!line.startsWith("PATH=")) continue;
                return line.substring(5);
            }
        }
        return this.getProperty(path);
    }
}

