/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.whitelist.WhiteListQuery;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.apisupport.PluginBackwardPropertyUtils;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.whitelist.WhiteListQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class MavenWhiteListQueryImpl
implements WhiteListQueryImplementation {
    private final Project project;
    private SoftReference<Set<String>> cachePrivatePackages;
    private SoftReference<Set<String>> cacheTransitivePackages;
    private final Object LOCK = new Object();
    private boolean isCached = false;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final PropertyChangeListener projectListener;
    private static final RequestProcessor RP = new RequestProcessor(MavenWhiteListQueryImpl.class.getName(), 3);
    private static final Logger LOG = Logger.getLogger(MavenWhiteListQueryImpl.class.getName());
    private final Set<MavenWhiteListImplementation> results = Collections.synchronizedSet(new WeakSet());
    private static final WhiteListQuery.RuleDescription PRIVATE_RD = new WhiteListQuery.RuleDescription("private", "Module dependency's private package referenced", null);
    private static final WhiteListQuery.RuleDescription TRANSITIVE_RD = new WhiteListQuery.RuleDescription("transitive", "Package from transitive module dependency referenced, declare a direct dependency to fix.", null);
    private static final WhiteListQuery.Result OK = new WhiteListQuery.Result();

    public MavenWhiteListQueryImpl(Project prj) {
        this.project = prj;
        this.projectListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    Object object = MavenWhiteListQueryImpl.this.LOCK;
                    synchronized (object) {
                        boolean transitiveChanged;
                        Set newTransitive;
                        Set newPrivate;
                        Set oldTransitive;
                        Set oldPrivate;
                        Set set = oldPrivate = MavenWhiteListQueryImpl.this.cachePrivatePackages != null ? (Set)MavenWhiteListQueryImpl.this.cachePrivatePackages.get() : null;
                        if (oldPrivate == null) {
                            oldPrivate = Collections.emptySet();
                        }
                        Set set2 = oldTransitive = MavenWhiteListQueryImpl.this.cacheTransitivePackages != null ? (Set)MavenWhiteListQueryImpl.this.cacheTransitivePackages.get() : null;
                        if (oldTransitive == null) {
                            oldTransitive = Collections.emptySet();
                        }
                        MavenWhiteListQueryImpl.this.isCached = false;
                        MavenWhiteListQueryImpl.this.cacheOrLoad();
                        Set set3 = newPrivate = MavenWhiteListQueryImpl.this.cachePrivatePackages != null ? (Set)MavenWhiteListQueryImpl.this.cachePrivatePackages.get() : null;
                        if (newPrivate == null) {
                            newPrivate = Collections.emptySet();
                        }
                        Set set4 = newTransitive = MavenWhiteListQueryImpl.this.cacheTransitivePackages != null ? (Set)MavenWhiteListQueryImpl.this.cacheTransitivePackages.get() : null;
                        if (newTransitive == null) {
                            newTransitive = Collections.emptySet();
                        }
                        HashSet oldNotNew1 = new HashSet(oldPrivate);
                        oldNotNew1.removeAll(newPrivate);
                        HashSet newNotOld1 = new HashSet(newPrivate);
                        newNotOld1.removeAll(oldPrivate);
                        HashSet oldNotNew2 = new HashSet(oldTransitive);
                        oldNotNew2.removeAll(newTransitive);
                        HashSet newNotOld2 = new HashSet(newTransitive);
                        newNotOld2.removeAll(oldTransitive);
                        boolean privateChanged = !oldNotNew1.isEmpty() || !newNotOld1.isEmpty();
                        boolean bl = transitiveChanged = !oldNotNew2.isEmpty() || !newNotOld2.isEmpty();
                        if (privateChanged || transitiveChanged) {
                            ClassPath[] cps = ((ProjectSourcesClassPathProvider)MavenWhiteListQueryImpl.this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectClassPaths("classpath/source");
                            HashSet<FileObject> fos = new HashSet<FileObject>();
                            for (ClassPath cp : cps) {
                                fos.addAll(Arrays.asList(cp.getRoots()));
                            }
                            LOG.log(Level.INFO, "Refreshing indexes for {0} because {1}{2} changed.", new Object[]{MavenWhiteListQueryImpl.this.project.getProjectDirectory(), privateChanged ? "accessible private packages, " : "", transitiveChanged ? "accessible transitive packages " : ""});
                            LOG.log(Level.FINE, "changes in private1-{0}", Arrays.toString(oldNotNew1.toArray()));
                            LOG.log(Level.FINE, "changes in private2-{0}", Arrays.toString(newNotOld1.toArray()));
                            LOG.log(Level.FINE, "changes in transitive1-{0}", Arrays.toString(oldNotNew2.toArray()));
                            LOG.log(Level.FINE, "changes in transitive2-{0}", Arrays.toString(newNotOld2.toArray()));
                            IndexingManager.getDefault().refreshAllIndices(fos.toArray(new FileObject[0]));
                        }
                    }
                }
            }
        };
    }

    public WhiteListQueryImplementation.WhiteListImplementation getWhiteList(FileObject file) {
        NbMavenProject mvn = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        assert (mvn != null);
        AuxiliaryProperties props = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        String disable = props.get("netbeans.hint.disable.whitelist", true);
        if (disable != null) {
            return null;
        }
        ProjectSourcesClassPathProvider prov = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
        assert (prov != null);
        ClassPath sourceCp = prov.getProjectSourcesClassPath("classpath/source");
        if (!sourceCp.contains(file)) {
            return null;
        }
        if (this.initialized.compareAndSet(false, true)) {
            mvn.addPropertyChangeListener(this.projectListener);
        }
        Tuple res = this.cacheOrLoad();
        MavenWhiteListImplementation val = new MavenWhiteListImplementation(res.privatePackages, res.transitivePackages);
        this.results.add(val);
        return val;
    }

    private Set<String> getAllPackages(FileObject root) {
        HashSet<String> toRet = new HashSet<String>();
        this.processFolder(root, root, toRet);
        toRet.remove("");
        return toRet;
    }

    private void processFolder(FileObject root, FileObject folder, Set<String> foundPackages) {
        FileObject fileObject;
        Enumeration it = folder.getData(false);
        while (it.hasMoreElements()) {
            fileObject = (FileObject)it.nextElement();
            if (!fileObject.hasExt("class")) continue;
            foundPackages.add(folder.getPath().replace('/', '.'));
            break;
        }
        it = folder.getFolders(false);
        while (it.hasMoreElements()) {
            fileObject = (FileObject)it.nextElement();
            this.processFolder(root, fileObject, foundPackages);
        }
    }

    public static boolean isUseOSGiDependencies(Project project) {
        String useOsgiString = PluginBackwardPropertyUtils.getPluginProperty(project, "useOSGiDependencies", null, null);
        return useOsgiString != null ? Boolean.parseBoolean(useOsgiString) : false;
    }

    private Tuple calculateLists() {
        boolean useOsgi = MavenWhiteListQueryImpl.isUseOSGiDependencies(this.project);
        ArrayList<NBMWrapper> nbms = new ArrayList<NBMWrapper>();
        ArrayList osgis = new ArrayList();
        ArrayList<Wrapper> directCPs = new ArrayList<Wrapper>();
        ArrayList<Wrapper> unknown = new ArrayList<Wrapper>();
        NbMavenProject mvn = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        MavenProject mp = mvn.getMavenProject();
        HashSet<String> privatePackages = new HashSet<String>();
        HashSet<String> transitivePackages = new HashSet<String>();
        for (Artifact a : mp.getCompileArtifacts()) {
            Object root;
            Manifest mf;
            FileObject fo;
            if (a.getFile() == null || (fo = FileUtil.toFileObject((File)a.getFile())) == null || !FileUtil.isArchiveFile((FileObject)fo) || (mf = this.getManifest((FileObject)(root = FileUtil.getArchiveRoot((FileObject)fo)))) == null || mf.getMainAttributes() == null) continue;
            Attributes attrs = mf.getMainAttributes();
            String osgiexport = attrs.getValue("Export-Package");
            String osgiprivate = attrs.getValue("Private-Package");
            String nbmexport = attrs.getValue("OpenIDE-Module-Public-Packages");
            Set<String> allpackages = this.getAllPackages((FileObject)root);
            if (nbmexport != null) {
                String nbmMaven = attrs.getValue("Maven-Class-Path");
                String friends = attrs.getValue("OpenIDE-Module-Friends");
                nbms.add(new NBMWrapper(a, allpackages, nbmexport.equals("-") ? null : StringUtils.split((String)nbmexport, (String)","), friends != null ? StringUtils.split((String)friends, (String)",") : null, nbmMaven != null ? StringUtils.split((String)nbmMaven, (String)" ") : null));
                continue;
            }
            if (useOsgi && osgiexport != null) continue;
            if (a.getDependencyTrail() != null && a.getDependencyTrail().size() > 2) {
                unknown.add(new Wrapper(a, allpackages));
                continue;
            }
            directCPs.add(new Wrapper(a, allpackages));
        }
        List<ExplicitDependency> explicits = PluginBackwardPropertyUtils.getPluginPropertyBuildable(this.project, null, new ExplicitBuilder());
        HashSet<String> nonPrivatePackages = new HashSet<String>();
        HashSet<String> nonTransitivePackages = new HashSet<String>();
        for (Wrapper dir : directCPs) {
            nonTransitivePackages.addAll(dir.allPackages);
            nonPrivatePackages.addAll(dir.allPackages);
        }
        directCPs.clear();
        for (NBMWrapper nbm : nbms) {
            HashSet<String> allPackages = new HashSet<String>(nbm.allPackages);
            if (nbm.hasMavenCPDefined()) {
                for (Wrapper wrapper : unknown) {
                    if (!nbm.hasOnClassPath(wrapper.art)) continue;
                    nbm.wrappedLibs.add(wrapper.art);
                    allPackages.addAll(wrapper.allPackages);
                }
            }
            if (nbm.art.getDependencyTrail() != null && nbm.art.getDependencyTrail().size() > 2) {
                transitivePackages.addAll(allPackages);
            } else {
                nonTransitivePackages.addAll(allPackages);
            }
            if (explicits != null) {
                for (ExplicitDependency ex : explicits) {
                    if (!ex.matches(nbm.art) || !ex.isImplementationDependency()) continue;
                    nonPrivatePackages.addAll(allPackages);
                }
            }
            for (String p : allPackages) {
                if (nbm.isPublicPackage(p)) {
                    nonPrivatePackages.add(p);
                    continue;
                }
                privatePackages.add(p);
            }
        }
        nbms.clear();
        ClassPath boot = ((ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectSourcesClassPath("classpath/boot");
        HashSet<String> bootCP = new HashSet<String>();
        for (FileObject fo : boot.getRoots()) {
            bootCP.addAll(this.getAllPackages(fo));
        }
        transitivePackages.removeAll(bootCP);
        privatePackages.removeAll(bootCP);
        transitivePackages.removeAll(nonTransitivePackages);
        privatePackages.removeAll(nonPrivatePackages);
        return new Tuple(privatePackages, transitivePackages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeAllExistingResults(final Set<String> privatePackages, final Set<String> transitivePackages) {
        HashSet<MavenWhiteListImplementation> set;
        assert (Thread.holdsLock(this.LOCK));
        Set<MavenWhiteListImplementation> set2 = this.results;
        synchronized (set2) {
            set = new HashSet<MavenWhiteListImplementation>(this.results);
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                for (MavenWhiteListImplementation res : set) {
                    if (res == null) continue;
                    res.changeData(privatePackages, transitivePackages);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple cacheOrLoad() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isCached) {
                Set<String> set2;
                Set<String> set1 = this.cachePrivatePackages != null ? this.cachePrivatePackages.get() : null;
                Set<String> set = set2 = this.cacheTransitivePackages != null ? this.cacheTransitivePackages.get() : null;
                if (set1 != null && set2 != null) {
                    return new Tuple(set1, set2);
                }
            }
            Tuple tup = this.calculateLists();
            this.cachePrivatePackages = new SoftReference<Set<String>>(tup.privatePackages);
            this.cacheTransitivePackages = new SoftReference<Set<String>>(tup.transitivePackages);
            this.isCached = true;
            this.fireChangeAllExistingResults(tup.privatePackages, tup.transitivePackages);
            return tup;
        }
    }

    private Manifest getManifest(FileObject root) {
        FileObject manifestFo = root.getFileObject("META-INF/MANIFEST.MF");
        if (manifestFo != null) {
            Manifest manifest;
            block9: {
                InputStream is = manifestFo.getInputStream();
                try {
                    Manifest manifest2;
                    manifest = manifest2 = new Manifest(is);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return manifest;
        }
        return null;
    }

    private static class Tuple {
        Set<String> privatePackages;
        Set<String> transitivePackages;

        public Tuple(Set<String> privatePackages, Set<String> transitivePackages) {
            this.privatePackages = privatePackages;
            this.transitivePackages = transitivePackages;
        }
    }

    private static class MavenWhiteListImplementation
    implements WhiteListQueryImplementation.WhiteListImplementation {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        @NonNull
        private Set<String> privatePackages;
        @NonNull
        private Set<String> transitivePackages;
        private final Object IMPL_LOCK = new Object();

        private MavenWhiteListImplementation(@NonNull Set<String> privatePackages, @NonNull Set<String> transitivePackages) {
            this.privatePackages = privatePackages;
            this.transitivePackages = transitivePackages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WhiteListQuery.Result check(ElementHandle<?> element, WhiteListQuery.Operation operation) {
            String qn;
            if (!operation.equals((Object)WhiteListQuery.Operation.USAGE)) {
                return OK;
            }
            ArrayList<WhiteListQuery.RuleDescription> rds = new ArrayList<WhiteListQuery.RuleDescription>();
            if ((element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE) && (qn = element.getQualifiedName()).lastIndexOf(46) > 0) {
                String pack = qn.substring(0, qn.lastIndexOf("."));
                Object object = this.IMPL_LOCK;
                synchronized (object) {
                    if (this.privatePackages.contains(pack)) {
                        rds.add(PRIVATE_RD);
                    }
                    if (this.transitivePackages.contains(pack)) {
                        rds.add(TRANSITIVE_RD);
                    }
                }
                if (!rds.isEmpty()) {
                    return new WhiteListQuery.Result(rds);
                }
            }
            return OK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener listener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener listener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeData(@NonNull Set<String> privatePackages, @NonNull Set<String> transitivePackages) {
            Object object = this.IMPL_LOCK;
            synchronized (object) {
                this.privatePackages = privatePackages;
                this.transitivePackages = transitivePackages;
            }
            ArrayList<ChangeListener> changes = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                changes.addAll(this.listeners);
            }
            for (ChangeListener change : changes) {
                change.stateChanged(new ChangeEvent(this));
            }
        }
    }

    private static class NBMWrapper
    extends Wrapper {
        final String[] publicPackages;
        final List<Artifact> wrappedLibs = new ArrayList<Artifact>();
        boolean isImplementationDependency;
        final List<String> friends;
        final List<String> mavenCP;
        private final Set<String> eqPublic = new HashSet<String>();
        private final Set<String> subPublic = new HashSet<String>();

        public NBMWrapper(Artifact art, Set<String> allPackages, String[] publicPackages, String[] friends, String[] mavenCP) {
            super(art, allPackages);
            this.friends = friends != null ? Arrays.asList(friends) : Collections.emptyList();
            this.mavenCP = mavenCP != null ? Arrays.asList(mavenCP) : Collections.emptyList();
            HashSet<String> packs = new HashSet<String>();
            if (publicPackages != null) {
                for (String pub : publicPackages) {
                    pub = pub.trim();
                    packs.add(pub);
                    if (pub.endsWith(".**")) {
                        String sub = pub.substring(0, pub.length() - ".**".length());
                        this.subPublic.add(sub);
                        continue;
                    }
                    if (!pub.endsWith(".*")) continue;
                    String eq = pub.substring(0, pub.length() - ".*".length());
                    this.eqPublic.add(eq);
                }
            }
            this.publicPackages = packs.toArray(new String[0]);
        }

        boolean isFriend(String codenamebase) {
            return this.friends.contains(codenamebase);
        }

        boolean hasFriendAPI() {
            return !this.friends.isEmpty();
        }

        boolean hasOnClassPath(Artifact art) {
            String id = art.getGroupId() + ":" + art.getArtifactId() + ":" + art.getBaseVersion() + (art.getClassifier() != null ? ":" + art.getClassifier() : "");
            return this.mavenCP.contains(id);
        }

        boolean hasMavenCPDefined() {
            return !this.mavenCP.isEmpty();
        }

        boolean isPublicPackage(String pack) {
            if (this.eqPublic.contains(pack)) {
                return true;
            }
            for (String suString : this.subPublic) {
                if (!pack.startsWith(suString)) continue;
                return true;
            }
            return false;
        }
    }

    private static class Wrapper {
        final Artifact art;
        final Set<String> allPackages;

        public Wrapper(Artifact art, Set<String> allPackages) {
            this.art = art;
            this.allPackages = allPackages;
        }
    }

    private static class ExplicitBuilder
    implements PluginPropertyUtils.ConfigurationBuilder<List<ExplicitDependency>> {
        private ExplicitBuilder() {
        }

        public List<ExplicitDependency> build(Xpp3Dom configRoot, ExpressionEvaluator eval) {
            Xpp3Dom list;
            if (configRoot != null && (list = configRoot.getChild("moduleDependencies")) != null) {
                Xpp3Dom[] childs;
                ArrayList<ExplicitDependency> toRet = new ArrayList<ExplicitDependency>();
                for (Xpp3Dom ch : childs = list.getChildren("moduleDependency")) {
                    Object evaluated2;
                    String explicit;
                    Xpp3Dom idDom = ch.getChild("id");
                    Xpp3Dom typeDom = ch.getChild("type");
                    Xpp3Dom explicitDom = ch.getChild("explicitValue");
                    if (idDom == null || typeDom == null && explicitDom == null) continue;
                    String id = idDom.getValue();
                    String type = typeDom != null ? typeDom.getValue() : null;
                    String string = explicit = explicitDom != null ? explicitDom.getValue() : null;
                    if (id == null || type == null && explicit == null) continue;
                    try {
                        evaluated2 = eval.evaluate(id);
                        if (evaluated2 != null) {
                            id = evaluated2.toString();
                        }
                    }
                    catch (ExpressionEvaluationException evaluated2) {
                        // empty catch block
                    }
                    if (type != null) {
                        try {
                            evaluated2 = eval.evaluate(type);
                            if (evaluated2 != null) {
                                type = evaluated2.toString();
                            }
                        }
                        catch (ExpressionEvaluationException evaluated3) {
                            // empty catch block
                        }
                    }
                    if (explicit != null) {
                        try {
                            evaluated2 = eval.evaluate(explicit);
                            if (evaluated2 != null) {
                                explicit = evaluated2.toString();
                            }
                        }
                        catch (ExpressionEvaluationException evaluated4) {
                            // empty catch block
                        }
                    }
                    ExplicitDependency ed = new ExplicitDependency();
                    ed.id = id;
                    ed.type = type;
                    ed.explicit = explicit;
                    toRet.add(ed);
                }
                return toRet;
            }
            return null;
        }
    }

    private static class ExplicitDependency {
        String id;
        String explicit;
        String type;

        private ExplicitDependency() {
        }

        boolean matches(Artifact art) {
            return this.id != null && this.id.equals(art.getGroupId() + ":" + art.getArtifactId());
        }

        boolean isImplementationDependency() {
            return this.explicit != null && this.explicit.contains("=") || "impl".equals(this.type);
        }
    }

    private static class OSGIWrapper
    extends Wrapper {
        final String[] exports;

        public OSGIWrapper(Artifact art, Set<String> allPackages, String[] exports) {
            super(art, allPackages);
            this.exports = exports;
        }
    }
}

