/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCColumn;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCValue;
import org.netbeans.modules.db.metadata.model.spi.ViewImplementation;

public class JDBCView
extends ViewImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCView.class.getName());
    private final JDBCSchema jdbcSchema;
    private final String name;
    private Map<String, Column> columns;

    public JDBCView(JDBCSchema jdbcSchema, String name) {
        this.jdbcSchema = jdbcSchema;
        this.name = name;
    }

    public String toString() {
        return "JDBCView[name='" + this.getName() + "']";
    }

    @Override
    public final Schema getParent() {
        return this.jdbcSchema.getSchema();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Collection<Column> getColumns() {
        return this.initColumns().values();
    }

    @Override
    public final Column getColumn(String name) {
        return MetadataUtilities.find(name, this.initColumns());
    }

    protected JDBCColumn createJDBCColumn(ResultSet rs) throws SQLException {
        int ordinalPosition = rs.getInt("ORDINAL_POSITION");
        return new JDBCColumn(this.getView(), ordinalPosition, JDBCValue.createTableColumnValue(rs, this.getView()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createColumns() {
        LinkedHashMap<String, Column> newColumns;
        block6: {
            newColumns = new LinkedHashMap<String, Column>();
            try {
                ResultSet rs = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getColumns(this.jdbcSchema.getJDBCCatalog().getName(), this.jdbcSchema.getName(), this.name, "%");
                if (rs == null) break block6;
                try {
                    while (rs.next()) {
                        Column column = this.createJDBCColumn(rs).getColumn();
                        newColumns.put(column.getName(), column);
                        LOGGER.log(Level.FINE, "Created column {0}", column);
                    }
                }
                finally {
                    rs.close();
                }
            }
            catch (SQLException e) {
                throw new MetadataException(e);
            }
        }
        this.columns = Collections.unmodifiableMap(newColumns);
    }

    private Map<String, Column> initColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        LOGGER.log(Level.FINE, "Initializing columns in {0}", this);
        this.createColumns();
        return this.columns;
    }

    @Override
    public final void refresh() {
        this.columns = null;
    }
}

