/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.AbstractWebServiceRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class InvalidNameAttribute
extends AbstractWebServiceRule {
    @Override
    protected ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        AnnotationValue seiValue;
        AnnotationMirror annEntity = Utilities.findAnnotation(subject, "javax.jws.WebService");
        AnnotationTree annotationTree = (AnnotationTree)ctx.getCompilationInfo().getTrees().getTree(subject, annEntity);
        if (subject.getKind() == ElementKind.CLASS && (seiValue = Utilities.getAnnotationAttrValue(annEntity, "endpointInterface")) != null && Utilities.getAnnotationAttrValue(annEntity, "name") != null) {
            String label = NbBundle.getMessage(InvalidNameAttribute.class, (String)"MSG_NameAttributeNotAllowed");
            ExpressionTree problemTree = Utilities.getAnnotationArgumentTree(annotationTree, "name");
            RemoveAnnotationArgument removeFix = new RemoveAnnotationArgument(ctx.getFileObject(), subject, annEntity, "name");
            ctx.setElementToAnnotate(problemTree);
            ErrorDescription problem = InvalidNameAttribute.createProblem((Element)subject, ctx, label, removeFix);
            ctx.setElementToAnnotate(null);
            return new ErrorDescription[]{problem};
        }
        return null;
    }
}

