/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ui.util.ValidatablePanelListener;
import org.netbeans.modules.nativeexecution.api.ui.util.ValidateablePanel;
import org.netbeans.modules.nativeexecution.spi.ui.HostPropertiesPanelProvider;
import org.openide.util.Lookup;

public final class HostConfigurationPanel
extends ValidateablePanel {
    private final ValidatablePanelListener listener;
    private final List<ValidateablePanel> panels = new ArrayList<ValidateablePanel>();

    public HostConfigurationPanel(ExecutionEnvironment env) {
        GridBagConstraints gridBagConstraints;
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.listener = new ValidatablePanelListener(){

            @Override
            public void stateChanged(ValidateablePanel src) {
                HostConfigurationPanel.this.fireChange();
            }
        };
        this.addPropertyChangeListener("ExecutionEnvironment", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                for (ValidateablePanel panel : HostConfigurationPanel.this.panels) {
                    panel.putClientProperty(evt.getPropertyName(), evt.getNewValue());
                }
            }
        });
        Collection allProviders = Lookup.getDefault().lookupAll(HostPropertiesPanelProvider.class);
        int y = 0;
        for (HostPropertiesPanelProvider provider : allProviders) {
            ValidateablePanel panel = provider.getHostPropertyPanel(env);
            this.panels.add(panel);
            panel.addValidationListener(this.listener);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)panel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    @Override
    public boolean hasProblem() {
        for (ValidateablePanel panel : this.panels) {
            if (!panel.hasProblem()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProblem() {
        for (ValidateablePanel panel : this.panels) {
            String problem = panel.getProblem();
            if (problem == null) continue;
            return problem;
        }
        return null;
    }

    @Override
    public void applyChanges(Object customData) {
        for (ValidateablePanel panel : this.panels) {
            panel.applyChanges(customData);
        }
    }
}

