/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.symbol;

import java.util.Objects;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.jumpto.EntityComparator;
import org.netbeans.modules.jumpto.common.DescriptorAccessor;
import org.netbeans.modules.jumpto.common.StateFullComparator;
import org.netbeans.modules.jumpto.settings.GoToSettings;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.openide.util.ChangeSupport;

public abstract class SymbolComparator
extends EntityComparator<SymbolDescriptor>
implements StateFullComparator<SymbolDescriptor> {
    private final ChangeSupport support;
    protected final boolean caseSensitive;
    protected final boolean preferOpPrjs;

    private SymbolComparator(boolean caseSensitive, boolean preferOpPrjs) {
        this.caseSensitive = caseSensitive;
        this.preferOpPrjs = preferOpPrjs;
        this.support = new ChangeSupport((Object)this);
    }

    @Override
    public void addChangeListener(@NonNull ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(@NonNull ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    void fireChange() {
        this.support.fireChange();
    }

    abstract void setText(@NonNull String var1);

    @Override
    public abstract int compare(SymbolDescriptor var1, SymbolDescriptor var2);

    @NonNull
    public static SymbolComparator create(@NonNull GoToSettings.SortingType kind, @NonNull String text, boolean caseSensitive, boolean preferOpPrjs) {
        switch (kind) {
            case LEXICOGRAPHIC: {
                return new Alphabet(caseSensitive, preferOpPrjs);
            }
            case LEVENSHTEIN: {
                return new Levenshtein(text, caseSensitive, preferOpPrjs);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)kind));
    }

    @NonNull
    private static String getSortName(@NonNull SymbolDescriptor d) {
        String res = d.getSimpleName();
        if (res == null) {
            res = d.getSymbolName();
        }
        return res;
    }

    private static final class Alphabet
    extends SymbolComparator {
        Alphabet(boolean caseSensitive, boolean preferOpPrjs) {
            super(caseSensitive, preferOpPrjs);
        }

        @Override
        public int compare(SymbolDescriptor e1, SymbolDescriptor e2) {
            String e2projectName;
            String e1projectName;
            int result;
            if (this.preferOpPrjs && (result = this.compareProjects(e1projectName = e1.getProjectName(), e2projectName = e2.getProjectName())) != 0) {
                return result;
            }
            result = this.compare(SymbolComparator.getSortName(e1), SymbolComparator.getSortName(e2), this.caseSensitive);
            if (result != 0) {
                return result;
            }
            return this.compare(e1.getOwnerName(), e2.getOwnerName(), this.caseSensitive);
        }

        @Override
        void setText(String text) {
        }
    }

    private static final class Levenshtein
    extends SymbolComparator {
        private static final String ATTR_PATTERN = "Pattern";
        private static final String ATTR_LS_DIST = "LevenshteinDistance";
        private static final String ATTR_LS_TAIL = "LevenshteinTail";
        private String text;

        Levenshtein(@NonNull String text, boolean caseSensitive, boolean preferOpPrjs) {
            super(caseSensitive, preferOpPrjs);
            this.text = text;
        }

        @Override
        public int compare(SymbolDescriptor e1, SymbolDescriptor e2) {
            int t2;
            int l2;
            String prefix;
            int t1;
            int l1;
            String e2projectName;
            String e1projectName;
            int result;
            if (this.preferOpPrjs && (result = this.compareProjects(e1projectName = e1.getProjectName(), e2projectName = e2.getProjectName())) != 0) {
                return result;
            }
            String name1 = SymbolComparator.getSortName(e1);
            String name2 = SymbolComparator.getSortName(e2);
            Object d = DescriptorAccessor.getInstance().getAttribute(e1, ATTR_LS_DIST);
            Object t = DescriptorAccessor.getInstance().getAttribute(e1, ATTR_LS_TAIL);
            Object p = DescriptorAccessor.getInstance().getAttribute(e1, ATTR_PATTERN);
            if (d instanceof Integer && t instanceof Integer && this.text.equals(p)) {
                l1 = (Integer)d;
                t1 = (Integer)t;
            } else {
                prefix = this.levenshteinPrefix(name1, this.text, this.caseSensitive);
                l1 = this.levenshteinDistance(prefix, this.text, this.caseSensitive);
                t1 = name1.length() - prefix.length();
                DescriptorAccessor.getInstance().setAttribute(e1, ATTR_LS_DIST, l1);
                DescriptorAccessor.getInstance().setAttribute(e1, ATTR_LS_TAIL, t1);
                DescriptorAccessor.getInstance().setAttribute(e1, ATTR_PATTERN, this.text);
            }
            d = DescriptorAccessor.getInstance().getAttribute(e2, ATTR_LS_DIST);
            t = DescriptorAccessor.getInstance().getAttribute(e2, ATTR_LS_TAIL);
            p = DescriptorAccessor.getInstance().getAttribute(e2, ATTR_PATTERN);
            if (d instanceof Integer && t instanceof Integer && this.text.equals(p)) {
                l2 = (Integer)d;
                t2 = (Integer)t;
            } else {
                prefix = this.levenshteinPrefix(name2, this.text, this.caseSensitive);
                l2 = this.levenshteinDistance(prefix, this.text, this.caseSensitive);
                t2 = name2.length() - prefix.length();
                DescriptorAccessor.getInstance().setAttribute(e2, ATTR_LS_DIST, l2);
                DescriptorAccessor.getInstance().setAttribute(e2, ATTR_LS_TAIL, t2);
                DescriptorAccessor.getInstance().setAttribute(e2, ATTR_PATTERN, this.text);
            }
            result = l1 - l2;
            if (result != 0) {
                return result;
            }
            result = t1 - t2;
            if (result != 0) {
                return result;
            }
            result = this.compare(name1, name2, this.caseSensitive);
            if (result != 0) {
                return result;
            }
            return this.compare(e1.getOwnerName(), e2.getOwnerName(), this.caseSensitive);
        }

        @Override
        void setText(String text) {
            boolean fire = !Objects.equals(this.text, text);
            this.text = text;
            if (fire) {
                this.fireChange();
            }
        }
    }
}

