/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPublicIpRequest
extends BmcRequest<Void> {
    private String publicIpId;

    public String getPublicIpId() {
        return this.publicIpId;
    }

    public Builder toBuilder() {
        return new Builder().publicIpId(this.publicIpId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",publicIpId=").append(String.valueOf(this.publicIpId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPublicIpRequest)) {
            return false;
        }
        GetPublicIpRequest other = (GetPublicIpRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.publicIpId, other.publicIpId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.publicIpId == null ? 43 : this.publicIpId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPublicIpRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String publicIpId = null;

        public Builder publicIpId(String publicIpId) {
            this.publicIpId = publicIpId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPublicIpRequest o) {
            this.publicIpId(o.getPublicIpId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPublicIpRequest build() {
            GetPublicIpRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPublicIpRequest buildWithoutInvocationCallback() {
            GetPublicIpRequest request = new GetPublicIpRequest();
            request.publicIpId = this.publicIpId;
            return request;
        }
    }
}

