/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_caps_gpu_t")
public class BGFXCapsGPU
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VENDORID;
    public static final int DEVICEID;

    public BGFXCapsGPU(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXCapsGPU.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short vendorId() {
        return BGFXCapsGPU.nvendorId(this.address());
    }

    @NativeType(value="uint16_t")
    public short deviceId() {
        return BGFXCapsGPU.ndeviceId(this.address());
    }

    public static BGFXCapsGPU create(long address) {
        return (BGFXCapsGPU)BGFXCapsGPU.wrap(BGFXCapsGPU.class, (long)address);
    }

    @Nullable
    public static BGFXCapsGPU createSafe(long address) {
        return address == 0L ? null : (BGFXCapsGPU)BGFXCapsGPU.wrap(BGFXCapsGPU.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)BGFXCapsGPU.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)BGFXCapsGPU.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static short nvendorId(long struct) {
        return UNSAFE.getShort(null, struct + (long)VENDORID);
    }

    public static short ndeviceId(long struct) {
        return UNSAFE.getShort(null, struct + (long)DEVICEID);
    }

    static {
        Struct.Layout layout = BGFXCapsGPU.__struct((Struct.Member[])new Struct.Member[]{BGFXCapsGPU.__member((int)2), BGFXCapsGPU.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VENDORID = layout.offsetof(0);
        DEVICEID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXCapsGPU, Buffer> {
        private static final BGFXCapsGPU ELEMENT_FACTORY = BGFXCapsGPU.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXCapsGPU getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint16_t")
        public short vendorId() {
            return BGFXCapsGPU.nvendorId(this.address());
        }

        @NativeType(value="uint16_t")
        public short deviceId() {
            return BGFXCapsGPU.ndeviceId(this.address());
        }
    }
}

