/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerAlphaBlendFB;
import org.lwjgl.openxr.XrCompositionLayerColorScaleBiasKHR;
import org.lwjgl.openxr.XrCompositionLayerCubeKHR;
import org.lwjgl.openxr.XrCompositionLayerCylinderKHR;
import org.lwjgl.openxr.XrCompositionLayerEquirect2KHR;
import org.lwjgl.openxr.XrCompositionLayerEquirectKHR;
import org.lwjgl.openxr.XrCompositionLayerImageLayoutFB;
import org.lwjgl.openxr.XrCompositionLayerPassthroughFB;
import org.lwjgl.openxr.XrCompositionLayerProjection;
import org.lwjgl.openxr.XrCompositionLayerQuad;
import org.lwjgl.openxr.XrCompositionLayerSecureContentFB;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerBaseHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;

    public XrCompositionLayerBaseHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCompositionLayerBaseHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerBaseHeader.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerBaseHeader.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerBaseHeader.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerBaseHeader.nspace(this.address());
    }

    public XrCompositionLayerBaseHeader type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerBaseHeader.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerBaseHeader next(@NativeType(value="void const *") long value) {
        XrCompositionLayerBaseHeader.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerAlphaBlendFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerColorScaleBiasKHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerImageLayoutFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerPassthroughFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerSecureContentFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerBaseHeader.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerBaseHeader space(XrSpace value) {
        XrCompositionLayerBaseHeader.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerBaseHeader set(int type, long next, long layerFlags, XrSpace space) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        return this;
    }

    public XrCompositionLayerBaseHeader set(XrCompositionLayerBaseHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCompositionLayerBaseHeader malloc() {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrCompositionLayerBaseHeader calloc() {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrCompositionLayerBaseHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrCompositionLayerBaseHeader create(long address) {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (long)address);
    }

    @Nullable
    public static XrCompositionLayerBaseHeader createSafe(long address) {
        return address == 0L ? null : (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (long)address);
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerProjection value) {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (Struct)value);
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerQuad value) {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (Struct)value);
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerCubeKHR value) {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (Struct)value);
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerCylinderKHR value) {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (Struct)value);
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerEquirectKHR value) {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (Struct)value);
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerEquirect2KHR value) {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (Struct)value);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrCompositionLayerBaseHeader.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerBaseHeader.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static Buffer create(XrCompositionLayerProjection.Buffer value) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrCompositionLayerQuad.Buffer value) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrCompositionLayerCubeKHR.Buffer value) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrCompositionLayerCylinderKHR.Buffer value) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrCompositionLayerEquirectKHR.Buffer value) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrCompositionLayerEquirect2KHR.Buffer value) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static XrCompositionLayerBaseHeader malloc(MemoryStack stack) {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrCompositionLayerBaseHeader calloc(MemoryStack stack) {
        return (XrCompositionLayerBaseHeader)XrCompositionLayerBaseHeader.wrap(XrCompositionLayerBaseHeader.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCompositionLayerBaseHeader.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nlayerFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYERFLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlayerFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYERFLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
    }

    static {
        Struct.Layout layout = XrCompositionLayerBaseHeader.__struct((Struct.Member[])new Struct.Member[]{XrCompositionLayerBaseHeader.__member((int)4), XrCompositionLayerBaseHeader.__member((int)POINTER_SIZE), XrCompositionLayerBaseHeader.__member((int)8), XrCompositionLayerBaseHeader.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerBaseHeader, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerBaseHeader ELEMENT_FACTORY = XrCompositionLayerBaseHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrCompositionLayerBaseHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerBaseHeader.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerBaseHeader.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerBaseHeader.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerBaseHeader.nspace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerBaseHeader.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerBaseHeader.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrCompositionLayerAlphaBlendFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerColorScaleBiasKHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerImageLayoutFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerPassthroughFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerSecureContentFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerBaseHeader.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerBaseHeader.nspace(this.address(), value);
            return this;
        }
    }
}

