/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.keycloak.storage.ldap.idm.model.LDAPDn;

public class LDAPObject {
    private static final Logger logger = Logger.getLogger(LDAPObject.class);
    private String uuid;
    private LDAPDn dn;
    private final List<String> rdnAttributeNames = new LinkedList<String>();
    private final List<String> objectClasses = new LinkedList<String>();
    private final List<String> readOnlyAttributeNames = new LinkedList<String>();
    private final Map<String, Set<String>> attributes = new HashMap<String, Set<String>>();
    private final Map<String, Map.Entry<String, Set<String>>> lowerCasedAttributes = new HashMap<String, Map.Entry<String, Set<String>>>();
    private final Map<String, Integer> rangedAttributes = new HashMap<String, Integer>();
    private Consumer<LDAPObject> consumerOnMandatoryAttributesComplete;
    private Set<String> mandatoryAttributeNames;
    private Set<String> mandatoryAttributeNamesRemaining;

    public void executeOnMandatoryAttributesComplete(Set<String> mandatoryAttributeNames, Consumer<LDAPObject> consumer) {
        this.consumerOnMandatoryAttributesComplete = consumer;
        this.mandatoryAttributeNames = new LinkedHashSet<String>();
        this.mandatoryAttributeNamesRemaining = new LinkedHashSet<String>();
        if (mandatoryAttributeNames != null) {
            for (String name : mandatoryAttributeNames) {
                name = name.toLowerCase();
                this.mandatoryAttributeNames.add(name);
                Map.Entry<String, Set<String>> entry = this.lowerCasedAttributes.get(name);
                if (entry != null && !entry.getValue().isEmpty()) continue;
                this.mandatoryAttributeNamesRemaining.add(name);
            }
        }
        this.executeConsumerOnMandatoryAttributesComplete();
    }

    public boolean isWaitingForExecutionOnMandatoryAttributesComplete() {
        return this.consumerOnMandatoryAttributesComplete != null;
    }

    public Set<String> getMandatoryAttributeNamesRemaining() {
        return this.mandatoryAttributeNamesRemaining;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public LDAPDn getDn() {
        return this.dn;
    }

    public void setDn(LDAPDn dn) {
        this.dn = dn;
    }

    public List<String> getObjectClasses() {
        return this.objectClasses;
    }

    public void setObjectClasses(Collection<String> objectClasses) {
        this.objectClasses.clear();
        this.objectClasses.addAll(objectClasses);
    }

    public List<String> getReadOnlyAttributeNames() {
        return this.readOnlyAttributeNames;
    }

    public void addReadOnlyAttributeName(String readOnlyAttribute) {
        this.readOnlyAttributeNames.add(readOnlyAttribute.toLowerCase());
    }

    public void removeReadOnlyAttributeName(String readOnlyAttribute) {
        this.readOnlyAttributeNames.remove(readOnlyAttribute.toLowerCase());
    }

    public List<String> getRdnAttributeNames() {
        return this.rdnAttributeNames;
    }

    public void setRdnAttributeName(String rdnAttributeName) {
        this.rdnAttributeNames.clear();
        this.rdnAttributeNames.add(rdnAttributeName);
    }

    public void setRdnAttributeNames(List<String> rdnAttributeNames) {
        this.rdnAttributeNames.clear();
        this.rdnAttributeNames.addAll(rdnAttributeNames);
    }

    public void addRdnAttributeName(String rdnAttributeName) {
        this.rdnAttributeNames.add(rdnAttributeName);
    }

    public void setSingleAttribute(String attributeName, String attributeValue) {
        LinkedHashSet<String> asSet = new LinkedHashSet<String>();
        if (attributeValue != null) {
            asSet.add(attributeValue);
        }
        this.setAttribute(attributeName, asSet);
    }

    public void setAttribute(String attributeName, Set<String> attributeValue) {
        String attributeNameLowerCase = attributeName.toLowerCase();
        Set<Object> valueSet = attributeValue == null ? Collections.emptySet() : attributeValue;
        Map.Entry<String, Set<String>> entry = this.lowerCasedAttributes.get(attributeNameLowerCase);
        if (entry == null) {
            this.attributes.put(attributeName, valueSet);
            this.lowerCasedAttributes.put(attributeNameLowerCase, Map.entry(attributeName, valueSet));
        } else {
            this.attributes.put(entry.getKey(), valueSet);
            this.lowerCasedAttributes.put(attributeNameLowerCase, Map.entry(entry.getKey(), valueSet));
        }
        if (this.consumerOnMandatoryAttributesComplete != null) {
            if (!valueSet.isEmpty()) {
                this.mandatoryAttributeNamesRemaining.remove(attributeNameLowerCase);
            } else if (this.mandatoryAttributeNames.contains(attributeNameLowerCase)) {
                this.mandatoryAttributeNamesRemaining.add(attributeNameLowerCase);
            }
            this.executeConsumerOnMandatoryAttributesComplete();
        }
    }

    public String getAttributeAsString(String name) {
        Map.Entry<String, Set<String>> entry = this.lowerCasedAttributes.get(name.toLowerCase());
        if (entry == null || entry.getValue().isEmpty()) {
            return null;
        }
        if (entry.getValue().size() > 1) {
            logger.warnf("Expected String but attribute '%s' has more values '%s' on object '%s' . Returning just first value", (Object)name, entry.getValue(), (Object)this.dn);
        }
        return entry.getValue().iterator().next();
    }

    public Set<String> getAttributeAsSet(String name) {
        Map.Entry<String, Set<String>> entry = this.lowerCasedAttributes.get(name.toLowerCase());
        return entry == null ? null : new LinkedHashSet(entry.getValue());
    }

    public boolean isRangeComplete(String name) {
        return !this.rangedAttributes.containsKey(name);
    }

    public int getCurrentRange(String name) {
        return this.rangedAttributes.get(name);
    }

    public boolean isRangeCompleteForAllAttributes() {
        return this.rangedAttributes.isEmpty();
    }

    public void addRangedAttribute(String name, int max) {
        Integer current = this.rangedAttributes.get(name);
        if (current == null || max > current) {
            this.rangedAttributes.put(name, max);
        }
    }

    public void populateRangedAttribute(LDAPObject obj, String name) {
        Set<String> newValues = obj.getAttributes().get(name);
        if (newValues != null && this.attributes.containsKey(name)) {
            this.attributes.get(name).addAll(newValues);
            if (!obj.isRangeComplete(name)) {
                this.addRangedAttribute(name, obj.getCurrentRange(name));
            } else {
                this.rangedAttributes.remove(name);
            }
        }
    }

    public Map<String, Set<String>> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        LDAPObject other = (LDAPObject)obj;
        return this.getUuid() != null && other.getUuid() != null && this.getUuid().equals(other.getUuid());
    }

    public int hashCode() {
        int result = this.getUuid() != null ? this.getUuid().hashCode() : 0;
        result = 31 * result + (this.getUuid() != null ? this.getUuid().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LDAP Object [ dn: " + String.valueOf(this.dn) + " , uuid: " + this.uuid + ", attributes: " + String.valueOf(this.attributes) + ", readOnly attribute names: " + String.valueOf(this.readOnlyAttributeNames) + ", ranges: " + String.valueOf(this.rangedAttributes) + " ]";
    }

    private void executeConsumerOnMandatoryAttributesComplete() {
        if (this.mandatoryAttributeNamesRemaining.isEmpty()) {
            Consumer<LDAPObject> consumer = this.consumerOnMandatoryAttributesComplete;
            this.consumerOnMandatoryAttributesComplete = null;
            this.mandatoryAttributeNames = null;
            this.mandatoryAttributeNamesRemaining = null;
            consumer.accept(this);
        }
    }
}

