/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.spi.infinispan.impl.embedded;

import jakarta.persistence.EntityManager;
import java.lang.invoke.MethodHandles;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.jboss.logging.Logger;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TCP_NIO2;
import org.jgroups.protocols.UDP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.SocketFactory;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.jgroups.protocol.KEYCLOAK_JDBC_PING2;
import org.keycloak.models.KeycloakSession;
import org.keycloak.spi.infinispan.JGroupsCertificateProvider;

public final class JGroupsConfigurator {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final String TLS_PROTOCOL_VERSION = "TLSv1.3";
    private static final String TLS_PROTOCOL = "TLS";

    private JGroupsConfigurator() {
    }

    public static void configureJGroups(Config.Scope config, ConfigurationBuilderHolder holder, KeycloakSession session) {
        String stack = config.get("stack");
        if (stack != null) {
            JGroupsConfigurator.transportOf(holder).stack(stack);
        }
        JGroupsConfigurator.configureDiscovery(holder, session);
        JGroupsConfigurator.configureTls(holder, session);
        JGroupsConfigurator.warnDeprecatedStack(holder);
    }

    public static void configureTopology(Config.Scope config, ConfigurationBuilderHolder holder) {
        String siteName;
        String legacySiteName;
        if (System.getProperty("jboss.site.name") != null) {
            throw new IllegalArgumentException(String.format("System property %s is in use. Use --spi-cache-embedded-%s-site-name config option instead", "jboss.site.name", "default"));
        }
        if (System.getProperty("jboss.node.name") != null) {
            throw new IllegalArgumentException(String.format("System property %s is in use. Use --spi-cache-embedded-%s-node-name config option instead", "jboss.node.name", "default"));
        }
        TransportConfigurationBuilder transport = JGroupsConfigurator.transportOf(holder);
        String nodeName = config.get("nodeName");
        if (nodeName != null) {
            transport.nodeName(nodeName);
        }
        if ((legacySiteName = Config.scope((String[])new String[]{"connectionsInfinispan", "quarkus"}).get("site-name")) != null) {
            logger.warn((Object)"--spi-connections-infinispan-quarkus-site-name is deprecated and may be removed in the future. Use --spi-cache-embedded-%s-site-name".formatted("default"));
        }
        if ((siteName = config.get("siteName", legacySiteName)) != null) {
            transport.siteId(siteName);
        }
    }

    private static void configureTls(ConfigurationBuilderHolder holder, KeycloakSession session) {
        JGroupsCertificateProvider provider = (JGroupsCertificateProvider)session.getProvider(JGroupsCertificateProvider.class);
        if (provider == null || !provider.isEnabled()) {
            return;
        }
        SocketFactory factory = JGroupsConfigurator.createSocketFactory(provider);
        JGroupsConfigurator.transportOf(holder).addProperty("socketFactory", (Object)factory);
        JGroupsConfigurator.validateTlsAvailable(holder);
        logger.info((Object)"JGroups Encryption enabled (mTLS).");
    }

    private static SocketFactory createSocketFactory(JGroupsCertificateProvider provider) {
        try {
            SSLContext sslContext = SSLContext.getInstance(TLS_PROTOCOL);
            sslContext.init(new KeyManager[]{provider.keyManager()}, new TrustManager[]{provider.trustManager()}, null);
            return JGroupsConfigurator.createFromContext(sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static SocketFactory createFromContext(SSLContext context) {
        DefaultSocketFactory socketFactory = new DefaultSocketFactory(context);
        SSLParameters serverParameters = new SSLParameters();
        serverParameters.setProtocols(new String[]{TLS_PROTOCOL_VERSION});
        serverParameters.setNeedClientAuth(true);
        socketFactory.setServerSocketConfigurator(socket -> ((SSLServerSocket)socket).setSSLParameters(serverParameters));
        return socketFactory;
    }

    private static void configureDiscovery(ConfigurationBuilderHolder holder, KeycloakSession session) {
        Attribute<String> stackXmlAttribute = JGroupsConfigurator.transportStackOf(holder);
        if (stackXmlAttribute.isModified() && !JGroupsConfigurator.isJdbcPingStack((String)stackXmlAttribute.get())) {
            logger.debugf("Custom stack configured (%s). JDBC_PING discovery disabled.", stackXmlAttribute.get());
            return;
        }
        logger.debug((Object)"JDBC_PING discovery enabled.");
        if (!stackXmlAttribute.isModified()) {
            JGroupsConfigurator.transportOf(holder).stack("jdbc-ping");
        }
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        String stackName = (String)JGroupsConfigurator.transportStackOf(holder).get();
        boolean isUdp = stackName.endsWith("udp");
        String tableName = JpaUtils.getTableNameForNativeQuery((String)"JGROUPS_PING", (EntityManager)em);
        List<ProtocolConfiguration> stack = JGroupsConfigurator.getProtocolConfigurations(tableName, isUdp);
        JpaConnectionProviderFactory connectionFactory = (JpaConnectionProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(JpaConnectionProvider.class);
        holder.addJGroupsStack((EmbeddedJGroupsChannelConfigurator)new JpaFactoryAwareJGroupsChannelConfigurator(stackName, stack, connectionFactory, isUdp), null);
        JGroupsConfigurator.transportOf(holder).stack(stackName);
        logger.info((Object)"JGroups JDBC_PING discovery enabled.");
    }

    private static List<ProtocolConfiguration> getProtocolConfigurations(String tableName, boolean udp) {
        ArrayList<ProtocolConfiguration> list = new ArrayList<ProtocolConfiguration>(udp ? 1 : 2);
        list.add(new ProtocolConfiguration(KEYCLOAK_JDBC_PING2.class.getName(), Map.of("initialize_sql", "", "clear_sql", String.format("DELETE from %s WHERE cluster_name=?", tableName), "delete_single_sql", String.format("DELETE from %s WHERE address=?", tableName), "insert_single_sql", String.format("INSERT INTO %s values (?, ?, ?, ?, ?)", tableName), "select_all_pingdata_sql", String.format("SELECT address, name, ip, coord FROM %s WHERE cluster_name=?", tableName), "remove_all_data_on_view_change", "true", "register_shutdown_hook", "false", "stack.combine", "REPLACE", "stack.position", udp ? "PING" : "MPING")));
        if (!udp && InfinispanUtils.isVirtualThreadsEnabled()) {
            list.add(new ProtocolConfiguration(TCP.class.getSimpleName(), Map.of("bundler_type", "per-destination")));
        }
        return list;
    }

    private static void warnDeprecatedStack(ConfigurationBuilderHolder holder) {
        String stackName;
        switch (stackName = (String)JGroupsConfigurator.transportStackOf(holder).get()) {
            case "jdbc-ping-udp": 
            case "tcp": 
            case "udp": 
            case "azure": 
            case "ec2": 
            case "google": {
                logger.warnf("Stack '%s' is deprecated. We recommend to use 'jdbc-ping' instead", (Object)stackName);
            }
        }
    }

    private static TransportConfigurationBuilder transportOf(ConfigurationBuilderHolder holder) {
        return holder.getGlobalConfigurationBuilder().transport();
    }

    private static Attribute<String> transportStackOf(ConfigurationBuilderHolder holder) {
        TransportConfigurationBuilder transport = JGroupsConfigurator.transportOf(holder);
        assert (transport != null);
        return transport.attributes().attribute(TransportConfiguration.STACK);
    }

    private static void validateTlsAvailable(ConfigurationBuilderHolder holder) {
        String stackName = (String)JGroupsConfigurator.transportStackOf(holder).get();
        if (stackName == null) {
            return;
        }
        GlobalConfiguration config = JGroupsConfigurator.transportOf(holder).build();
        for (ProtocolConfiguration protocol : config.transport().jgroups().configurator(stackName).getProtocolStack()) {
            String name = protocol.getProtocolName();
            if (!name.equals(UDP.class.getSimpleName()) && !name.equals(UDP.class.getName()) && !name.equals(TCP_NIO2.class.getSimpleName()) && !name.equals(TCP_NIO2.class.getName())) continue;
            throw new RuntimeException("Cache TLS is not available with protocol " + name);
        }
    }

    private static boolean isJdbcPingStack(String stackName) {
        return "jdbc-ping".equals(stackName) || "jdbc-ping-udp".equals(stackName);
    }

    static {
        ClassConfigurator.addProtocol((short)1025, KEYCLOAK_JDBC_PING2.class);
    }

    private static class JpaFactoryAwareJGroupsChannelConfigurator
    extends EmbeddedJGroupsChannelConfigurator {
        private final JpaConnectionProviderFactory factory;

        public JpaFactoryAwareJGroupsChannelConfigurator(String name, List<ProtocolConfiguration> stack, JpaConnectionProviderFactory factory, boolean isUdp) {
            super(name, stack, null, isUdp ? "udp" : "tcp");
            this.factory = Objects.requireNonNull(factory);
        }

        public void afterCreation(Protocol protocol) {
            super.afterCreation(protocol);
            if (protocol instanceof KEYCLOAK_JDBC_PING2) {
                KEYCLOAK_JDBC_PING2 kcPing = (KEYCLOAK_JDBC_PING2)protocol;
                kcPing.setJpaConnectionProviderFactory(this.factory);
            }
        }
    }
}

