/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import org.keycloak.Config;

public class OIDCProviderConfig {
    public static final int DEFAULT_ADDITIONAL_REQ_PARAMS_MAX_NUMBER = 5;
    private final int additionalReqParamsMaxNumber;
    public static final int DEFAULT_ADDITIONAL_REQ_PARAMS_MAX_SIZE = 2000;
    private final int additionalReqParamsMaxSize;
    public static final boolean DEFAULT_ADDITIONAL_REQ_PARAMS_FAIL_FAST = false;
    private final boolean additionalReqParamsFailFast;
    public static final int DEFAULT_ADDITIONAL_REQ_PARAMS_MAX_OVERALL_SIZE = Integer.MAX_VALUE;
    private final int additionalReqParamsMaxOverallSize;
    public static final boolean DEFAULT_ALLOW_MULTIPLE_AUDIENCES_FOR_JWT_CLIENT_AUTHENTICATION = false;
    private final boolean allowMultipleAudiencesForJwtClientAuthentication;

    public OIDCProviderConfig(Config.Scope config) {
        this.additionalReqParamsMaxNumber = config.getInt("add-req-params-max-number", Integer.valueOf(5));
        this.additionalReqParamsMaxSize = config.getInt("add-req-params-max-size", Integer.valueOf(2000));
        this.additionalReqParamsMaxOverallSize = config.getInt("add-req-params-max-overall-size", Integer.valueOf(Integer.MAX_VALUE));
        this.additionalReqParamsFailFast = config.getBoolean("add-req-params-fail-fast", Boolean.valueOf(false));
        this.allowMultipleAudiencesForJwtClientAuthentication = config.getBoolean("allow-multiple-audiences-for-jwt-client-authentication", Boolean.valueOf(false));
    }

    public int getAdditionalReqParamsMaxNumber() {
        return this.additionalReqParamsMaxNumber;
    }

    public int getAdditionalReqParamsMaxSize() {
        return this.additionalReqParamsMaxSize;
    }

    public boolean isAdditionalReqParamsFailFast() {
        return this.additionalReqParamsFailFast;
    }

    public int getAdditionalReqParamsMaxOverallSize() {
        return this.additionalReqParamsMaxOverallSize;
    }

    public boolean isAllowMultipleAudiencesForJwtClientAuthentication() {
        return this.allowMultipleAudiencesForJwtClientAuthentication;
    }
}

