/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.TimeoutException;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractClusterExecutor;
import org.infinispan.manager.impl.ClusterExecutors;
import org.infinispan.manager.impl.ReplicableManagerFunctionCommand;
import org.infinispan.manager.impl.ReplicableRunnableCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.PassthroughSingleResponseCollector;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.security.Security;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class SingleClusterExecutor
extends AbstractClusterExecutor<SingleClusterExecutor> {
    private static final Log log = LogFactory.getLog(SingleClusterExecutor.class);

    SingleClusterExecutor(Predicate<? super Address> predicate, EmbeddedCacheManager manager, Transport transport, long time, TimeUnit unit, BlockingManager blockingManager, ScheduledExecutorService timeoutExecutor) {
        super(predicate, manager, transport, time, unit, blockingManager, timeoutExecutor);
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    protected SingleClusterExecutor sameClusterExecutor(Predicate<? super Address> predicate, long time, TimeUnit unit) {
        return new SingleClusterExecutor(predicate, this.manager, this.transport, time, unit, this.blockingManager, this.timeoutExecutor);
    }

    private Address findTarget() {
        List<Address> possibleTargets = this.getRealTargets(true);
        int size = possibleTargets.size();
        Address target = size == 0 ? null : (size == 1 ? possibleTargets.get(0) : possibleTargets.get(ThreadLocalRandom.current().nextInt(size)));
        return target;
    }

    @Override
    public void execute(Runnable runnable) {
        Address target = this.findTarget();
        if (target != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Submitting runnable to single remote node - JGroups Address %s", target);
            }
            if (target == this.me) {
                super.execute(runnable);
            } else {
                try {
                    ReplicableRunnableCommand command = new ReplicableRunnableCommand(runnable);
                    this.transport.sendTo(target, command, DeliverOrder.NONE);
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
            }
        }
    }

    @Override
    public CompletableFuture<Void> submit(Runnable runnable) {
        Address target = this.findTarget();
        if (target == null) {
            return CompletableFuture.failedFuture((Throwable)((Object)new SuspectException("No available nodes!")));
        }
        if (log.isTraceEnabled()) {
            log.tracef("Submitting runnable to single remote node - JGroups Address %s", target);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (target == this.me) {
            return super.submit(runnable);
        }
        ReplicableRunnableCommand command = new ReplicableRunnableCommand(runnable);
        CompletionStage<Response> request = this.transport.invokeCommand(target, (ReplicableCommand)command, PassthroughSingleResponseCollector.INSTANCE, DeliverOrder.NONE, this.time, this.unit);
        request.whenComplete((r, t) -> {
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            } else {
                this.consumeResponse((Response)r, target, future::completeExceptionally);
                future.complete(null);
            }
        });
        return future;
    }

    @Override
    public <V> CompletableFuture<Void> submitConsumer(Function<? super EmbeddedCacheManager, ? extends V> function, TriConsumer<? super Address, ? super V, ? super Throwable> triConsumer) {
        Address target = this.findTarget();
        if (target == null) {
            return CompletableFuture.failedFuture((Throwable)((Object)new SuspectException("No available nodes!")));
        }
        if (log.isTraceEnabled()) {
            log.tracef("Submitting runnable to single remote node - JGroups Address %s", target);
        }
        if (target == this.me) {
            return super.submitConsumer(function, triConsumer);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ReplicableManagerFunctionCommand command = new ReplicableManagerFunctionCommand(function, Security.getSubject());
        CompletionStage<Response> request = this.transport.invokeCommand(target, (ReplicableCommand)command, PassthroughSingleResponseCollector.INSTANCE, DeliverOrder.NONE, this.time, this.unit);
        request.whenComplete((r, t) -> {
            try {
                if (t != null) {
                    if (t instanceof TimeoutException) {
                        future.completeExceptionally(this.getLog().remoteNodeTimedOut(target, this.time, this.unit));
                    } else {
                        triConsumer.accept(target, (Object)null, (Throwable)t);
                    }
                } else {
                    this.consumeResponse((Response)r, target, v -> triConsumer.accept(target, (Object)v, (Throwable)null), throwable -> triConsumer.accept(target, (Object)null, (Throwable)throwable));
                }
                future.complete(null);
            }
            catch (Throwable throwable2) {
                future.completeExceptionally(throwable2);
            }
        });
        return future;
    }

    @Override
    public ClusterExecutor singleNodeSubmission() {
        return this;
    }

    @Override
    public ClusterExecutor singleNodeSubmission(int failOverCount) {
        if (failOverCount == 0) {
            return this;
        }
        return ClusterExecutors.singleNodeSubmissionExecutor(this.predicate, this.manager, this.transport, this.time, this.unit, this.blockingManager, this.timeoutExecutor, failOverCount);
    }

    @Override
    public ClusterExecutor allNodeSubmission() {
        return ClusterExecutors.allSubmissionExecutor(this.predicate, this.manager, this.transport, this.time, this.unit, this.blockingManager, this.timeoutExecutor);
    }
}

