/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.event.TextHelpModelEvent;
import javax.help.event.TextHelpModelListener;
import javax.help.plaf.HelpContentViewerUI;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;

public class BasicContentViewerUI
extends HelpContentViewerUI
implements HelpModelListener,
TextHelpModelListener,
HyperlinkListener,
PropertyChangeListener,
Serializable {
    protected JHelpContentViewer theViewer;
    private static Dimension PREF_SIZE = new Dimension(200, 300);
    private static Dimension MIN_SIZE = new Dimension(80, 80);
    private JEditorPane html;
    private JViewport vp;
    private Hashtable registry;
    private boolean loadingURL;
    private TextHelpModelEvent pendingHighlightsEvent;
    private static final boolean debug = false;
    private static final boolean debug1 = false;

    public BasicContentViewerUI(JHelpContentViewer jHelpContentViewer) {
        BasicContentViewerUI.debug("createUI - sort of");
    }

    static /* synthetic */ boolean access$1(BasicContentViewerUI basicContentViewerUI) {
        return basicContentViewerUI.loadingURL;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        BasicContentViewerUI.debug("createUI");
        return new BasicContentViewerUI((JHelpContentViewer)jComponent);
    }

    private static void debug(String string) {
    }

    private static void debug1(String string) {
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return PREF_SIZE;
    }

    public void highlightsChanged(TextHelpModelEvent textHelpModelEvent) {
        BasicContentViewerUI.debug("highlightsChanged " + textHelpModelEvent);
        if (this.loadingURL) {
            BasicContentViewerUI.debug("Humm. loadingURL wait a little");
            this.pendingHighlightsEvent = textHelpModelEvent;
            return;
        }
        Highlighter highlighter = this.html.getHighlighter();
        BasicContentViewerUI.debug1("removeAllHighlights");
        highlighter.removeAllHighlights();
        TextHelpModel textHelpModel = (TextHelpModel)textHelpModelEvent.getSource();
        TextHelpModel.Highlight[] highlightArray = textHelpModel.getHighlights();
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this.html.getSelectionColor());
        int n = 0;
        while (n < highlightArray.length) {
            int n2 = highlightArray[n].getStartOffset();
            int n3 = highlightArray[n].getEndOffset();
            BasicContentViewerUI.debug("  highlight: " + n2 + ", " + n3);
            try {
                highlighter.addHighlight(n2, n3, defaultHighlightPainter);
                if (n == 0) {
                    ScrollToPosition scrollToPosition = new ScrollToPosition(this.html, n3);
                    SwingUtilities.invokeLater(scrollToPosition);
                }
            }
            catch (BadLocationException badLocationException) {
                BasicContentViewerUI.debug("badLocationExcetpion thrown - " + badLocationException);
            }
            ++n;
        }
        RepaintManager.currentManager(this.html).markCompletelyDirty(this.html);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                ((HTMLDocument)this.html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
            } else {
                this.linkActivated(hyperlinkEvent.getURL());
            }
        }
    }

    public void idChanged(HelpModelEvent helpModelEvent) {
        Map.ID iD = helpModelEvent.getID();
        URL uRL = helpModelEvent.getURL();
        TextHelpModel textHelpModel = this.theViewer.getModel();
        BasicContentViewerUI.debug("idChanged(" + helpModelEvent + ")");
        BasicContentViewerUI.debug("  = " + iD + " " + uRL);
        BasicContentViewerUI.debug("  my helpModel: " + textHelpModel);
        textHelpModel.setDocumentTitle(null);
        try {
            Highlighter highlighter = this.html.getHighlighter();
            BasicContentViewerUI.debug("removeAllHighlights");
            highlighter.removeAllHighlights();
            try {
                this.loadingURL = true;
                this.html.setPage(uRL);
            }
            catch (Exception exception) {
                this.loadingURL = false;
            }
            BasicContentViewerUI.debug("html current EditorKit is: " + this.html.getEditorKit());
            BasicContentViewerUI.debug("html current ContentType is: " + this.html.getContentType());
        }
        catch (Exception exception) {
            BasicContentViewerUI.debug("Exception geneartated");
        }
        BasicContentViewerUI.debug("done with idChanged");
    }

    public void installUI(JComponent jComponent) {
        BasicContentViewerUI.debug("installUI");
        this.theViewer = (JHelpContentViewer)jComponent;
        this.theViewer.setLayout(new BorderLayout());
        this.theViewer.addPropertyChangeListener(this);
        TextHelpModel textHelpModel = this.theViewer.getModel();
        if (textHelpModel != null) {
            textHelpModel.addHelpModelListener(this);
            textHelpModel.addTextHelpModelListener(this);
        }
        this.html = new JHEditorPane();
        this.html.addPropertyChangeListener(this);
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(new BevelBorder(1, Color.white, Color.gray));
        this.vp = jScrollPane.getViewport();
        this.vp.add(this.html);
        this.vp.setBackingStoreEnabled(true);
        this.theViewer.add("Center", jScrollPane);
        this.loadingURL = false;
        this.pendingHighlightsEvent = null;
    }

    protected void linkActivated(URL uRL) {
        String string;
        BasicContentViewerUI.debug("linkActivated - URL=" + uRL);
        Cursor cursor = this.html.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor2);
        String string2 = uRL.getRef();
        if (string2 != null && ((string = uRL.getFile()).endsWith("/") || string.endsWith("\\"))) {
            uRL = this.html.getPage();
            BasicContentViewerUI.debug("current u=" + uRL);
            string = uRL.getFile();
            BasicContentViewerUI.debug("file=" + string);
            try {
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(string) + "#" + string2);
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
            BasicContentViewerUI.debug("new u=" + uRL);
        }
        SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        BasicContentViewerUI.debug("propertyChange: " + propertyChangeEvent.getPropertyName() + "\n\toldValue:" + propertyChangeEvent.getOldValue() + "\n\tnewValue:" + propertyChangeEvent.getNewValue());
        if (propertyChangeEvent.getSource() == this.theViewer) {
            String string2 = propertyChangeEvent.getPropertyName();
            if (string2.equals("helpModel")) {
                TextHelpModel textHelpModel = (TextHelpModel)propertyChangeEvent.getOldValue();
                TextHelpModel textHelpModel2 = (TextHelpModel)propertyChangeEvent.getNewValue();
                if (textHelpModel != null) {
                    textHelpModel.removeHelpModelListener(this);
                    textHelpModel.removeTextHelpModelListener(this);
                }
                if (textHelpModel2 != null) {
                    textHelpModel2.addHelpModelListener(this);
                    textHelpModel2.addTextHelpModelListener(this);
                }
                this.rebuild();
            } else if (string2.equals("font")) {
                BasicContentViewerUI.debug("font changed");
                Font font = (Font)propertyChangeEvent.getNewValue();
                EditorKit editorKit = this.html.getEditorKit();
                if (editorKit instanceof HTMLEditorKit) {
                    String string3 = "body { font-family: " + font.getFamily() + " }";
                    HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)editorKit;
                    StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
                    try {
                        styleSheet.loadRules(new StringReader(string3), null);
                    }
                    catch (Exception exception) {}
                }
                RepaintManager.currentManager(this.html).markCompletelyDirty(this.html);
            }
        } else if (propertyChangeEvent.getSource() == this.html && (string = propertyChangeEvent.getPropertyName()).equals("page")) {
            BasicContentViewerUI.debug("page finished loading");
            this.loadingURL = false;
            if (this.pendingHighlightsEvent != null) {
                BasicContentViewerUI.debug("Loading the highlights now");
                this.highlightsChanged(this.pendingHighlightsEvent);
                this.pendingHighlightsEvent = null;
            }
            Document document = this.html.getDocument();
            String string4 = (String)document.getProperty("title");
            TextHelpModel textHelpModel = this.theViewer.getModel();
            textHelpModel.setDocumentTitle(string4);
            this.theViewer.firePropertyChange(propertyChangeEvent.getPropertyName(), false, true);
        }
    }

    private void rebuild() {
        BasicContentViewerUI.debug("rebuild");
        TextHelpModel textHelpModel = this.theViewer.getModel();
        if (textHelpModel == null) {
            BasicContentViewerUI.debug("rebuild-end: model is null");
            return;
        }
        Highlighter highlighter = this.html.getHighlighter();
        BasicContentViewerUI.debug("removeAllHighlights");
        highlighter.removeAllHighlights();
        HelpSet helpSet = textHelpModel.getHelpSet();
        try {
            Map.ID iD = helpSet.getHomeID();
            textHelpModel.setCurrentID(iD);
        }
        catch (Exception exception) {}
        BasicContentViewerUI.debug("rebuld-end");
    }

    public void setEditorKit(String string, EditorKit editorKit) {
        BasicContentViewerUI.debug("setEditorKit(" + string + ", " + editorKit + ")");
        if (this.registry == null) {
            this.registry = new Hashtable(3);
        }
        this.registry.put(string, editorKit);
        if (this.html != null) {
            BasicContentViewerUI.debug("  type: " + string);
            BasicContentViewerUI.debug("  kit: " + editorKit);
            this.html.setEditorKitForContentType(string, editorKit);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        BasicContentViewerUI.debug("uninstallUI");
        JHelpContentViewer jHelpContentViewer = (JHelpContentViewer)jComponent;
        jHelpContentViewer.removePropertyChangeListener(this);
        this.html.removePropertyChangeListener(this);
        TextHelpModel textHelpModel = jHelpContentViewer.getModel();
        if (textHelpModel != null) {
            textHelpModel.removeHelpModelListener(this);
            textHelpModel.removeTextHelpModelListener(this);
        }
        jHelpContentViewer.setLayout(null);
        jHelpContentViewer.removeAll();
    }

    class JHEditorPane
    extends JEditorPane {
        private Hashtable typeHandlers;

        JHEditorPane() {
        }

        public EditorKit getEditorKitForContentType(String string) {
            EditorKit editorKit;
            if (this.typeHandlers == null) {
                this.typeHandlers = new Hashtable(3);
            }
            if ((editorKit = (EditorKit)this.typeHandlers.get(string)) == null && (editorKit = BasicContentViewerUI.this.theViewer.createEditorKitForContentType(string)) != null) {
                this.setEditorKitForContentType(string, editorKit);
                this.typeHandlers.put(string, editorKit);
            }
            if (editorKit == null && (editorKit = super.getEditorKitForContentType(string)) != null) {
                this.typeHandlers.put(string, editorKit);
            }
            return editorKit;
        }
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL uRL, Cursor cursor) {
            this.url = uRL;
            this.cursor = cursor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (this.url == null) {
                BasicContentViewerUI.this.html.setCursor(this.cursor);
                RepaintManager.currentManager(BasicContentViewerUI.this.html).markCompletelyDirty(BasicContentViewerUI.this.html);
                return;
            }
            Document document = BasicContentViewerUI.this.html.getDocument();
            try {
                try {
                    BasicContentViewerUI.this.html.setPage(this.url);
                    BasicContentViewerUI.this.loadingURL = true;
                    document = BasicContentViewerUI.this.html.getDocument();
                    String string = (String)document.getProperty("title");
                    TextHelpModel textHelpModel = BasicContentViewerUI.this.theViewer.getModel();
                    textHelpModel.setDocumentTitle(string);
                    Map.ID iD = textHelpModel.getHelpSet().getCombinedMap().getIDFromURL(this.url);
                    if (iD != null) {
                        try {
                            textHelpModel.setCurrentID(iD);
                        }
                        catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                            textHelpModel.setCurrentURL(this.url);
                        }
                    } else {
                        textHelpModel.setCurrentURL(this.url);
                    }
                }
                catch (IOException iOException) {
                    BasicContentViewerUI.this.loadingURL = false;
                    BasicContentViewerUI.this.html.setDocument(document);
                    BasicContentViewerUI.this.html.getToolkit().beep();
                }
                Object var4_5 = null;
                this.url = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.url = null;
                SwingUtilities.invokeLater(this);
                throw throwable;
            }
            SwingUtilities.invokeLater(this);
        }
    }

    private class ScrollToPosition
    implements Runnable {
        private int pos;
        private JEditorPane html;

        public ScrollToPosition(JEditorPane jEditorPane, int n) {
            this.html = jEditorPane;
            this.pos = n;
        }

        public void run() {
            try {
                Rectangle rectangle = this.html.modelToView(this.pos);
                if (rectangle != null) {
                    this.html.scrollRectToVisible(rectangle);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

