/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;

abstract class AddFromSelectionAction
extends AbstractRelationEditorAction {
    private static final long serialVersionUID = 1L;

    protected AddFromSelectionAction(IRelationEditorActionAccess editorAccess, IRelationEditorUpdateOn ... updateOn) {
        super(editorAccess, updateOn);
    }

    protected boolean isPotentialDuplicate(OsmPrimitive primitive) {
        return this.editorAccess.getMemberTableModel().hasMembersReferringTo(Collections.singleton(primitive));
    }

    protected List<OsmPrimitive> filterConfirmedPrimitives(List<OsmPrimitive> primitives) throws GenericRelationEditor.AddAbortException {
        if (primitives == null || primitives.isEmpty()) {
            return primitives;
        }
        ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>();
        ConditionalOptionPaneUtil.startBulkOperation("add_primitive_to_relation");
        for (OsmPrimitive primitive : primitives) {
            if (primitive instanceof Relation && this.editorAccess.getEditor().getRelation() != null && this.editorAccess.getEditor().getRelation().equals(primitive)) {
                GenericRelationEditor.warnOfCircularReferences(primitive);
                continue;
            }
            if (this.isPotentialDuplicate(primitive)) {
                if (!GenericRelationEditor.confirmAddingPrimitive(primitive)) continue;
                ret.add(primitive);
                continue;
            }
            ret.add(primitive);
        }
        ConditionalOptionPaneUtil.endBulkOperation("add_primitive_to_relation");
        return ret;
    }
}

