/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;

public class DiscoverInfoProvider
extends IqProvider<DiscoverInfo> {
    @Override
    public DiscoverInfo parse(XmlPullParser parser2, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        DiscoverInfoBuilder discoverInfoBuilder = DiscoverInfo.builder(iqData);
        String node2 = parser2.getAttributeValue("node");
        discoverInfoBuilder.setNode(node2);
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser2.next()) == XmlPullParser.Event.START_ELEMENT) {
                String name = parser2.getName();
                String namespace = parser2.getNamespace();
                if (namespace.equals("http://jabber.org/protocol/disco#info")) {
                    switch (name) {
                        case "identity": {
                            String category = parser2.getAttributeValue("category");
                            String identityName = parser2.getAttributeValue("name");
                            String type = parser2.getAttributeValue("type");
                            String lang = ParserUtils.getXmlLang(parser2);
                            DiscoverInfo.Identity identity = new DiscoverInfo.Identity(category, type, identityName, lang);
                            discoverInfoBuilder.addIdentity(identity);
                            break;
                        }
                        case "feature": {
                            String feature = parser2.getAttributeValue("var");
                            discoverInfoBuilder.addFeature(feature);
                        }
                    }
                    continue;
                }
                PacketParserUtils.addExtensionElement(discoverInfoBuilder, parser2, xmlEnvironment);
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser2.getDepth() == initialDepth) break;
        }
        DiscoverInfo discoverInfo = discoverInfoBuilder.buildWithoutValidiation();
        return discoverInfo;
    }
}

