/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

final class JcaTlsRSAEncryptor
implements TlsEncryptor {
    private final JcaTlsCrypto crypto;
    private final PublicKey pubKeyRSA;

    JcaTlsRSAEncryptor(JcaTlsCrypto jcaTlsCrypto, PublicKey publicKey) {
        this.crypto = jcaTlsCrypto;
        this.pubKeyRSA = publicKey;
    }

    @Override
    public byte[] encrypt(byte[] byArray, int n, int n2) throws IOException {
        try {
            Cipher cipher = this.crypto.createRSAEncryptionCipher();
            try {
                cipher.init(3, (Key)this.pubKeyRSA, this.crypto.getSecureRandom());
                return cipher.wrap(new SecretKeySpec(byArray, n, n2, "TLS"));
            }
            catch (Exception exception) {
                try {
                    cipher.init(1, (Key)this.pubKeyRSA, this.crypto.getSecureRandom());
                    return cipher.doFinal(byArray, n, n2);
                }
                catch (Exception exception2) {
                    throw new TlsFatalAlert(80, (Throwable)exception);
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
    }
}

