/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.spi.Indexer;

public class DirectoryIndexerProvider
extends AbstractIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:dir:*");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes) {
        int depth = 15;
        try {
            depth = Integer.valueOf(api.getPreferences().get("DirectoryIndexerPreferences.maximumDepth"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.index(api, entry, indexes, depth);
    }

    public void index(API api, Container.Entry entry, Indexes indexes, int depth) {
        if (depth-- > 0) {
            for (Container.Entry e : entry.getChildren()) {
                if (e.isDirectory()) {
                    this.index(api, e, indexes, depth);
                    continue;
                }
                Indexer indexer = api.getIndexer(e);
                if (indexer == null) continue;
                indexer.index(api, e, indexes);
            }
        }
    }
}

