/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.controller;

import java.awt.Desktop;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContentCopyable;
import org.jd.gui.api.feature.ContentIndexable;
import org.jd.gui.api.feature.ContentSavable;
import org.jd.gui.api.feature.ContentSearchable;
import org.jd.gui.api.feature.ContentSelectable;
import org.jd.gui.api.feature.FocusedTypeGettable;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.LineNumberNavigable;
import org.jd.gui.api.feature.PreferencesChangeListener;
import org.jd.gui.api.feature.SourcesSavable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.controller.AboutController;
import org.jd.gui.controller.GoToController;
import org.jd.gui.controller.OpenTypeController;
import org.jd.gui.controller.OpenTypeHierarchyController;
import org.jd.gui.controller.PreferencesController;
import org.jd.gui.controller.SaveAllSourcesController;
import org.jd.gui.controller.SearchInConstantPoolsController;
import org.jd.gui.controller.SelectLocationController;
import org.jd.gui.model.configuration.Configuration;
import org.jd.gui.model.history.History;
import org.jd.gui.service.actions.ContextualActionsFactoryService;
import org.jd.gui.service.container.ContainerFactoryService;
import org.jd.gui.service.fileloader.FileLoaderService;
import org.jd.gui.service.indexer.IndexerService;
import org.jd.gui.service.mainpanel.PanelFactoryService;
import org.jd.gui.service.pastehandler.PasteHandlerService;
import org.jd.gui.service.platform.PlatformService;
import org.jd.gui.service.preferencespanel.PreferencesPanelService;
import org.jd.gui.service.sourceloader.SourceLoaderService;
import org.jd.gui.service.sourcesaver.SourceSaverService;
import org.jd.gui.service.treenode.TreeNodeFactoryService;
import org.jd.gui.service.type.TypeFactoryService;
import org.jd.gui.service.uriloader.UriLoaderService;
import org.jd.gui.spi.ContainerFactory;
import org.jd.gui.spi.FileLoader;
import org.jd.gui.spi.Indexer;
import org.jd.gui.spi.PanelFactory;
import org.jd.gui.spi.PasteHandler;
import org.jd.gui.spi.SourceSaver;
import org.jd.gui.spi.TreeNodeFactory;
import org.jd.gui.spi.TypeFactory;
import org.jd.gui.spi.UriLoader;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.net.UriUtil;
import org.jd.gui.util.swing.SwingUtil;
import org.jd.gui.view.MainView;

public class MainController
implements API {
    protected Configuration configuration;
    protected MainView mainView;
    protected GoToController goToController;
    protected OpenTypeController openTypeController;
    protected OpenTypeHierarchyController openTypeHierarchyController;
    protected PreferencesController preferencesController;
    protected SearchInConstantPoolsController searchInConstantPoolsController;
    protected SaveAllSourcesController saveAllSourcesController;
    protected SelectLocationController selectLocationController;
    protected AboutController aboutController;
    protected SourceLoaderService sourceLoaderService;
    protected History history = new History();
    protected JComponent currentPage = null;
    protected ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    protected ArrayList<IndexesChangeListener> containerChangeListeners = new ArrayList();

    public MainController(Configuration configuration) {
        this.configuration = configuration;
        SwingUtil.invokeLater(() -> {
            if (PlatformService.getInstance().isLinux()) {
                SwingUtil.installGtkPopupBugWorkaround();
            }
            this.mainView = new MainView<Object>(configuration, this, this.history, e -> this.onOpen(), e -> this.onClose(), e -> this.onSaveSource(), e -> this.onSaveAllSources(), e -> System.exit(0), e -> this.onCopy(), e -> this.onPaste(), e -> this.onSelectAll(), e -> this.onFind(), e -> this.onFindPrevious(), e -> this.onFindNext(), e -> this.onFindCriteriaChanged(), () -> this.onFindCriteriaChanged(), e -> this.onOpenType(), e -> this.onOpenTypeHierarchy(), e -> this.onGoTo(), e -> this.openURI(this.history.backward()), e -> this.openURI(this.history.forward()), e -> this.onSearch(), e -> this.onJdWebSite(), e -> this.onJdGuiIssues(), e -> this.onJdCoreIssues(), e -> this.onPreferences(), e -> this.onAbout(), () -> this.panelClosed(), page -> this.onCurrentPageChanged((JComponent)page), file -> this.openFile((File)file));
        });
    }

    public void show(List<File> files) {
        SwingUtil.invokeLater(() -> {
            this.mainView.show(this.configuration.getMainWindowLocation(), this.configuration.getMainWindowSize(), this.configuration.isMainWindowMaximize());
            if (!files.isEmpty()) {
                this.openFiles(files);
            }
        });
        this.executor.schedule(() -> {
            UriLoaderService.getInstance();
            FileLoaderService.getInstance();
            ContainerFactoryService.getInstance();
            IndexerService.getInstance();
            TreeNodeFactoryService.getInstance();
            TypeFactoryService.getInstance();
            SwingUtil.invokeLater(() -> {
                this.mainView.updateRecentFilesMenu(this.configuration.getRecentFiles());
                JFrame mainFrame = this.mainView.getMainFrame();
                this.saveAllSourcesController = new SaveAllSourcesController(this, mainFrame);
                this.openTypeController = new OpenTypeController(this, this.executor, mainFrame);
                this.containerChangeListeners.add(this.openTypeController);
                this.openTypeHierarchyController = new OpenTypeHierarchyController(this, this.executor, mainFrame);
                this.containerChangeListeners.add(this.openTypeHierarchyController);
                this.goToController = new GoToController(this.configuration, mainFrame);
                this.searchInConstantPoolsController = new SearchInConstantPoolsController(this, this.executor, mainFrame);
                this.containerChangeListeners.add(this.searchInConstantPoolsController);
                this.preferencesController = new PreferencesController(this.configuration, mainFrame, PreferencesPanelService.getInstance().getProviders());
                this.selectLocationController = new SelectLocationController(this, mainFrame);
                this.aboutController = new AboutController(mainFrame);
                this.sourceLoaderService = new SourceLoaderService();
                mainFrame.addComponentListener(new MainFrameListener(this.configuration));
                mainFrame.setTransferHandler(new FilesTransferHandler());
                new JFileChooser().addChoosableFileFilter(new FileNameExtensionFilter("", "dummy"));
                FileSystemView.getFileSystemView().isFileSystemRoot(new File("dummy"));
                new JLayer();
            });
        }, 400L, TimeUnit.MILLISECONDS);
        PasteHandlerService.getInstance();
        PreferencesPanelService.getInstance();
        ContextualActionsFactoryService.getInstance();
        SourceSaverService.getInstance();
    }

    protected void onOpen() {
        HashMap<String, FileLoader> loaders = FileLoaderService.getInstance().getMapProviders();
        StringBuilder sb = new StringBuilder();
        ArrayList extensions = new ArrayList(loaders.keySet());
        extensions.sort(null);
        for (String extension : extensions) {
            sb.append("*.").append(extension).append(", ");
        }
        sb.setLength(sb.length() - 2);
        String description = sb.toString();
        String[] array = extensions.toArray(new String[0]);
        JFileChooser chooser = new JFileChooser();
        chooser.removeChoosableFileFilter(chooser.getFileFilter());
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("All files (" + description + ")", array));
        for (String extension : extensions) {
            FileLoader loader = (FileLoader)loaders.get(extension);
            chooser.addChoosableFileFilter(new FileNameExtensionFilter(loader.getDescription(), loader.getExtensions()));
        }
        chooser.setCurrentDirectory(this.configuration.getRecentLoadDirectory());
        if (chooser.showOpenDialog(this.mainView.getMainFrame()) == 0) {
            this.configuration.setRecentLoadDirectory(chooser.getCurrentDirectory());
            this.openFile(chooser.getSelectedFile());
        }
    }

    protected void onClose() {
        this.mainView.closeCurrentTab();
    }

    protected void onSaveSource() {
        if (this.currentPage instanceof ContentSavable) {
            JFileChooser chooser = new JFileChooser();
            JFrame mainFrame = this.mainView.getMainFrame();
            chooser.setSelectedFile(new File(this.configuration.getRecentSaveDirectory(), ((ContentSavable)((Object)this.currentPage)).getFileName()));
            if (chooser.showSaveDialog(mainFrame) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.configuration.setRecentSaveDirectory(chooser.getCurrentDirectory());
                if (selectedFile.exists()) {
                    String title = "Are you sure?";
                    String message = "The file '" + selectedFile.getAbsolutePath() + "' already isContainsIn.\n Do you want to replace the existing file?";
                    if (JOptionPane.showConfirmDialog(mainFrame, message, title, 0) == 0) {
                        this.save(selectedFile);
                    }
                } else {
                    this.save(selectedFile);
                }
            }
        }
    }

    protected void save(File selectedFile) {
        block14: {
            try (FileOutputStream os = new FileOutputStream(selectedFile);){
                ((ContentSavable)((Object)this.currentPage)).save(this, os);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block14;
                throw new AssertionError();
            }
        }
    }

    protected void onSaveAllSources() {
        Object currentPanel;
        if (!this.saveAllSourcesController.isActivated() && (currentPanel = this.mainView.getSelectedMainPanel()) instanceof SourcesSavable) {
            SourcesSavable sourcesSavable = (SourcesSavable)currentPanel;
            JFileChooser chooser = new JFileChooser();
            JFrame mainFrame = this.mainView.getMainFrame();
            chooser.setSelectedFile(new File(this.configuration.getRecentSaveDirectory(), sourcesSavable.getSourceFileName()));
            if (chooser.showSaveDialog(mainFrame) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.configuration.setRecentSaveDirectory(chooser.getCurrentDirectory());
                if (selectedFile.exists()) {
                    String title = "Are you sure?";
                    String message = "The file '" + selectedFile.getAbsolutePath() + "' already isContainsIn.\n Do you want to replace the existing file?";
                    if (JOptionPane.showConfirmDialog(mainFrame, message, title, 0) == 0) {
                        this.saveAllSourcesController.show(this.executor, sourcesSavable, selectedFile);
                    }
                } else {
                    this.saveAllSourcesController.show(this.executor, sourcesSavable, selectedFile);
                }
            }
        }
    }

    protected void onCopy() {
        if (this.currentPage instanceof ContentCopyable) {
            ((ContentCopyable)((Object)this.currentPage)).copy();
        }
    }

    protected void onPaste() {
        block4: {
            try {
                Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    Object obj = transferable.getTransferData(DataFlavor.stringFlavor);
                    PasteHandler pasteHandler = PasteHandlerService.getInstance().get(obj);
                    if (pasteHandler != null) {
                        pasteHandler.paste(this, obj);
                    }
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block4;
                throw new AssertionError();
            }
        }
    }

    protected void onSelectAll() {
        if (this.currentPage instanceof ContentSelectable) {
            ((ContentSelectable)((Object)this.currentPage)).selectAll();
        }
    }

    protected void onFind() {
        if (this.currentPage instanceof ContentSearchable) {
            this.mainView.showFindPanel();
        }
    }

    protected void onFindCriteriaChanged() {
        if (this.currentPage instanceof ContentSearchable) {
            this.mainView.setFindBackgroundColor(((ContentSearchable)((Object)this.currentPage)).highlightText(this.mainView.getFindText(), this.mainView.getFindCaseSensitive()));
        }
    }

    protected void onFindNext() {
        if (this.currentPage instanceof ContentSearchable) {
            ((ContentSearchable)((Object)this.currentPage)).findNext(this.mainView.getFindText(), this.mainView.getFindCaseSensitive());
        }
    }

    protected void onOpenType() {
        this.openTypeController.show(this.getCollectionOfFutureIndexes(), uri -> this.openURI((URI)uri));
    }

    protected void onOpenTypeHierarchy() {
        if (this.currentPage instanceof FocusedTypeGettable) {
            FocusedTypeGettable ftg = (FocusedTypeGettable)((Object)this.currentPage);
            this.openTypeHierarchyController.show(this.getCollectionOfFutureIndexes(), ftg.getEntry(), ftg.getFocusedTypeName(), uri -> this.openURI((URI)uri));
        }
    }

    protected void onGoTo() {
        if (this.currentPage instanceof LineNumberNavigable) {
            LineNumberNavigable lnn = (LineNumberNavigable)((Object)this.currentPage);
            this.goToController.show(lnn, lineNumber -> lnn.goToLineNumber(lineNumber));
        }
    }

    protected void onSearch() {
        this.searchInConstantPoolsController.show(this.getCollectionOfFutureIndexes(), uri -> this.openURI((URI)uri));
    }

    protected void onFindPrevious() {
        if (this.currentPage instanceof ContentSearchable) {
            ContentSearchable cs = (ContentSearchable)((Object)this.currentPage);
            cs.findPrevious(this.mainView.getFindText(), this.mainView.getFindCaseSensitive());
        }
    }

    protected void onJdWebSite() {
        block3: {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(URI.create("http://java-decompiler.github.io"));
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    protected void onJdGuiIssues() {
        block3: {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(URI.create("https://github.com/java-decompiler/jd-gui/issues"));
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    protected void onJdCoreIssues() {
        block3: {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(URI.create("https://github.com/java-decompiler/jd-core/issues"));
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    protected void onPreferences() {
        this.preferencesController.show(() -> {
            this.checkPreferencesChange(this.currentPage);
            this.mainView.preferencesChanged(this.getPreferences());
        });
    }

    protected void onAbout() {
        this.aboutController.show();
    }

    protected void onCurrentPageChanged(JComponent page) {
        this.currentPage = page;
        this.checkPreferencesChange(page);
        this.checkIndexesChange(page);
    }

    protected void checkPreferencesChange(JComponent page) {
        Integer lastHashcode;
        Map<String, String> preferences;
        Integer currentHashcode;
        if (page instanceof PreferencesChangeListener && !(currentHashcode = Integer.valueOf((preferences = this.configuration.getPreferences()).hashCode())).equals(lastHashcode = (Integer)page.getClientProperty("preferences-hashCode"))) {
            ((PreferencesChangeListener)((Object)page)).preferencesChanged(preferences);
            page.putClientProperty("preferences-hashCode", currentHashcode);
        }
    }

    protected void checkIndexesChange(JComponent page) {
        Integer lastHashcode;
        Collection<Future<Indexes>> collectionOfFutureIndexes;
        Integer currentHashcode;
        if (page instanceof IndexesChangeListener && !(currentHashcode = Integer.valueOf((collectionOfFutureIndexes = this.getCollectionOfFutureIndexes()).hashCode())).equals(lastHashcode = (Integer)page.getClientProperty("collectionOfFutureIndexes-hashCode"))) {
            ((IndexesChangeListener)((Object)page)).indexesChanged(collectionOfFutureIndexes);
            page.putClientProperty("collectionOfFutureIndexes-hashCode", currentHashcode);
        }
    }

    public void openFile(File file) {
        this.openFiles(Collections.singletonList(file));
    }

    public void openFiles(List<File> files) {
        ArrayList<String> errors = new ArrayList<String>();
        for (File file : files) {
            if (file.exists()) {
                FileLoader loader = this.getFileLoader(file);
                if (loader == null || loader.accept(this, file)) continue;
                errors.add("Invalid input fileloader: '" + file.getAbsolutePath() + "'");
                continue;
            }
            errors.add("File not found: '" + file.getAbsolutePath() + "'");
        }
        if (errors.isEmpty()) {
            for (File file : files) {
                if (!this.openURI(file.toURI())) continue;
                this.configuration.addRecentFile(file);
                this.mainView.updateRecentFilesMenu(this.configuration.getRecentFiles());
            }
        } else {
            StringBuilder messages = new StringBuilder();
            int index = 0;
            for (String error : errors) {
                if (index > 0) {
                    messages.append('\n');
                }
                if (index >= 20) {
                    messages.append("...");
                    break;
                }
                messages.append(error);
                ++index;
            }
            JOptionPane.showMessageDialog(this.mainView.getMainFrame(), messages.toString(), "Error", 0);
        }
    }

    protected void panelClosed() {
        SwingUtil.invokeLater(() -> {
            Collection<Future<Indexes>> collectionOfFutureIndexes = this.getCollectionOfFutureIndexes();
            for (IndexesChangeListener listener : this.containerChangeListeners) {
                listener.indexesChanged(collectionOfFutureIndexes);
            }
            if (this.currentPage instanceof IndexesChangeListener) {
                ((IndexesChangeListener)((Object)this.currentPage)).indexesChanged(collectionOfFutureIndexes);
            }
        });
    }

    @Override
    public boolean openURI(URI uri) {
        if (uri != null) {
            UriLoader uriLoader;
            boolean success = this.mainView.openUri(uri);
            if (!success && (uriLoader = this.getUriLoader(uri)) != null) {
                success = uriLoader.load(this, uri);
            }
            if (success) {
                this.addURI(uri);
            }
            return success;
        }
        return false;
    }

    @Override
    public boolean openURI(int x, int y, Collection<Container.Entry> entries, String query, String fragment) {
        if (entries != null) {
            if (entries.size() == 1) {
                Container.Entry entry2 = entries.iterator().next();
                return this.openURI(UriUtil.createURI(this, this.getCollectionOfFutureIndexes(), entry2, query, fragment));
            }
            Collection<Future<Indexes>> collectionOfFutureIndexes = this.getCollectionOfFutureIndexes();
            this.selectLocationController.show(new Point(x + 18, y + 2), entries, entry -> this.openURI(UriUtil.createURI(this, collectionOfFutureIndexes, entry, query, fragment)), () -> {});
            return true;
        }
        return false;
    }

    @Override
    public void addURI(URI uri) {
        this.history.add(uri);
        SwingUtil.invokeLater(() -> this.mainView.updateHistoryActions());
    }

    @Override
    public <T extends JComponent> void addPanel(String title, Icon icon, String tip, T component) {
        this.mainView.addMainPanel(title, icon, tip, component);
        if (component instanceof ContentIndexable) {
            Future<Indexes> futureIndexes = this.executor.submit(() -> {
                Indexes indexes = ((ContentIndexable)((Object)component)).index(this);
                SwingUtil.invokeLater(() -> {
                    Collection<Future<Indexes>> collectionOfFutureIndexes = this.getCollectionOfFutureIndexes();
                    for (IndexesChangeListener listener : this.containerChangeListeners) {
                        listener.indexesChanged(collectionOfFutureIndexes);
                    }
                    if (this.currentPage instanceof IndexesChangeListener) {
                        ((IndexesChangeListener)((Object)this.currentPage)).indexesChanged(collectionOfFutureIndexes);
                    }
                });
                return indexes;
            });
            component.putClientProperty("indexes", futureIndexes);
        }
    }

    @Override
    public Collection<Action> getContextualActions(Container.Entry entry, String fragment) {
        return ContextualActionsFactoryService.getInstance().get(this, entry, fragment);
    }

    @Override
    public FileLoader getFileLoader(File file) {
        return FileLoaderService.getInstance().get(this, file);
    }

    @Override
    public UriLoader getUriLoader(URI uri) {
        return UriLoaderService.getInstance().get(this, uri);
    }

    @Override
    public PanelFactory getMainPanelFactory(Container container) {
        return PanelFactoryService.getInstance().get(container);
    }

    @Override
    public ContainerFactory getContainerFactory(Path rootPath) {
        return ContainerFactoryService.getInstance().get(this, rootPath);
    }

    @Override
    public TreeNodeFactory getTreeNodeFactory(Container.Entry entry) {
        return TreeNodeFactoryService.getInstance().get(entry);
    }

    @Override
    public TypeFactory getTypeFactory(Container.Entry entry) {
        return TypeFactoryService.getInstance().get(entry);
    }

    @Override
    public Indexer getIndexer(Container.Entry entry) {
        return IndexerService.getInstance().get(entry);
    }

    @Override
    public SourceSaver getSourceSaver(Container.Entry entry) {
        return SourceSaverService.getInstance().get(entry);
    }

    @Override
    public Map<String, String> getPreferences() {
        return this.configuration.getPreferences();
    }

    @Override
    public Collection<Future<Indexes>> getCollectionOfFutureIndexes() {
        List mainPanels = this.mainView.getMainPanels();
        ArrayList<Future<Indexes>> list = new ArrayList<Future<Indexes>>(mainPanels.size()){

            @Override
            public int hashCode() {
                int hashCode;
                block3: {
                    hashCode = 1;
                    try {
                        for (Future futureIndexes : this) {
                            hashCode *= 31;
                            if (!futureIndexes.isDone()) continue;
                            hashCode += ((Indexes)futureIndexes.get()).hashCode();
                        }
                    }
                    catch (Exception e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block3;
                        throw new AssertionError();
                    }
                }
                return hashCode;
            }
        };
        for (JComponent panel : mainPanels) {
            Future futureIndexes = (Future)panel.getClientProperty("indexes");
            if (futureIndexes == null) continue;
            list.add(futureIndexes);
        }
        return list;
    }

    @Override
    public String getSource(Container.Entry entry) {
        return this.sourceLoaderService.getSource(this, entry);
    }

    @Override
    public void loadSource(Container.Entry entry, API.LoadSourceListener listener) {
        this.executor.execute(() -> {
            String source = this.sourceLoaderService.loadSource(this, entry);
            if (source != null && !source.isEmpty()) {
                listener.sourceLoaded(source);
            }
        });
    }

    @Override
    public File loadSourceFile(Container.Entry entry) {
        return this.sourceLoaderService.getSourceFile(this, entry);
    }

    protected class MainFrameListener
    extends ComponentAdapter {
        protected Configuration configuration;

        public MainFrameListener(Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            JFrame mainFrame = MainController.this.mainView.getMainFrame();
            if ((mainFrame.getExtendedState() & 6) == 6) {
                this.configuration.setMainWindowMaximize(true);
            } else {
                this.configuration.setMainWindowLocation(mainFrame.getLocation());
                this.configuration.setMainWindowMaximize(false);
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            JFrame mainFrame = MainController.this.mainView.getMainFrame();
            if ((mainFrame.getExtendedState() & 6) == 6) {
                this.configuration.setMainWindowMaximize(true);
            } else {
                this.configuration.setMainWindowSize(mainFrame.getSize());
                this.configuration.setMainWindowMaximize(false);
            }
        }
    }

    protected class FilesTransferHandler
    extends TransferHandler {
        protected FilesTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            block3: {
                if (info.isDrop() && info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    try {
                        MainController.this.openFiles((List)info.getTransferable().getTransferData(DataFlavor.javaFileListFlavor));
                        return true;
                    }
                    catch (Exception e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block3;
                        throw new AssertionError();
                    }
                }
            }
            return false;
        }
    }
}

