/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStatusBarProgress;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CustomVcsLogUiFactoryProvider;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsWatcher;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerFactory;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogManager.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @Nullable
    private final BiConsumer<? super VcsLogErrorHandler.Source, ? super Throwable> myRecreateMainLogHandler;
    @NotNull
    private final String myName;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @Nullable
    private VcsLogTabsWatcher myTabsWatcher;
    @NotNull
    private final PostponableLogRefresher myPostponableRefresher;
    @NotNull
    private final VcsLogStatusBarProgress myStatusBarProgress;
    private boolean myDisposed;

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<VcsRoot> roots) {
        if (project == null) {
            VcsLogManager.$$$reportNull$$$0(0);
        }
        if (uiProperties == null) {
            VcsLogManager.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            VcsLogManager.$$$reportNull$$$0(2);
        }
        this(project, uiProperties, VcsLogManager.findLogProviders(roots, project));
    }

    private VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (project == null) {
            VcsLogManager.$$$reportNull$$$0(3);
        }
        if (uiProperties == null) {
            VcsLogManager.$$$reportNull$$$0(4);
        }
        if (logProviders == null) {
            VcsLogManager.$$$reportNull$$$0(5);
        }
        this(project, uiProperties, logProviders, "Vcs Log for " + VcsLogUtil.getProvidersMapText(logProviders), true, false, null);
    }

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull String name, boolean scheduleRefreshImmediately, boolean isIndexEnabled, @Nullable BiConsumer<? super VcsLogErrorHandler.Source, ? super Throwable> recreateHandler) {
        if (project == null) {
            VcsLogManager.$$$reportNull$$$0(6);
        }
        if (uiProperties == null) {
            VcsLogManager.$$$reportNull$$$0(7);
        }
        if (logProviders == null) {
            VcsLogManager.$$$reportNull$$$0(8);
        }
        if (name == null) {
            VcsLogManager.$$$reportNull$$$0(9);
        }
        this.myProject = project;
        this.myUiProperties = uiProperties;
        this.myRecreateMainLogHandler = recreateHandler;
        this.myName = name;
        this.myLogData = new VcsLogData(this.myProject, logProviders, new MyErrorHandler(), isIndexEnabled, this);
        this.myPostponableRefresher = new PostponableLogRefresher(this.myLogData);
        VcsLogManager.refreshLogOnVcsEvents(logProviders, this.myPostponableRefresher, this.myLogData);
        this.myColorManager = VcsLogColorManagerFactory.create(logProviders.keySet());
        this.myStatusBarProgress = new VcsLogStatusBarProgress(this.myProject, logProviders, this.myLogData.getIndex().getIndexingRoots(), this.myLogData.getProgress());
        if (scheduleRefreshImmediately) {
            this.scheduleInitialization();
        }
    }

    @ApiStatus.Internal
    public void scheduleInitialization() {
        this.myLogData.initialize();
    }

    @RequiresEdt
    public boolean isLogVisible() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myPostponableRefresher.isLogVisible();
    }

    @ApiStatus.Internal
    @RequiresEdt
    public boolean isLogUpToDate() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myLogData.getDataPack().isFull() && !this.myPostponableRefresher.hasPostponedRoots();
    }

    @ApiStatus.Internal
    @RequiresEdt
    public void scheduleUpdate() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myLogData.initialize();
        this.myPostponableRefresher.refreshPostponedRoots();
    }

    @NotNull
    public VcsLogData getDataManager() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            VcsLogManager.$$$reportNull$$$0(10);
        }
        return vcsLogData;
    }

    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            VcsLogManager.$$$reportNull$$$0(11);
        }
        return vcsLogColorManager;
    }

    @NotNull
    public VcsLogTabsProperties getUiProperties() {
        VcsLogTabsProperties vcsLogTabsProperties = this.myUiProperties;
        if (vcsLogTabsProperties == null) {
            VcsLogManager.$$$reportNull$$$0(12);
        }
        return vcsLogTabsProperties;
    }

    @NotNull
    public MainVcsLogUi createLogUi(@NotNull String logId, @NotNull VcsLogTabLocation location) {
        if (logId == null) {
            VcsLogManager.$$$reportNull$$$0(13);
        }
        if (location == null) {
            VcsLogManager.$$$reportNull$$$0(14);
        }
        return this.createLogUi(this.getMainLogUiFactory(logId, null), location, true);
    }

    @NotNull
    MainVcsLogUi createLogUi(@NotNull String logId, @NotNull VcsLogTabLocation location, boolean isClosedOnDispose) {
        if (logId == null) {
            VcsLogManager.$$$reportNull$$$0(15);
        }
        if (location == null) {
            VcsLogManager.$$$reportNull$$$0(16);
        }
        return this.createLogUi(this.getMainLogUiFactory(logId, null), location, isClosedOnDispose);
    }

    @NotNull
    public VcsLogUiFactory<? extends MainVcsLogUi> getMainLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters) {
        CustomVcsLogUiFactoryProvider factoryProvider;
        if (logId == null) {
            VcsLogManager.$$$reportNull$$$0(17);
        }
        if ((factoryProvider = (CustomVcsLogUiFactoryProvider)CustomVcsLogUiFactoryProvider.LOG_CUSTOM_UI_FACTORY_PROVIDER_EP.findFirstSafe((AreaInstance)this.myProject, p -> p.isActive(this.myLogData.getLogProviders()))) == null) {
            return new MainVcsLogUiFactory(logId, filters, this.myUiProperties, this.myColorManager);
        }
        VcsLogUiFactory<? extends MainVcsLogUi> vcsLogUiFactory = factoryProvider.createLogUiFactory(logId, this, filters);
        if (vcsLogUiFactory == null) {
            VcsLogManager.$$$reportNull$$$0(18);
        }
        return vcsLogUiFactory;
    }

    @NotNull
    private VcsLogTabsWatcher getTabsWatcher() {
        LOG.assertTrue(!this.myDisposed);
        if (this.myTabsWatcher == null) {
            this.myTabsWatcher = new VcsLogTabsWatcher(this.myProject, this.myPostponableRefresher);
        }
        VcsLogTabsWatcher vcsLogTabsWatcher = this.myTabsWatcher;
        if (vcsLogTabsWatcher == null) {
            VcsLogManager.$$$reportNull$$$0(19);
        }
        return vcsLogTabsWatcher;
    }

    @NotNull
    public <U extends VcsLogUiEx> U createLogUi(@NotNull VcsLogUiFactory<U> factory, @NotNull VcsLogTabLocation location) {
        if (factory == null) {
            VcsLogManager.$$$reportNull$$$0(20);
        }
        if (location == null) {
            VcsLogManager.$$$reportNull$$$0(21);
        }
        return this.createLogUi(factory, location, true);
    }

    @NotNull
    private <U extends VcsLogUiEx> U createLogUi(@NotNull VcsLogUiFactory<U> factory, @NotNull VcsLogTabLocation location, boolean isClosedOnDispose) {
        if (factory == null) {
            VcsLogManager.$$$reportNull$$$0(22);
        }
        if (location == null) {
            VcsLogManager.$$$reportNull$$$0(23);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed()) {
            LOG.error("Trying to create new VcsLogUi on a disposed VcsLogManager instance");
            throw new ProcessCanceledException();
        }
        U ui = factory.createLogUi(this.myProject, this.myLogData);
        Disposer.register(ui, (Disposable)this.getTabsWatcher().addTabToWatch((VcsLogUiEx)ui, location, isClosedOnDispose));
        U u = ui;
        if (u == null) {
            VcsLogManager.$$$reportNull$$$0(24);
        }
        return u;
    }

    @NotNull
    public List<? extends VcsLogUi> getLogUis() {
        if (this.myTabsWatcher == null) {
            List list = Collections.emptyList();
            if (list == null) {
                VcsLogManager.$$$reportNull$$$0(25);
            }
            return list;
        }
        List<VcsLogUiEx> list = this.getTabsWatcher().getTabs();
        if (list == null) {
            VcsLogManager.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public List<? extends VcsLogUi> getLogUis(@NotNull VcsLogTabLocation location) {
        if (location == null) {
            VcsLogManager.$$$reportNull$$$0(27);
        }
        if (this.myTabsWatcher == null) {
            List list = Collections.emptyList();
            if (list == null) {
                VcsLogManager.$$$reportNull$$$0(28);
            }
            return list;
        }
        List<VcsLogUiEx> list = this.getTabsWatcher().getTabs(location);
        if (list == null) {
            VcsLogManager.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public List<? extends VcsLogUi> getVisibleLogUis(@NotNull VcsLogTabLocation location) {
        if (location == null) {
            VcsLogManager.$$$reportNull$$$0(30);
        }
        if (this.myTabsWatcher == null) {
            List list = Collections.emptyList();
            if (list == null) {
                VcsLogManager.$$$reportNull$$$0(31);
            }
            return list;
        }
        List<VcsLogUiEx> list = this.getTabsWatcher().getVisibleTabs(location);
        if (list == null) {
            VcsLogManager.$$$reportNull$$$0(32);
        }
        return list;
    }

    @ApiStatus.Internal
    @NonNls
    public String getLogWindowsInformation() {
        return this.myPostponableRefresher.getLogWindowsInformation();
    }

    @NonNls
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            VcsLogManager.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static void refreshLogOnVcsEvents(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull PostponableLogRefresher refresher, @NotNull Disposable disposableParent) {
        if (logProviders == null) {
            VcsLogManager.$$$reportNull$$$0(34);
        }
        if (refresher == null) {
            VcsLogManager.$$$reportNull$$$0(35);
        }
        if (disposableParent == null) {
            VcsLogManager.$$$reportNull$$$0(36);
        }
        MultiMap providers2roots = MultiMap.create();
        logProviders.forEach((key, value) -> providers2roots.putValue(value, key));
        VcsLogRefresher wrappedRefresher = root -> ApplicationManager.getApplication().invokeLater(() -> refresher.refresh(root), ModalityState.any());
        for (Map.Entry entry : providers2roots.entrySet()) {
            Disposable disposable = ((VcsLogProvider)entry.getKey()).subscribeToRootRefreshEvents((Collection)entry.getValue(), wrappedRefresher);
            Disposer.register((Disposable)disposableParent, (Disposable)disposable);
        }
    }

    @NotNull
    public static Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<VcsRoot> roots, @NotNull Project project) {
        if (roots == null) {
            VcsLogManager.$$$reportNull$$$0(37);
        }
        if (project == null) {
            VcsLogManager.$$$reportNull$$$0(38);
        }
        if (roots.isEmpty()) {
            Map<VirtualFile, VcsLogProvider> map = Collections.emptyMap();
            if (map == null) {
                VcsLogManager.$$$reportNull$$$0(39);
            }
            return map;
        }
        HashMap<VirtualFile, VcsLogProvider> logProviders = new HashMap<VirtualFile, VcsLogProvider>();
        List allLogProviders = VcsLogProvider.LOG_PROVIDER_EP.getExtensionList((AreaInstance)project);
        block0: for (VcsRoot root : roots) {
            AbstractVcs vcs = root.getVcs();
            VirtualFile path = root.getPath();
            if (vcs == null) {
                LOG.debug("Skipping invalid VCS root: " + root);
                continue;
            }
            for (VcsLogProvider provider : allLogProviders) {
                if (!provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
                logProviders.put(path, provider);
                continue block0;
            }
        }
        HashMap<VirtualFile, VcsLogProvider> hashMap = logProviders;
        if (hashMap == null) {
            VcsLogManager.$$$reportNull$$$0(40);
        }
        return hashMap;
    }

    @RequiresEdt
    void disposeUi() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myDisposed = true;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myTabsWatcher != null) {
            Disposer.dispose((Disposable)this.myTabsWatcher);
        }
        Disposer.dispose((Disposable)this.myStatusBarProgress);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void dispose(@Nullable Runnable runnable) {
        void callback;
        ThreadingAssertions.assertEventDispatchThread();
        this.disposeUi();
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.lambda$dispose$4((Runnable)callback));
    }

    @RequiresBackgroundThread
    public void dispose() {
        ThreadingAssertions.assertBackgroundThread();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        LOG.debug("Disposed " + this.myName);
    }

    @RequiresEdt
    public boolean isDisposed() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myDisposed;
    }

    private /* synthetic */ void lambda$dispose$4(Runnable callback) {
        Disposer.dispose((Disposable)this);
        if (callback != null) {
            callback.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 18, 19, 24, 25, 26, 28, 29, 31, 32, 33, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 2: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 5: 
            case 8: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogManager";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 14: 
            case 16: 
            case 21: 
            case 23: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiProperties";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainLogUiFactory";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabsWatcher";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogUi";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogUis";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleLogUis";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findLogProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 39: 
            case 40: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createLogUi";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMainLogUiFactory";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLogUis";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleLogUis";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "refreshLogOnVcsEvents";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findLogProviders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 18, 19, 24, 25, 26, 28, 29, 31, 32, 33, 39, 40 -> new IllegalStateException(string);
        };
    }

    private class MyErrorHandler
    implements VcsLogErrorHandler {
        @NotNull
        private final IntSet myErrors = IntSets.synchronize((IntSet)new IntOpenHashSet());
        @NotNull
        private final AtomicBoolean myIsBroken = new AtomicBoolean(false);

        private MyErrorHandler() {
        }

        @Override
        public void handleError(@Nullable VcsLogErrorHandler.Source source, @NotNull Throwable throwable) {
            if (throwable == null) {
                MyErrorHandler.$$$reportNull$$$0(0);
            }
            if (this.myIsBroken.compareAndSet(false, true)) {
                if (VcsLogManager.this.myRecreateMainLogHandler != null) {
                    ApplicationManager.getApplication().invokeLater(() -> VcsLogManager.this.myRecreateMainLogHandler.accept(source, throwable));
                } else {
                    LOG.error((String)(source != null ? "Vcs Log exception from " + source : throwable.getMessage()), throwable);
                }
                if (source == VcsLogErrorHandler.Source.Storage) {
                    ((VcsLogModifiableIndex)VcsLogManager.this.myLogData.getIndex()).markCorrupted();
                }
            } else {
                int errorHashCode = ThrowableInterner.computeTraceHashCode((Throwable)throwable);
                if (this.myErrors.add(errorHashCode)) {
                    LOG.debug("Vcs Log storage is broken and is being recreated", throwable);
                }
            }
        }

        @Override
        public void displayMessage(@Nls @NotNull String message) {
            if (message == null) {
                MyErrorHandler.$$$reportNull$$$0(1);
            }
            VcsNotifier.getInstance((Project)VcsLogManager.this.myProject).notifyError("vcs.log.fatal.error", "", message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "throwable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager$MyErrorHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleError";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "displayMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface VcsLogUiFactory<T extends VcsLogUiEx> {
        @ApiStatus.OverrideOnly
        public T createLogUi(@NotNull Project var1, @NotNull VcsLogData var2);
    }

    private static class MainVcsLogUiFactory
    extends BaseVcsLogUiFactory<VcsLogUiImpl> {
        MainVcsLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters, @NotNull VcsLogTabsProperties properties, @NotNull VcsLogColorManager colorManager) {
            if (logId == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(1);
            }
            if (colorManager == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(2);
            }
            super(logId, filters, properties, colorManager);
        }

        @Override
        @NotNull
        protected VcsLogUiImpl createVcsLogUiImpl(@NotNull String logId, @NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties properties, @NotNull VcsLogColorManager colorManager, @NotNull VisiblePackRefresherImpl refresher, @Nullable VcsLogFilterCollection filters) {
            if (logId == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(3);
            }
            if (logData == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(4);
            }
            if (properties == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(5);
            }
            if (colorManager == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(6);
            }
            if (refresher == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(7);
            }
            return new VcsLogUiImpl(logId, logData, colorManager, properties, refresher, filters);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logId";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorManager";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refresher";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager$MainVcsLogUiFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createVcsLogUiImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class BaseVcsLogUiFactory<T extends VcsLogUiImpl>
    implements VcsLogUiFactory<T> {
        @NotNull
        private final String myLogId;
        @Nullable
        private final VcsLogFilterCollection myFilters;
        @NotNull
        private final VcsLogTabsProperties myUiProperties;
        @NotNull
        private final VcsLogColorManager myColorManager;

        public BaseVcsLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters, @NotNull VcsLogTabsProperties uiProperties, @NotNull VcsLogColorManager colorManager) {
            if (logId == null) {
                BaseVcsLogUiFactory.$$$reportNull$$$0(0);
            }
            if (uiProperties == null) {
                BaseVcsLogUiFactory.$$$reportNull$$$0(1);
            }
            if (colorManager == null) {
                BaseVcsLogUiFactory.$$$reportNull$$$0(2);
            }
            this.myLogId = logId;
            this.myFilters = filters;
            this.myUiProperties = uiProperties;
            this.myColorManager = colorManager;
        }

        @Override
        public T createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            if (project == null) {
                BaseVcsLogUiFactory.$$$reportNull$$$0(3);
            }
            if (logData == null) {
                BaseVcsLogUiFactory.$$$reportNull$$$0(4);
            }
            MainVcsLogUiProperties properties = this.myUiProperties.createProperties(this.myLogId);
            VcsLogFiltererImpl vcsLogFilterer = new VcsLogFiltererImpl(logData);
            PermanentGraph.Options initialOptions = properties.get(MainVcsLogUiProperties.GRAPH_OPTIONS);
            VcsLogFilterCollection initialFilters = this.myFilters == null ? VcsLogFilterObject.collection(new VcsLogFilter[0]) : this.myFilters;
            VisiblePackRefresherImpl refresher = new VisiblePackRefresherImpl(project, logData, initialFilters, initialOptions, vcsLogFilterer, this.myLogId);
            return this.createVcsLogUiImpl(this.myLogId, logData, properties, this.myColorManager, refresher, this.myFilters);
        }

        @NotNull
        protected abstract T createVcsLogUiImpl(@NotNull String var1, @NotNull VcsLogData var2, @NotNull MainVcsLogUiProperties var3, @NotNull VcsLogColorManager var4, @NotNull VisiblePackRefresherImpl var5, @Nullable VcsLogFilterCollection var6);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiProperties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager$BaseVcsLogUiFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLogUi";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

