/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.ContentRootChangeListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionCalculator;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionMapper;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;
import org.jetbrains.idea.perforce.perforce.connections.PerforceP4ConfigVirtualFileListener;
import org.jetbrains.idea.perforce.perforce.connections.SingletonConnection;

public class PerforceConnectionManager
implements PerforceConnectionManagerI {
    private static final Logger LOG = Logger.getInstance(PerforceConnectionManager.class);
    private final PerforceSettings mySettings;
    private final Project myProject;
    private PerforceConnectionMapper myConnectionMapper;
    private final Object myLock = new Object();
    private final PerforceConnectionProblemsNotifier myNotifier;
    private boolean isInitializing;

    public PerforceConnectionManager(Project project) {
        this.myNotifier = (PerforceConnectionProblemsNotifier)((Object)project.getService(PerforceConnectionProblemsNotifier.class));
        this.mySettings = PerforceSettings.getSettings(project);
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialized() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myConnectionMapper != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private PerforceConnectionMapper getConnectionMapper() {
        PerforceConnectionMapper perforceConnectionMapper;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnectionMapper == null) return this.initialize();
            perforceConnectionMapper = this.myConnectionMapper;
        }
        if (perforceConnectionMapper != null) return perforceConnectionMapper;
        PerforceConnectionManager.$$$reportNull$$$0(0);
        return perforceConnectionMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PerforceConnectionMapper initialize() {
        void var1_3;
        if (this.isSingletonConnectionUsed()) {
            SingletonConnection singletonConnection = SingletonConnection.getInstance(this.myProject);
        } else {
            P4ConnectionCalculator calculator = new P4ConnectionCalculator(this.myProject);
            calculator.execute();
            PerforceMultipleConnections perforceMultipleConnections = calculator.getMultipleConnections();
        }
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myConnectionMapper == null) {
            this.myConnectionMapper = var1_3;
            if (var1_3 instanceof PerforceMultipleConnections) {
                this.myNotifier.setProblems(((PerforceMultipleConnections)var1_3).hasAnyErrors(), false);
            }
        }
        void v0 = var1_3;
        // MONITOREXIT : object
        if (v0 != null) return v0;
        PerforceConnectionManager.$$$reportNull$$$0(1);
        return v0;
    }

    @Override
    @Nullable
    public PerforceMultipleConnections getMultipleConnectionObject() {
        PerforceConnectionMapper mapper = this.getConnectionMapper();
        return mapper instanceof PerforceMultipleConnections ? (PerforceMultipleConnections)mapper : null;
    }

    public static PerforceConnectionManagerI getInstance(Project project) {
        return (PerforceConnectionManagerI)project.getService(PerforceConnectionManagerI.class);
    }

    @Override
    @NotNull
    public Map<VirtualFile, P4Connection> getAllConnections() {
        Map<VirtualFile, P4Connection> map = this.getConnectionMapper().getAllConnections();
        if (map == null) {
            PerforceConnectionManager.$$$reportNull$$$0(2);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleInitialization() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnectionMapper != null || this.isInitializing) {
                return;
            }
            this.isInitializing = true;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.myProject.isDisposed()) {
                this.isInitializing = false;
                return;
            }
            this.initialize();
            PerforceConnectionManager perforceConnectionManager = this;
            synchronized (perforceConnectionManager) {
                this.isInitializing = false;
            }
        });
    }

    private Project getProject() {
        return this.myProject;
    }

    @Nullable
    public static VirtualFile findNearestLiveParentFor(File ioFile) {
        do {
            VirtualFile parent;
            if ((parent = LocalFileSystem.getInstance().findFileByIoFile(ioFile)) == null) continue;
            return parent;
        } while ((ioFile = ioFile.getParentFile()) != null);
        return null;
    }

    @Override
    @Nullable
    public P4Connection getConnectionForFile(@NotNull File file) {
        PerforceConnectionMapper mapper;
        if (file == null) {
            PerforceConnectionManager.$$$reportNull$$$0(3);
        }
        if ((mapper = this.getConnectionMapper()) instanceof SingletonConnection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getConnectionForFile(" + file + ") returning singleton");
            }
            return (P4Connection)((Object)mapper);
        }
        VirtualFile vFile = PerforceConnectionManager.findNearestLiveParentFor(file);
        if (vFile == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getConnectionForFile(" + file + ") found no live parent");
            }
            return null;
        }
        return mapper.getConnection(vFile);
    }

    @Override
    public P4Connection getConnectionForFile(@NotNull P4File file) {
        if (file == null) {
            PerforceConnectionManager.$$$reportNull$$$0(4);
        }
        return this.getConnectionForFile(file.getLocalFile());
    }

    @Override
    public P4Connection getConnectionForFile(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceConnectionManager.$$$reportNull$$$0(5);
        }
        return this.getConnectionMapper().getConnection(file);
    }

    @Override
    public boolean isSingletonConnectionUsed() {
        return !this.mySettings.useP4CONFIG;
    }

    public void startListening(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PerforceConnectionManager.$$$reportNull$$$0(6);
        }
        MessageBusConnection busConnection = this.getProject().getMessageBus().connect(parentDisposable);
        busConnection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new MyContentRootChangeListener());
        busConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, this::updateConnections);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new PerforceP4ConfigVirtualFileListener(this, this.myProject), parentDisposable);
        this.updateConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConnections() {
        Object object = this.myLock;
        synchronized (object) {
            this.myConnectionMapper = null;
        }
        PerforceManager manager = PerforceManager.getInstance(this.getProject());
        manager.configurationChanged();
    }

    @Override
    public boolean isUnderProjectConnections(@NotNull File file) {
        if (file == null) {
            PerforceConnectionManager.$$$reportNull$$$0(7);
        }
        Set<VirtualFile> allRoots = this.getConnectionMapper().getAllConnections().keySet();
        return ContainerUtil.or(allRoots, root -> FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)file, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionMapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initialize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConnections";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionForFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startListening";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnderProjectConnections";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private class MyContentRootChangeListener
    extends ContentRootChangeListener {
        private MyContentRootChangeListener() {
            super(false);
        }

        public void contentRootsChanged(@NotNull List<? extends VirtualFile> removed, @NotNull List<? extends VirtualFile> added) {
            if (removed == null) {
                MyContentRootChangeListener.$$$reportNull$$$0(0);
            }
            if (added == null) {
                MyContentRootChangeListener.$$$reportNull$$$0(1);
            }
            PerforceConnectionManager.this.updateConnections();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "removed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "added";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager$MyContentRootChangeListener";
            objectArray[2] = "contentRootsChanged";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

