/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.impl.ExpandableComboAction;
import com.intellij.openapi.wm.impl.ToolbarComboButton;
import java.awt.Component;
import java.util.Collection;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.PerforceToolbarWidgetHelper;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0006\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/perforce/actions/PerforceToolbarWidgetAction;", "Lcom/intellij/openapi/wm/impl/ExpandableComboAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createStep", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "", "popupFactory", "Lcom/intellij/openapi/ui/popup/JBPopupFactory;", "widget", "Lcom/intellij/openapi/wm/impl/ToolbarComboButton;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "step", "update", "", "e", "updateCustomComponent", "component", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "Companion", "intellij.vcs.perforce"})
public final class PerforceToolbarWidgetAction
extends ExpandableComboAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> isConnectedKey;
    @NotNull
    private static final Key<String> workspaceKey;
    @NotNull
    private static final Key<Boolean> statusKey;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Nullable
    public JBPopup createPopup(@NotNull AnActionEvent event) {
        Object action;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        AnAction anAction = ActionManager.getInstance().getAction("Perforce.Toolbar");
        ActionGroup actionGroup = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
        if (actionGroup == null) {
            return null;
        }
        ActionGroup toolbarActions = actionGroup;
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAll(toolbarActions);
        PerforceSettings perforceSettings = PerforceSettings.getSettings(project2);
        Collection<P4Connection> allConnections = perforceSettings.getAllConnections();
        if (allConnections.size() > 1) {
            group.addSeparator(PerforceBundle.message("action.Perforce.Toolbar.workspaces.label", new Object[0]));
            for (P4Connection connection : allConnections) {
                String string = connection.getConnectionKey().getClient();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClient(...)");
                String string2 = connection.getWorkingDir();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getWorkingDir(...)");
                action = new PerforceToolbarWidgetHelper.WorkspaceAction(string, string2);
                group.add((AnAction)action);
            }
        }
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        action = event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        ToolbarComboButton widget = action instanceof ToolbarComboButton ? (ToolbarComboButton)action : null;
        Intrinsics.checkNotNull((Object)popupFactory);
        ActionGroup actionGroup2 = (ActionGroup)group;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        ListPopupStep<Object> step = this.createStep(popupFactory, widget, actionGroup2, dataContext);
        return (JBPopup)this.createPopup(project2, popupFactory, step);
    }

    private final ListPopupStep<Object> createStep(JBPopupFactory popupFactory, ToolbarComboButton widget, ActionGroup actionGroup, DataContext context) {
        ListPopupStep listPopupStep = popupFactory.createActionsStep(actionGroup, context, "ProjectWidgetPopup", false, true, null, (Component)widget, false, 0, false);
        Intrinsics.checkNotNullExpressionValue((Object)listPopupStep, (String)"createActionsStep(...)");
        return listPopupStep;
    }

    private final ListPopup createPopup(Project project, JBPopupFactory popupFactory, ListPopupStep<Object> step) {
        Function<ListCellRenderer, ListCellRenderer> renderer = PerforceToolbarWidgetAction::createPopup$lambda$0;
        ListPopup listPopup = popupFactory.createListPopup(project, step, renderer);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        return listPopup;
    }

    public void update(@NotNull AnActionEvent e) {
        CharSequence charSequence;
        String workspace;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || !PerforceManager.getInstance(project).isActive()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        PerforceConnectionManagerI perforceConnectionManagerI = PerforceConnectionManager.getInstance(project);
        Intrinsics.checkNotNull((Object)perforceConnectionManagerI, (String)"null cannot be cast to non-null type org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager");
        PerforceConnectionManager perforceConnectionManager = (PerforceConnectionManager)perforceConnectionManagerI;
        if (!perforceConnectionManager.isInitialized()) {
            perforceConnectionManager.scheduleInitialization();
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        PerforceSettings perforceSettings = PerforceSettings.getSettings(project);
        Collection<P4Connection> allConnections = perforceSettings.getAllConnections();
        Intrinsics.checkNotNull((Object)perforceSettings);
        P4Connection connection = PerforceToolbarWidgetHelper.Companion.getConnection(e, perforceSettings);
        Object object = connection;
        String string = object != null && (object = object.getConnectionKey()) != null ? ((ConnectionKey)object).getClient() : (workspace = null);
        boolean isNoConnections = allConnections.isEmpty() || allConnections.size() == 1 && ((charSequence = (CharSequence)workspace) == null || charSequence.length() == 0) || PerforceConnectionProblemsNotifier.getInstance(project).hasConnectionProblems();
        Presentation $this$update_u24lambda_u241 = e.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u241.setDescription(PerforceToolbarWidgetHelper.Companion.getDescription(workspace, isNoConnections, perforceSettings.ENABLED));
        $this$update_u24lambda_u241.setEnabledAndVisible(true);
        $this$update_u24lambda_u241.setIcon(PerforceToolbarWidgetHelper.Companion.getIcon(perforceSettings, isNoConnections, true));
        $this$update_u24lambda_u241.putClientProperty(workspaceKey, (Object)workspace);
        $this$update_u24lambda_u241.putClientProperty(isConnectedKey, (Object)(!isNoConnections ? 1 : 0));
        $this$update_u24lambda_u241.putClientProperty(statusKey, (Object)perforceSettings.ENABLED);
    }

    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        ToolbarComboButton toolbarComboButton = component instanceof ToolbarComboButton ? (ToolbarComboButton)component : null;
        if (toolbarComboButton == null) {
            return;
        }
        ToolbarComboButton widget = toolbarComboButton;
        Boolean bl = (Boolean)presentation.getClientProperty(isConnectedKey);
        boolean isConnected = bl != null ? bl : false;
        String workspace = (String)presentation.getClientProperty(workspaceKey);
        Boolean bl2 = (Boolean)presentation.getClientProperty(statusKey);
        boolean isOnline = bl2 != null ? bl2 : false;
        String text = PerforceToolbarWidgetHelper.Companion.getText(workspace, !isConnected, isOnline);
        widget.setEnabled(isConnected);
        widget.setText(text);
        widget.setToolTipText(presentation.getDescription());
        widget.setLeftIcons(CollectionsKt.listOfNotNull((Object)presentation.getIcon()));
    }

    private static final ListCellRenderer createPopup$lambda$0(ListCellRenderer base) {
        return base;
    }

    static {
        Key key = Key.create((String)"P4_IS_CONNECTED");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        isConnectedKey = key;
        Key key2 = Key.create((String)"P4_WORKSPACE");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        workspaceKey = key2;
        Key key3 = Key.create((String)"P4_STATUS");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        statusKey = key3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\t\u001a\u001f\u0012\u0016\u0012\u0014 \u0007*\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b0\n\u00a2\u0006\u0002\b\u000b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/perforce/actions/PerforceToolbarWidgetAction$Companion;", "", "<init>", "()V", "isConnectedKey", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "workspaceKey", "", "Lcom/intellij/openapi/util/NlsSafe;", "statusKey", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

