/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EscapedMetaCharacterInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            EscapedMetaCharacterInspection.$$$reportNull$$$0(0);
        }
        return new EscapedMetaCharacterVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection", "buildVisitor"));
    }

    private static class EscapedMetaCharacterVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        EscapedMetaCharacterVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            if (ch.getType() != RegExpChar.Type.CHAR) {
                return;
            }
            String text2 = ch.getUnescapedText();
            if (text2.length() != 2 || text2.charAt(0) != '\\') {
                return;
            }
            char c = text2.charAt(1);
            if ("{}().*+?|$".indexOf(c) < 0) {
                return;
            }
            ASTNode node = ch.getNode().getFirstChildNode();
            if (node != null && node.getElementType() == RegExpTT.REDUNDANT_ESCAPE) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, RegExpBundle.message("inspection.warning.escaped.meta.character.0", Character.valueOf(c)), new LocalQuickFix[]{new EscapedMetaCharacterFix(c)});
        }
    }

    private static class EscapedMetaCharacterFix
    extends PsiUpdateModCommandQuickFix {
        private final char myC;

        EscapedMetaCharacterFix(char c) {
            this.myC = c;
        }

        @Nls
        @NotNull
        public String getName() {
            String string2 = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"[" + this.myC + "]"});
            if (string2 == null) {
                EscapedMetaCharacterFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string2 = RegExpBundle.message("inspection.quick.fix.replace.with.character.inside.class", new Object[0]);
            if (string2 == null) {
                EscapedMetaCharacterFix.$$$reportNull$$$0(1);
            }
            return string2;
        }

        protected void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project2 == null) {
                EscapedMetaCharacterFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                EscapedMetaCharacterFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                EscapedMetaCharacterFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof RegExpChar)) {
                return;
            }
            RegExpReplacementUtil.replaceInContext(element, "[" + this.myC + "]");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection$EscapedMetaCharacterFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection$EscapedMetaCharacterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2, 3, 4 -> new IllegalArgumentException(string2);
            };
        }
    }
}

