/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.util.Uri;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;

public class DatatypeRepertoire {
    private static final int TOKEN_TYPICAL_MAX_LENGTH = 32;
    private static final int BINARY_TYPICAL_MIN_LENGTH = 128;
    private static final String[] typeNames = new String[]{"boolean", "integer", "decimal", "double", "NCName", "NMTOKEN", "time", "date", "dateTime", "duration", "hexBinary", "base64Binary", "anyURI"};
    private final Type[] types = new Type[typeNames.length];
    private int nTypes = 0;

    DatatypeRepertoire(DatatypeLibraryFactory datatypeLibraryFactory) {
        DatatypeLibrary datatypeLibrary = datatypeLibraryFactory.createDatatypeLibrary("http://www.w3.org/2001/XMLSchema-datatypes");
        if (datatypeLibrary == null) {
            return;
        }
        int n = 0;
        while (n < this.types.length) {
            try {
                this.types[this.nTypes] = DatatypeRepertoire.makeType(typeNames[n], datatypeLibrary.createDatatype(typeNames[n]), n);
                ++this.nTypes;
            }
            catch (DatatypeException datatypeException) {
                // empty catch block
            }
            ++n;
        }
    }

    public int size() {
        return this.nTypes;
    }

    Type get(int n) {
        return this.types[n];
    }

    private static Type makeType(String string2, Datatype datatype, int n) {
        if (string2.equals("anyURI")) {
            return new UriType(datatype, string2, n);
        }
        if (string2.equals("boolean")) {
            return new BooleanType(datatype, string2, n);
        }
        if (string2.equals("base64Binary") || string2.equals("hexBinary")) {
            return new BinaryType(datatype, string2, n);
        }
        return new Type(datatype, string2, n);
    }

    public static String getUri() {
        return "http://www.w3.org/2001/XMLSchema-datatypes";
    }

    private static class BooleanType
    extends Type {
        private BooleanType(Datatype datatype, String string2, int n) {
            super(datatype, string2, n);
        }

        public boolean isTypical(String string2) {
            return (string2 = string2.trim()).equals("true") || string2.equals("false");
        }
    }

    private static class UriType
    extends Type {
        private static final String EXCLUDED = "<>\"{}|\\^`";

        private UriType(Datatype datatype, String string2, int n) {
            super(datatype, string2, n);
        }

        public boolean isTypical(String string2) {
            return Uri.isAbsolute(string2) && !UriType.containsEmbeddedWhitespace(string2) && !UriType.containsExcluded(string2);
        }

        private static boolean containsExcluded(String string2) {
            int n = 0;
            while (n < EXCLUDED.length()) {
                if (string2.indexOf(EXCLUDED.charAt(n)) >= 0) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private static boolean containsEmbeddedWhitespace(String string2) {
            int n = 0;
            int n2 = 0;
            int n3 = string2.length();
            while (n2 < n3) {
                switch (string2.charAt(n2)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (n != true) break;
                        n = 2;
                        break;
                    }
                    default: {
                        if (n == 2) {
                            return true;
                        }
                        if (n != 0) break;
                        n = 1;
                    }
                }
                ++n2;
            }
            return false;
        }
    }

    private static class BinaryType
    extends Type {
        private BinaryType(Datatype datatype, String string2, int n) {
            super(datatype, string2, n);
        }

        public boolean isTypical(String string2) {
            return string2.length() > 128;
        }
    }

    public static class Type {
        private final Datatype dt;
        private final String name;
        private final int index;

        private Type(Datatype datatype, String string2, int n) {
            this.dt = datatype;
            this.name = string2;
            this.index = n;
        }

        public boolean matches(String string2) {
            return this.dt.isValid(string2, null);
        }

        public boolean isTypical(String string2) {
            return string2.length() < 32;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

