/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.parse;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFailedException;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.input.parse.SchemaBuilderImpl;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.translate.util.EncodingParam;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.relaxng.translate.util.ParamProcessor;
import java.io.IOException;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ParseInputFormat
implements InputFormat {
    private final boolean commentsNeedTrimming;

    protected ParseInputFormat(boolean bl) {
        this.commentsNeedTrimming = bl;
    }

    public SchemaCollection load(String string2, String[] stringArray, String string3, ErrorHandler errorHandler) throws InputFailedException, InvalidParamsException, IOException, SAXException {
        final InputSource inputSource = new InputSource(string2);
        ParamProcessor paramProcessor = new ParamProcessor();
        paramProcessor.declare("encoding", new EncodingParam(){

            protected void setEncoding(String string2) {
                inputSource.setEncoding(string2);
            }
        });
        paramProcessor.process(stringArray, errorHandler);
        Parseable parseable = this.makeParseable(inputSource, errorHandler);
        try {
            return SchemaBuilderImpl.parse(parseable, string2, errorHandler, new DatatypeLibraryLoader(), this.commentsNeedTrimming);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            throw new InputFailedException();
        }
    }

    protected abstract Parseable makeParseable(InputSource var1, ErrorHandler var2);
}

