/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.hunspell;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.hunspell.HunspellDictionary;
import com.intellij.spellchecker.ui.SpellCheckingNotifier;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0013\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0096\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\r\u0010\r\u001a\u00070\u0006\u00a2\u0006\u0002\b\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spellchecker/hunspell/HunspellDictionaryProvider;", "Lcom/intellij/spellchecker/dictionary/CustomDictionaryProvider;", "<init>", "()V", "UNSUPPORTED_LANGUAGES", "", "", "isHunspellPluginInstalled", "", "get", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "path", "isApplicable", "getDictionaryType", "Lorg/jetbrains/annotations/Nls;", "intellij.spellchecker"})
public final class HunspellDictionaryProvider
implements CustomDictionaryProvider {
    @NotNull
    private final Set<String> UNSUPPORTED_LANGUAGES = SetsKt.setOf((Object)"hu_HU");

    private final boolean isHunspellPluginInstalled() {
        PluginId pluginId = PluginId.getId((String)"hunspell");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        PluginId hunspellId = pluginId;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)hunspellId);
        return PluginManagerCore.isPluginInstalled((PluginId)hunspellId) && ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled();
    }

    @Override
    @Nullable
    public Dictionary get(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            HunspellDictionary dict = new HunspellDictionary(path, null, 2, null);
            if (CollectionsKt.contains((Iterable)this.UNSUPPORTED_LANGUAGES, (Object)dict.language())) {
                if (!this.isHunspellPluginInstalled()) {
                    Object[] objectArray = new Object[]{path};
                    SpellCheckingNotifier.INSTANCE.showWarningNotificationBalloon(SpellCheckerBundle.message("dictionary.unsupported.language.title", new Object[0]), SpellCheckerBundle.message("dictionary.unsupported.language", objectArray));
                }
                return null;
            }
            return dict;
        }
        catch (FileNotFoundException e) {
            Object[] objectArray = new Object[]{path};
            SpellCheckingNotifier.INSTANCE.showWarningNotificationBalloon(SpellCheckerBundle.message("dictionary.not.found.title", new Object[0]), SpellCheckerBundle.message("dictionary.not.found", objectArray));
        }
        catch (ParseException e) {
            Object[] objectArray = new Object[]{path};
            SpellCheckingNotifier.INSTANCE.showWarningNotificationBalloon(SpellCheckerBundle.message("dictionary.unsupported.format.title", new Object[0]), SpellCheckerBundle.message("dictionary.unsupported.format", objectArray));
        }
        return null;
    }

    @Override
    public boolean isApplicable(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return !this.isHunspellPluginInstalled() && HunspellDictionary.Companion.isHunspell(path);
    }

    @Override
    @NotNull
    public String getDictionaryType() {
        return SpellCheckerBundle.message("hunspell.dictionary", new Object[0]);
    }
}

