/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsHelper {
    @NotNull
    protected final Project myProject;

    protected AbstractVcsHelper(@NotNull Project project2) {
        if (project2 == null) {
            AbstractVcsHelper.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    @NotNull
    public static AbstractVcsHelper getInstance(Project project2) {
        AbstractVcsHelper abstractVcsHelper = (AbstractVcsHelper)project2.getService(AbstractVcsHelper.class);
        if (abstractVcsHelper == null) {
            AbstractVcsHelper.$$$reportNull$$$0(1);
        }
        return abstractVcsHelper;
    }

    public abstract void showErrors(List<? extends VcsException> var1, @NotNull @NlsContexts.TabTitle String var2);

    public abstract void showErrors(Map<HotfixData, List<VcsException>> var1, @NotNull @NlsContexts.TabTitle String var2);

    public abstract List<VcsException> runTransactionRunnable(AbstractVcs var1, TransactionRunnable var2, Object var3);

    public void showError(VcsException e, @NlsContexts.TabTitle String tabDisplayName) {
        this.showErrors(Collections.singletonList(e), tabDisplayName);
    }

    public abstract void showAnnotation(FileAnnotation var1, VirtualFile var2, AbstractVcs var3);

    public abstract void showAnnotation(FileAnnotation var1, VirtualFile var2, AbstractVcs var3, int var4);

    public abstract void showChangesListBrowser(@NotNull CommittedChangeList var1, @Nullable @NlsContexts.DialogTitle String var2);

    public abstract void showWhatDiffersBrowser(@NotNull Collection<Change> var1, @Nullable @NlsContexts.DialogTitle String var2);

    public abstract void showCommittedChangesBrowser(@NotNull CommittedChangesProvider var1, @NotNull RepositoryLocation var2, @Nullable @NlsContexts.DialogTitle String var3, @Nullable Component var4);

    public abstract void openCommittedChangesTab(@NotNull CommittedChangesProvider var1, @NotNull RepositoryLocation var2, @NotNull ChangeBrowserSettings var3, int var4, @Nullable @NlsContexts.DialogTitle String var5);

    @NotNull
    public abstract List<VirtualFile> showMergeDialog(List<? extends VirtualFile> var1, MergeProvider var2, @NotNull MergeDialogCustomizer var3);

    @NotNull
    public final List<VirtualFile> showMergeDialog(List<? extends VirtualFile> files, MergeProvider provider) {
        List<VirtualFile> list2 = this.showMergeDialog(files, provider, provider.createDefaultMergeDialogCustomizer());
        if (list2 == null) {
            AbstractVcsHelper.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public final List<VirtualFile> showMergeDialog(List<? extends VirtualFile> files) {
        if (files.isEmpty()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractVcsHelper.$$$reportNull$$$0(3);
            }
            return list2;
        }
        MergeProvider provider = null;
        for (VirtualFile virtualFile : files) {
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance(this.myProject).getVcsFor(virtualFile);
            if (vcs == null || (provider = vcs.getMergeProvider()) == null) continue;
            break;
        }
        if (provider == null) {
            List<VirtualFile> list3 = Collections.emptyList();
            if (list3 == null) {
                AbstractVcsHelper.$$$reportNull$$$0(4);
            }
            return list3;
        }
        return this.showMergeDialog(files, provider);
    }

    public abstract void showFileHistory(@NotNull VcsHistoryProvider var1, @NotNull FilePath var2, @NotNull AbstractVcs var3);

    public abstract void showFileHistory(@NotNull VcsHistoryProvider var1, @Nullable AnnotationProvider var2, @NotNull FilePath var3, @NotNull AbstractVcs var4);

    @Nullable
    public abstract Collection<VirtualFile> selectFilesToProcess(List<? extends VirtualFile> var1, @NlsContexts.DialogTitle String var2, @NlsContexts.DialogMessage @Nullable String var3, @NlsContexts.DialogTitle @Nullable String var4, @NlsContexts.DialogMessage @Nullable String var5, @NotNull VcsShowConfirmationOption var6);

    @Nullable
    public abstract Collection<FilePath> selectFilePathsToProcess(@NotNull List<? extends FilePath> var1, @NlsContexts.DialogTitle String var2, @NlsContexts.DialogMessage @Nullable String var3, @NlsContexts.DialogTitle @Nullable String var4, @NlsContexts.DialogMessage @Nullable String var5, @NotNull VcsShowConfirmationOption var6);

    @Nullable
    public abstract Collection<FilePath> selectFilePathsToProcess(@NotNull List<? extends FilePath> var1, @NlsContexts.DialogTitle String var2, @NlsContexts.DialogMessage @Nullable String var3, @NlsContexts.DialogTitle @Nullable String var4, @NlsContexts.DialogMessage @Nullable String var5, @NotNull VcsShowConfirmationOption var6, @NlsActions.ActionText @Nullable String var7, @NlsActions.ActionText @Nullable String var8);

    public abstract boolean commitChanges(@NotNull Collection<? extends Change> var1, @NotNull LocalChangeList var2, @NotNull @NlsSafe String var3, @Nullable CommitResultHandler var4);

    public abstract void loadAndShowCommittedChangesDetails(@NotNull Project var1, @NotNull VcsRevisionNumber var2, @NotNull VirtualFile var3, @NotNull VcsKey var4, @Nullable RepositoryLocation var5, boolean var6);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/AbstractVcsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/AbstractVcsHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "showMergeDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

