/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.ui.laf.darcula.ui.DarculaSeparatorUI;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.InternalActionsBundle;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorAction;
import com.intellij.internal.inspector.UiInspectorImpl;
import com.intellij.internal.inspector.components.ComponentsNavBarPanel;
import com.intellij.internal.inspector.components.DataContextDialog;
import com.intellij.internal.inspector.components.HierarchyTree;
import com.intellij.internal.inspector.components.InspectorTable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBThinOverlappingScrollBar;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.SeparatorUI;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectorWindow
extends JDialog
implements Disposable {
    private InspectorTable myInspectorTable;
    @NotNull
    private final List<Component> myComponents;
    private List<? extends PropertyBean> myInfo;
    @NotNull
    private final Component myInitialComponent;
    @NotNull
    private final List<HighlightComponent> myHighlightComponents;
    private boolean myIsHighlighted;
    @NotNull
    private final HierarchyTree myHierarchyTree;
    @NotNull
    private final ComponentsNavBarPanel myNavBarPanel;
    @NotNull
    private final Wrapper myWrapperPanel;
    @Nullable
    private final Project myProject;
    private final UiInspectorAction.UiInspector myInspector;

    public InspectorWindow(@Nullable Project project2, @NotNull Component component, UiInspectorAction.UiInspector inspector) throws HeadlessException {
        if (component == null) {
            InspectorWindow.$$$reportNull$$$0(0);
        }
        super(InspectorWindow.findWindow(component));
        this.myComponents = new ArrayList<Component>();
        this.myHighlightComponents = new ArrayList<HighlightComponent>();
        this.myIsHighlighted = true;
        this.myProject = project2;
        this.myInspector = inspector;
        Window window = InspectorWindow.findWindow(component);
        this.setModal(window instanceof JDialog && ((JDialog)window).isModal());
        this.myComponents.add(component);
        this.myInitialComponent = component;
        this.getRootPane().setBorder(JBUI.Borders.empty((int)5));
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.setTitle(component.getClass().getName());
        Dimension size = DimensionService.getInstance().getSize(InspectorWindow.getDimensionServiceKey(), null);
        Point location = DimensionService.getInstance().getLocation(InspectorWindow.getDimensionServiceKey(), null);
        if (size != null) {
            this.setSize(size);
        }
        if (location != null) {
            this.setLocation(location);
        }
        this.myWrapperPanel = new Wrapper();
        this.myInspectorTable = new InspectorTable(component, this.myProject);
        this.myWrapperPanel.setContent((JComponent)((Object)this.myInspectorTable));
        this.myHierarchyTree = new HierarchyTree(component){

            @Override
            public void onComponentsChanged(List<? extends Component> components) {
                InspectorWindow.this.switchComponentsInfo(components);
                InspectorWindow.this.updateHighlighting();
            }

            @Override
            public void onClickInfoChanged(List<? extends PropertyBean> info) {
                InspectorWindow.this.switchClickInfo(info);
                InspectorWindow.this.updateHighlighting();
            }
        };
        JBSplitter splitPane = new JBSplitter(false, "UiInspector.splitter.proportion", 0.5f);
        splitPane.setSecondComponent((JComponent)this.myWrapperPanel);
        splitPane.setFirstComponent((JComponent)new JBScrollPane((Component)this.myHierarchyTree));
        this.add((Component)splitPane, "Center");
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.addAction((AnAction)new ToggleHighlightAction());
        actions.addSeparator();
        actions.add((AnAction)new RefreshAction());
        actions.addSeparator();
        actions.add((AnAction)new ToggleAccessibleAction());
        actions.addSeparator();
        actions.add((AnAction)new ShowDataContextAction());
        actions.addSeparator();
        actions.add((AnAction)new MyNavigateAction());
        actions.addSeparator();
        actions.add((AnAction)new ShowAccessibilityIssuesAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ContextToolbar", (ActionGroup)actions, true);
        toolbar.setTargetComponent((JComponent)this.getRootPane());
        Consumer<Component> selectionHandler = selectedComponent -> {
            TreePath pathToSelect = TreeUtil.visitVisibleRows((JTree)this.myHierarchyTree, path -> {
                Object node = path.getLastPathComponent();
                Component curComponent = ((HierarchyTree.ComponentNode)node).getComponent();
                return curComponent == selectedComponent ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
            });
            if (pathToSelect != null) {
                this.myHierarchyTree.setSelectionPath(pathToSelect);
                this.myHierarchyTree.scrollPathToVisible(pathToSelect);
            }
        };
        this.myNavBarPanel = new ComponentsNavBarPanel(component, selectionHandler);
        JBScrollPane navBarScroll = new JBScrollPane((Component)((Object)this.myNavBarPanel), 21, 30);
        navBarScroll.setHorizontalScrollBar((JScrollBar)new JBThinOverlappingScrollBar(0));
        navBarScroll.setOverlappingScrollBar(true);
        navBarScroll.setBorder(BorderFactory.createEmptyBorder());
        navBarScroll.putClientProperty(JBScrollPane.Flip.class, (Object)JBScrollPane.Flip.VERTICAL);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.add(toolbar.getComponent());
        topPanel.add(new JSeparator(0){

            @Override
            public void updateUI() {
                this.setUI((SeparatorUI)new DarculaSeparatorUI(){

                    protected int getStripeIndent() {
                        return 0;
                    }

                    public Dimension getPreferredSize(JComponent c) {
                        return JBUI.size((int)0, (int)1);
                    }
                });
            }
        });
        topPanel.add((Component)navBarScroll);
        this.add((Component)topPanel, "North");
        TreeUtil.expandAll((JTree)this.myHierarchyTree);
        this.myHierarchyTree.selectPath(component);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InspectorWindow.this.close();
            }
        });
        this.getRootPane().getActionMap().put("CLOSE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectorWindow.this.close();
            }
        });
        this.updateHighlighting();
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CLOSE");
    }

    @Override
    protected JRootPane createRootPane() {
        MyRootPane rp = new MyRootPane();
        rp.setOpaque(true);
        return rp;
    }

    public static String getDimensionServiceKey() {
        return "UiInspectorWindow";
    }

    private static Window findWindow(Component component) {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
        if (dialogWrapper != null) {
            return dialogWrapper.getPeer().getWindow();
        }
        return null;
    }

    private InspectorTable getCurrentTable() {
        return this.myInspectorTable;
    }

    private void switchComponentsInfo(@NotNull List<? extends Component> components) {
        if (components == null) {
            InspectorWindow.$$$reportNull$$$0(1);
        }
        if (components.isEmpty()) {
            return;
        }
        this.myComponents.clear();
        this.myComponents.addAll(components);
        this.myInfo = null;
        Component showingComponent = components.get(0);
        this.setTitle(showingComponent.getClass().getName());
        Disposer.dispose((Disposable)this.myInspectorTable);
        this.myInspectorTable = new InspectorTable(showingComponent, this.myProject);
        this.myWrapperPanel.setContent((JComponent)((Object)this.myInspectorTable));
        this.myNavBarPanel.setSelectedComponent(showingComponent);
    }

    private void switchClickInfo(@NotNull List<? extends PropertyBean> clickInfo) {
        if (clickInfo == null) {
            InspectorWindow.$$$reportNull$$$0(2);
        }
        this.myComponents.clear();
        this.myInfo = clickInfo;
        this.setTitle("Click Info");
        Disposer.dispose((Disposable)this.myInspectorTable);
        this.myInspectorTable = new InspectorTable(clickInfo, this.myProject);
        this.myWrapperPanel.setContent((JComponent)((Object)this.myInspectorTable));
    }

    @Override
    public void dispose() {
        DimensionService.getInstance().setSize(InspectorWindow.getDimensionServiceKey(), this.getSize(), null);
        DimensionService.getInstance().setLocation(InspectorWindow.getDimensionServiceKey(), this.getLocation(), null);
        Disposer.dispose((Disposable)this.myInspectorTable);
        super.dispose();
        Disposer.dispose((Disposable)this);
        DialogWrapper.cleanupRootPane((JRootPane)this.rootPane);
        DialogWrapper.cleanupWindowListeners((Window)this);
    }

    public void close() {
        if (this.myInitialComponent instanceof JComponent) {
            ((JComponent)this.myInitialComponent).putClientProperty(UiInspectorAction.CLICK_INFO, null);
        }
        this.myIsHighlighted = false;
        this.myInfo = null;
        this.myComponents.clear();
        this.updateHighlighting();
        this.setVisible(false);
        Disposer.dispose((Disposable)this);
    }

    public UiInspectorAction.UiInspector getInspector() {
        return this.myInspector;
    }

    private void updateHighlighting() {
        for (HighlightComponent highlightComponent : this.myHighlightComponents) {
            JComponent jComponent = InspectorWindow.getGlassPane(highlightComponent);
            if (jComponent == null) continue;
            jComponent.remove(highlightComponent);
            jComponent.revalidate();
            jComponent.repaint();
        }
        this.myHighlightComponents.clear();
        if (this.myIsHighlighted) {
            for (Component component : this.myComponents) {
                ContainerUtil.addIfNotNull(this.myHighlightComponents, (Object)InspectorWindow.createHighlighter(component, null));
            }
            if (this.myInfo != null) {
                Rectangle bounds = null;
                for (PropertyBean propertyBean : this.myInfo) {
                    if (!"clicked renderer".equals(propertyBean.propertyName)) continue;
                    bounds = (Rectangle)propertyBean.propertyValue;
                    break;
                }
                ContainerUtil.addIfNotNull(this.myHighlightComponents, (Object)InspectorWindow.createHighlighter(this.myInitialComponent, bounds));
            }
        }
    }

    @Nullable
    private static HighlightComponent createHighlighter(@NotNull Component component, @Nullable Rectangle bounds) {
        JComponent glassPane;
        if (component == null) {
            InspectorWindow.$$$reportNull$$$0(3);
        }
        if ((glassPane = InspectorWindow.getGlassPane(component)) == null) {
            return null;
        }
        if (bounds != null) {
            bounds = SwingUtilities.convertRectangle(component, bounds, glassPane);
        } else {
            Point pt = SwingUtilities.convertPoint(component, new Point(0, 0), glassPane);
            bounds = new Rectangle(pt.x, pt.y, component.getWidth(), component.getHeight());
        }
        JBColor color = new JBColor((Color)JBColor.GREEN, (Color)JBColor.RED);
        if (bounds.width == 0 || bounds.height == 0) {
            bounds.width = Math.max(bounds.width, 1);
            bounds.height = Math.max(bounds.height, 1);
            color = JBColor.BLUE;
        }
        JBInsets insets = component instanceof JComponent ? ((JComponent)component).getInsets() : JBInsets.emptyInsets();
        HighlightComponent highlightComponent = new HighlightComponent((Color)color, (Insets)insets);
        highlightComponent.setBounds(bounds);
        glassPane.add(highlightComponent);
        glassPane.revalidate();
        glassPane.repaint();
        return highlightComponent;
    }

    @Nullable
    private static JComponent getGlassPane(@NotNull Component component) {
        JRootPane rootPane;
        if (component == null) {
            InspectorWindow.$$$reportNull$$$0(4);
        }
        return (rootPane = SwingUtilities.getRootPane(component)) == null ? null : (JComponent)rootPane.getGlassPane();
    }

    private String findSelectedClassName() {
        if (this.myHierarchyTree.hasFocus()) {
            Component comp;
            Object obj;
            if (!this.myComponents.isEmpty()) {
                return this.myComponents.get(0).getClass().getName();
            }
            TreePath path = this.myHierarchyTree.getSelectionPath();
            if (path != null && (obj = path.getLastPathComponent()) instanceof HierarchyTree.ComponentNode && (comp = ((HierarchyTree.ComponentNode)obj).getComponent()) != null) {
                return comp.getClass().getName();
            }
        } else if (this.myInspectorTable.getTable().hasFocus()) {
            int row = this.myInspectorTable.getTable().getSelectedRow();
            String value = this.myInspectorTable.getCellTextValue(row, 1);
            String[] parts = value.split("[@,\\[]");
            return parts[0];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickInfo";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "switchComponentsInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "switchClickInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGlassPane";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class ToggleHighlightAction
    extends MyTextAction {
        private ToggleHighlightAction() {
            super(IdeBundle.messagePointer((String)"action.Anonymous.text.highlight", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleHighlightAction.$$$reportNull$$$0(0);
            }
            InspectorWindow.this.myIsHighlighted = !InspectorWindow.this.myIsHighlighted;
            InspectorWindow.this.updateHighlighting();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleHighlightAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(InspectorWindow.this.myInfo != null || !InspectorWindow.this.myComponents.isEmpty());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToggleHighlightAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleHighlightAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleHighlightAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private final class RefreshAction
    extends MyTextAction {
        private RefreshAction() {
            super(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.refresh", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            InspectorWindow.this.getCurrentTable().refresh();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(!InspectorWindow.this.myComponents.isEmpty());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RefreshAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/InspectorWindow$RefreshAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$RefreshAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private final class ToggleAccessibleAction
    extends MyTextAction {
        private boolean isAccessibleEnable;

        private ToggleAccessibleAction() {
            super(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.Accessible", (Object[])new Object[0]));
            this.isAccessibleEnable = false;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleAccessibleAction.$$$reportNull$$$0(0);
            }
            this.switchHierarchy();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleAccessibleAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setText(this.isAccessibleEnable ? InternalActionsBundle.message((String)"action.Anonymous.text.Visible", (Object[])new Object[0]) : InternalActionsBundle.message((String)"action.Anonymous.text.Accessible", (Object[])new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ToggleAccessibleAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private void switchHierarchy() {
            TreePath path = InspectorWindow.this.myHierarchyTree.getLeadSelectionPath();
            if (path == null) {
                return;
            }
            HierarchyTree.ComponentNode node = (HierarchyTree.ComponentNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), HierarchyTree.ComponentNode.class);
            if (node == null) {
                return;
            }
            Component c = node.getComponent();
            if (c == null) {
                return;
            }
            Component selected = (Component)ContainerUtil.getFirstItem(InspectorWindow.this.myComponents);
            this.isAccessibleEnable = !this.isAccessibleEnable;
            InspectorWindow.this.myNavBarPanel.setAccessibleEnabled(this.isAccessibleEnable);
            InspectorWindow.this.myHierarchyTree.resetModel(c, this.isAccessibleEnable);
            TreeUtil.expandAll((JTree)InspectorWindow.this.myHierarchyTree);
            if (selected != null) {
                InspectorWindow.this.myHierarchyTree.selectPath(selected, this.isAccessibleEnable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleAccessibleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleAccessibleAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private final class ShowDataContextAction
    extends MyTextAction {
        private ShowDataContextAction() {
            super(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.DataContext", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TreePath path;
            if (e == null) {
                ShowDataContextAction.$$$reportNull$$$0(0);
            }
            if ((path = InspectorWindow.this.myHierarchyTree.getLeadSelectionPath()) == null) {
                return;
            }
            HierarchyTree.ComponentNode node = (HierarchyTree.ComponentNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), HierarchyTree.ComponentNode.class);
            if (node == null) {
                return;
            }
            JComponent c = (JComponent)UIUtil.getParentOfType(JComponent.class, (Component)node.getComponent());
            if (c == null) {
                return;
            }
            new DataContextDialog(InspectorWindow.this.myProject, c).show();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/inspector/components/InspectorWindow$ShowDataContextAction", "actionPerformed"));
        }
    }

    private static final class MyNavigateAction
    extends BaseNavigateToSourceAction
    implements CustomComponentAction {
        private MyNavigateAction() {
            super(true);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(ActionsBundle.messagePointer((String)"action.EditSource.text", (Object[])new Object[0]));
            presentation.setDescription(InternalActionsBundle.messagePointer((String)"action.Anonymous.description.open.definition", (Object[])new Object[0]));
            presentation.putClientProperty(ActionButtonWithText.SHORTCUT_SHOULD_SHOWN, (Object)true);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                MyNavigateAction.$$$reportNull$$$0(0);
            }
            if (place == null) {
                MyNavigateAction.$$$reportNull$$$0(1);
            }
            return new ActionButtonWithText((AnAction)this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

                @Nullable
                protected String getShortcutText() {
                    KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut("EditSource");
                    if (shortcut != null) {
                        return KeymapUtil.getShortcutText((Shortcut)shortcut);
                    }
                    return null;
                }
            };
        }

        public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
            if (component == null) {
                MyNavigateAction.$$$reportNull$$$0(2);
            }
            if (presentation == null) {
                MyNavigateAction.$$$reportNull$$$0(3);
            }
            component.setEnabled(presentation.isEnabled());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$MyNavigateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCustomComponent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCustomComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ShowAccessibilityIssuesAction
    extends MyTextAction {
        private final boolean isAccessibilityAuditEnabled;
        private boolean showAccessibilityIssues;

        private ShowAccessibilityIssuesAction() {
            super(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.ShowAccessibilityIssues", (Object[])new Object[0]));
            this.isAccessibilityAuditEnabled = Registry.is((String)"ui.inspector.accessibility.audit", (boolean)false);
            this.showAccessibilityIssues = false;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAccessibilityIssuesAction.$$$reportNull$$$0(0);
            }
            this.showAccessibilityIssues = !this.showAccessibilityIssues;
            this.updateTreeWithAccessibilityStatus();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAccessibilityIssuesAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(this.isAccessibilityAuditEnabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowAccessibilityIssuesAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private void updateTreeWithAccessibilityStatus() {
            TreeUtil.visitVisibleRows((JTree)InspectorWindow.this.myHierarchyTree, path -> {
                Object node = path.getLastPathComponent();
                if (node instanceof HierarchyTree.ComponentNode) {
                    HierarchyTree.ComponentNode componentNode = (HierarchyTree.ComponentNode)node;
                    if (this.showAccessibilityIssues) {
                        Component c = componentNode.getComponent();
                        if (c instanceof Accessible) {
                            Accessible a = (Accessible)((Object)c);
                            AccessibleContext ac = a.getAccessibleContext();
                            componentNode.runAccessibilityTests(ac);
                        }
                    } else {
                        componentNode.clearAccessibilityTestsResult();
                    }
                }
                return TreeVisitor.Action.CONTINUE;
            });
            InspectorWindow.this.myHierarchyTree.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/InspectorWindow$ShowAccessibilityIssuesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$ShowAccessibilityIssuesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private class MyRootPane
    extends JRootPane
    implements UiDataProvider {
        private MyRootPane() {
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            String selectedClassName;
            if (sink == null) {
                MyRootPane.$$$reportNull$$$0(0);
            }
            if ((selectedClassName = InspectorWindow.this.findSelectedClassName()) == null) {
                return;
            }
            sink.set(CommonDataKeys.NAVIGATABLE, (Object)new Navigatable(){

                public void navigate(boolean requestFocus) {
                    UiInspectorImpl.openClassByFqn(InspectorWindow.this.myProject, selectedClassName, requestFocus);
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/internal/inspector/components/InspectorWindow$MyRootPane", "uiDataSnapshot"));
        }
    }

    private static final class HighlightComponent
    extends JComponent {
        @NotNull
        private final Color myColor;
        @NotNull
        private final Insets myInsets;

        private HighlightComponent(@NotNull Color c, @NotNull Insets insets) {
            if (c == null) {
                HighlightComponent.$$$reportNull$$$0(0);
            }
            if (insets == null) {
                HighlightComponent.$$$reportNull$$$0(1);
            }
            this.myColor = c;
            this.myInsets = insets;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int i;
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            Composite old = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
            Rectangle r = this.getBounds();
            RectanglePainter.paint((Graphics2D)g2d, (int)0, (int)0, (int)r.width, (int)r.height, (int)0, (Paint)this.myColor, null);
            ((Graphics2D)g).setPaint(this.myColor.darker());
            for (i = 0; i < this.myInsets.left; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)i, (double)this.myInsets.top, (double)i, (double)(r.height - this.myInsets.bottom - 1));
            }
            for (i = 0; i < this.myInsets.right; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)(r.width - i - 1), (double)this.myInsets.top, (double)(r.width - i - 1), (double)(r.height - this.myInsets.bottom - 1));
            }
            for (i = 0; i < this.myInsets.top; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)i, (double)r.width, (double)i);
            }
            for (i = 0; i < this.myInsets.bottom; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)(r.height - i - 1), (double)r.width, (double)(r.height - i - 1));
            }
            g2d.setComposite(old);
            g2d.setColor(oldColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "insets";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/inspector/components/InspectorWindow$HighlightComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MyTextAction
    extends IconWithTextAction
    implements DumbAware {
        private MyTextAction(Supplier<String> text2) {
            super(text2);
        }
    }
}

