/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;

public final class JavaFxColorRgbInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JavaFxColorRgbInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JavaFxColorRgbInspection.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JavaFxColorRgbInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new XmlElementVisitor(){

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                PsiClass psiClass;
                if (attribute == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitXmlAttribute(attribute);
                String attributeValue = attribute.getValue();
                if (attributeValue == null) {
                    return;
                }
                XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                if (descriptor instanceof JavaFxPropertyAttributeDescriptor && (psiClass = ((JavaFxPropertyAttributeDescriptor)descriptor).getPsiClass()) != null && "javafx.scene.paint.Color".equals(psiClass.getQualifiedName())) {
                    XmlAttributeValue valueElement = attribute.getValueElement();
                    XmlAttributeValue location = valueElement != null ? valueElement : attribute;
                    this.validateColorComponent(psiClass, attribute.getName(), attributeValue, (PsiElement)location);
                }
            }

            public void visitXmlTag(@NotNull XmlTag tag) {
                PsiClass psiClass;
                if (tag == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitXmlTag(tag);
                if (tag.getSubTags().length != 0) {
                    return;
                }
                XmlElementDescriptor descriptor = tag.getDescriptor();
                if (descriptor instanceof JavaFxPropertyTagDescriptor && (psiClass = ((JavaFxPropertyTagDescriptor)descriptor).getPsiClass()) != null && "javafx.scene.paint.Color".equals(psiClass.getQualifiedName())) {
                    XmlTagValue valueElement = tag.getValue();
                    XmlText[] textElements = valueElement.getTextElements();
                    XmlTag location = textElements.length == 1 ? textElements[0] : tag;
                    this.validateColorComponent(psiClass, tag.getName(), valueElement.getTrimmedText(), (PsiElement)location);
                }
            }

            private void validateColorComponent(@NotNull PsiClass psiClass, @NotNull String propertyName, @NotNull String propertyValue, @NotNull PsiElement location) {
                PsiMember declaration;
                String boxedQName;
                if (psiClass == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (propertyName == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (propertyValue == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (location == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ("java.lang.Float".equals(boxedQName = JavaFxPsiUtil.getBoxedPropertyType(psiClass, declaration = JavaFxPsiUtil.getWritableProperties(psiClass).get(propertyName))) || "java.lang.Double".equals(boxedQName)) {
                    try {
                        double value = Double.parseDouble(propertyValue);
                        if (value < 0.0 || value > 1.0) {
                            holder.registerProblem(location, JavaFXBundle.message("inspection.javafx.color.component.out.of.range.problem", new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiClass";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "propertyName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "propertyValue";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "location";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttribute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlTag";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "validateColorComponent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

