/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.LinkDescriptor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.graph.utils.GraphUtilKt;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.ui.table.links.CommitLinksResolveListener;
import com.intellij.vcs.log.ui.table.links.NavigateToCommit;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0001\u0018\u0000 -2\u00020\u0001:\u0002-.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0011J5\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001dJ5\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b!J2\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u001bH\u0002J<\u0010#\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0014\u0010+\u001a\u00020\u001b*\u00020(2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010,\u001a\u00020\b*\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgit4idea/log/GitLinkToCommitResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "prefixesCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/vcs/log/CommitId;", "", "Lgit4idea/log/GitLinkToCommitResolver$PrefixTarget;", "resolveQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "updateQueue", "getLinks", "Lcom/intellij/openapi/vcs/LinkDescriptor;", "commitId", "getLinks$intellij_vcs_git", "submitResolveLinks", "", "logId", "", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "startRow", "", "endRow", "submitResolveLinks$intellij_vcs_git", "resolveLinks", "commitMessage", "processingCount", "resolveLinks$intellij_vcs_git", "resolveHash", "iterateCommits", "startFromCommitIndex", "commitsCount", "consumer", "Lkotlin/Function1;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "", "getCachedOrEmpty", "getCommitIndex", "getCommitId", "Companion", "PrefixTarget", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitLinkToCommitResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLinkToCommitResolver.kt\ngit4idea/log/GitLinkToCommitResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n1557#2:207\n1628#2,3:208\n*S KotlinDebug\n*F\n+ 1 GitLinkToCommitResolver.kt\ngit4idea/log/GitLinkToCommitResolver\n*L\n62#1:207\n62#1:208,3\n*E\n"})
public final class GitLinkToCommitResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Cache<CommitId, List<PrefixTarget>> prefixesCache;
    @NotNull
    private final MergingUpdateQueue resolveQueue;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    private static final int PREFIX_DELIMITER_LENGTH = 1;
    @NotNull
    private static final List<String> prefixes;
    @NotNull
    private static final Regex regex;
    private static final long CACHE_MAX_SIZE = 1000L;

    public GitLinkToCommitResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Cache cache = Caffeine.newBuilder().maximumSize(1000L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.prefixesCache = cache;
        this.resolveQueue = new MergingUpdateQueue("resolve links queue", 100, true, null, (Disposable)this.project, null, false);
        this.updateQueue = new MergingUpdateQueue("after resolve links ui update queue", 100, true, null, (Disposable)this.project, null, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LinkDescriptor> getLinks$intellij_vcs_git(@NotNull CommitId commitId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commitId, (String)"commitId");
        Iterable $this$map$iv = this.getCachedOrEmpty(commitId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PrefixTarget prefixTarget = (PrefixTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new NavigateToCommit(it.getRange(), it.getTargetHash()));
        }
        return (List)destination$iv$iv;
    }

    public final void submitResolveLinks$intellij_vcs_git(@NotNull String logId, @NotNull VcsLogData logData, @NotNull VisiblePack visiblePack, int startRow, int endRow) {
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"visiblePack");
        if (!(visiblePack.getVisibleGraph() instanceof VisibleGraphImpl)) {
            return;
        }
        int startFrom = Math.max(0, startRow);
        int end = Math.max(0, endRow);
        IntRange rowRange = new IntRange(startFrom, end);
        int processingCount = Math.min(Math.abs(Registry.Companion.intValue("vcs.log.render.commit.links.process.chunk")), CollectionsKt.count((Iterable)((Iterable)rowRange)));
        if (processingCount < 2) {
            return;
        }
        VisibleGraph visibleGraph = visiblePack.getVisibleGraph();
        Intrinsics.checkNotNullExpressionValue((Object)visibleGraph, (String)"getVisibleGraph(...)");
        VisibleGraph visibleGraph2 = visibleGraph;
        this.resolveQueue.queue(Update.Companion.create((Object)(logId + startFrom), () -> GitLinkToCommitResolver.submitResolveLinks$lambda$2(rowRange, visibleGraph2, logData, this, visiblePack, processingCount, logId)));
    }

    @RequiresBackgroundThread
    public final void resolveLinks$intellij_vcs_git(@NotNull VcsLogData logData, @NotNull VisiblePack visiblePack, @NotNull CommitId commitId, @NotNull String commitMessage, int processingCount) {
        String rest;
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"visiblePack");
        Intrinsics.checkNotNullParameter((Object)commitId, (String)"commitId");
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        if (!(visiblePack.getVisibleGraph() instanceof VisibleGraphImpl)) {
            return;
        }
        List<PrefixTarget> cachedPrefixes = this.getCachedOrEmpty(commitId);
        if (!((Collection)cachedPrefixes).isEmpty()) {
            return;
        }
        MatchResult matchResult = regex.matchEntire((CharSequence)commitMessage);
        if (matchResult == null) {
            return;
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = match.getGroups().get(1);
        String string = matchGroup != null ? matchGroup.getValue() : null;
        if (string == null) {
            string = "";
        }
        String prefix = string;
        MatchGroup matchGroup2 = match.getGroups().get(2);
        String string2 = matchGroup2 != null ? matchGroup2.getValue() : null;
        if (string2 == null) {
            string2 = rest = "";
        }
        if (StringsKt.isBlank((CharSequence)prefix) && StringsKt.isBlank((CharSequence)rest)) {
            return;
        }
        int prefixOffset = 0;
        List existingPrefixes = CollectionsKt.toMutableList((Collection)cachedPrefixes);
        while (!StringsKt.isBlank((CharSequence)prefix) && !StringsKt.isBlank((CharSequence)rest)) {
            if (!StringsKt.isBlank((CharSequence)prefix)) {
                Intrinsics.checkNotNullExpressionValue((Object)TextRange.from((int)prefixOffset, (int)prefix.length()), (String)"from(...)");
                String targetHash = this.resolveHash(logData, visiblePack, commitId, rest, processingCount);
                if (targetHash != null) {
                    TextRange prefixRange;
                    existingPrefixes.add(new PrefixTarget(prefixRange, targetHash));
                }
                prefixOffset += prefix.length() + 1;
            }
            if (regex.matchEntire((CharSequence)rest) == null) break;
            MatchGroup matchGroup3 = match.getGroups().get(1);
            String string3 = matchGroup3 != null ? matchGroup3.getValue() : null;
            if (string3 == null) {
                string3 = "";
            }
            prefix = string3;
            MatchGroup matchGroup4 = match.getGroups().get(2);
            String string4 = matchGroup4 != null ? matchGroup4.getValue() : null;
            if (string4 == null) {
                string4 = "";
            }
            rest = string4;
        }
        if (!((Collection)existingPrefixes).isEmpty()) {
            this.prefixesCache.put((Object)commitId, (Object)existingPrefixes);
        }
    }

    private final String resolveHash(VcsLogData logData, VisiblePack visiblePack, CommitId commitId, String commitMessage, int processingCount) {
        int sourceCommitId = logData.getCommitIndex(commitId.getHash(), commitId.getRoot());
        VisibleGraph visibleGraph = visiblePack.getVisibleGraph();
        Intrinsics.checkNotNull((Object)visibleGraph, (String)"null cannot be cast to non-null type com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl<@[FlexibleNullability] kotlin.Int?>");
        VisibleGraphImpl visibleGraph2 = (VisibleGraphImpl)visibleGraph;
        Integer n = visibleGraph2.getVisibleRowIndex((Object)sourceCommitId);
        if (n == null) {
            return null;
        }
        int sourceCommitNodeIndex = n;
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph((LinearGraph)visibleGraph2.getLinearGraph());
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        LiteLinearGraph liteLinearGraph2 = liteLinearGraph;
        Ref.ObjectRef foundData = new Ref.ObjectRef();
        this.iterateCommits(logData, visiblePack, sourceCommitNodeIndex, processingCount, (Function1<? super VcsCommitMetadata, Boolean>)((Function1)arg_0 -> GitLinkToCommitResolver.resolveHash$lambda$3(visibleGraph2, this, logData, commitMessage, liteLinearGraph2, sourceCommitNodeIndex, foundData, arg_0)));
        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)foundData.element;
        return vcsCommitMetadata != null && (vcsCommitMetadata = (Hash)vcsCommitMetadata.getId()) != null ? vcsCommitMetadata.toString() : null;
    }

    private final void iterateCommits(VcsLogData logData, VisiblePack visiblePack, int startFromCommitIndex, int commitsCount, Function1<? super VcsCommitMetadata, Boolean> consumer) {
        VisibleGraph visibleGraph = visiblePack.getVisibleGraph();
        Intrinsics.checkNotNull((Object)visibleGraph, (String)"null cannot be cast to non-null type com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl<@[FlexibleNullability] kotlin.Int?>");
        VisibleGraphImpl visibleGraph2 = (VisibleGraphImpl)visibleGraph;
        LinearGraph linearGraph = visibleGraph2.getLinearGraph();
        int walkDepth = Math.min(commitsCount, visibleGraph2.getVisibleCommitCount());
        Ref.IntRef visitedNode = new Ref.IntRef();
        new DfsWalk((Collection)CollectionsKt.listOf((Object)startFromCommitIndex), linearGraph).walk(true, arg_0 -> GitLinkToCommitResolver.iterateCommits$lambda$4(visibleGraph2, logData, visitedNode, walkDepth, consumer, arg_0));
    }

    private final List<PrefixTarget> getCachedOrEmpty(CommitId commitId) {
        List list = (List)this.prefixesCache.getIfPresent((Object)commitId);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final int getCommitIndex(VcsCommitMetadata $this$getCommitIndex, VcsLogData logData) {
        return logData.getCommitIndex((Hash)$this$getCommitIndex.getId(), $this$getCommitIndex.getRoot());
    }

    private final CommitId getCommitId(VcsCommitMetadata $this$getCommitId) {
        return new CommitId((Hash)$this$getCommitId.getId(), $this$getCommitId.getRoot());
    }

    private static final void submitResolveLinks$lambda$2$lambda$1(GitLinkToCommitResolver this$0, String $logId) {
        ((CommitLinksResolveListener)this$0.project.getMessageBus().syncPublisher(CommitLinksResolveListener.TOPIC)).onLinksResolved($logId);
    }

    private static final void submitResolveLinks$lambda$2(IntRange $rowRange, VisibleGraph $visibleGraph, VcsLogData $logData, GitLinkToCommitResolver this$0, VisiblePack $visiblePack, int $processingCount, String $logId) {
        int n;
        int i = $rowRange.getFirst();
        if (i <= (n = $rowRange.getLast())) {
            while (true) {
                Object object = $visibleGraph.getRowInfo(i).getCommit();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCommit(...)");
                int commitId = ((Number)object).intValue();
                if ((VcsCommitMetadata)$logData.getCommitMetadataCache().getCachedData(commitId) != null) {
                    VcsCommitMetadata commit;
                    CommitId commitId2 = this$0.getCommitId(commit);
                    String string = commit.getSubject();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubject(...)");
                    this$0.resolveLinks$intellij_vcs_git($logData, $visiblePack, commitId2, string, $processingCount);
                }
                if (i == n) break;
                ++i;
            }
        }
        this$0.updateQueue.queue(Update.Companion.create((Object)$logId, () -> GitLinkToCommitResolver.submitResolveLinks$lambda$2$lambda$1(this$0, $logId)));
    }

    private static final boolean resolveHash$lambda$3(VisibleGraphImpl $visibleGraph, GitLinkToCommitResolver this$0, VcsLogData $logData, String $commitMessage, LiteLinearGraph $liteLinearGraph, int $sourceCommitNodeIndex, Ref.ObjectRef $foundData, VcsCommitMetadata currentData) {
        Intrinsics.checkNotNullParameter((Object)currentData, (String)"currentData");
        Integer currentNodeId = $visibleGraph.getVisibleRowIndex((Object)this$0.getCommitIndex(currentData, $logData));
        if (currentNodeId != null && Intrinsics.areEqual((Object)currentData.getSubject(), (Object)$commitMessage) && GraphUtilKt.isAncestor((LiteLinearGraph)$liteLinearGraph, (int)currentNodeId, (int)$sourceCommitNodeIndex)) {
            $foundData.element = currentData;
        }
        return $foundData.element != null;
    }

    private static final boolean iterateCommits$lambda$4(VisibleGraphImpl $visibleGraph, VcsLogData $logData, Ref.IntRef $visitedNode, int $walkDepth, Function1 $consumer, int currentNodeId) {
        Object object = $visibleGraph.getRowInfo(currentNodeId).getCommit();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCommit(...)");
        int currentCommitIndex = ((Number)object).intValue();
        VcsCommitMetadata currentCommitData = (VcsCommitMetadata)$logData.getCommitMetadataCache().getCachedData(currentCommitIndex);
        boolean consumed = false;
        int n = $visitedNode.element;
        $visitedNode.element = n + 1;
        if ($visitedNode.element > $walkDepth) {
            return false;
        }
        if (currentCommitData != null) {
            if (currentCommitData.getParents().size() > 1) {
                return false;
            }
            consumed = (Boolean)$consumer.invoke((Object)currentCommitData);
        }
        return !consumed;
    }

    static {
        Object[] objectArray = new String[]{"fixup!", "squash!", "amend!"};
        prefixes = CollectionsKt.listOf((Object[])objectArray);
        regex = new Regex("^(" + CollectionsKt.joinToString$default((Iterable)prefixes, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ") (.*)$");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit4idea/log/GitLinkToCommitResolver$Companion;", "", "<init>", "()V", "PREFIX_DELIMITER_LENGTH", "", "prefixes", "", "", "regex", "Lkotlin/text/Regex;", "CACHE_MAX_SIZE", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lgit4idea/log/GitLinkToCommitResolver$PrefixTarget;", "", "range", "Lcom/intellij/openapi/util/TextRange;", "targetHash", "", "<init>", "(Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getTargetHash", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class PrefixTarget {
        @NotNull
        private final TextRange range;
        @NotNull
        private final String targetHash;

        public PrefixTarget(@NotNull TextRange range, @NotNull String targetHash) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)targetHash, (String)"targetHash");
            this.range = range;
            this.targetHash = targetHash;
        }

        @NotNull
        public final TextRange getRange() {
            return this.range;
        }

        @NotNull
        public final String getTargetHash() {
            return this.targetHash;
        }

        @NotNull
        public final TextRange component1() {
            return this.range;
        }

        @NotNull
        public final String component2() {
            return this.targetHash;
        }

        @NotNull
        public final PrefixTarget copy(@NotNull TextRange range, @NotNull String targetHash) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)targetHash, (String)"targetHash");
            return new PrefixTarget(range, targetHash);
        }

        public static /* synthetic */ PrefixTarget copy$default(PrefixTarget prefixTarget, TextRange textRange, String string, int n, Object object) {
            if ((n & 1) != 0) {
                textRange = prefixTarget.range;
            }
            if ((n & 2) != 0) {
                string = prefixTarget.targetHash;
            }
            return prefixTarget.copy(textRange, string);
        }

        @NotNull
        public String toString() {
            return "PrefixTarget(range=" + this.range + ", targetHash=" + this.targetHash + ")";
        }

        public int hashCode() {
            int result2 = this.range.hashCode();
            result2 = result2 * 31 + this.targetHash.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PrefixTarget)) {
                return false;
            }
            PrefixTarget prefixTarget = (PrefixTarget)other;
            if (!Intrinsics.areEqual((Object)this.range, (Object)prefixTarget.range)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetHash, (Object)prefixTarget.targetHash);
        }
    }
}

