/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.ModalityUiUtil;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.NotificationErrorNotifier;
import git4idea.i18n.GitBundle;
import java.nio.file.NoSuchFileException;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitExecutableProblemsNotifier {
    @NotNull
    private final Project myProject;

    public static GitExecutableProblemsNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(0);
        }
        return (GitExecutableProblemsNotifier)project.getService(GitExecutableProblemsNotifier.class);
    }

    public GitExecutableProblemsNotifier(@NotNull Project project) {
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(1);
        }
        this.myProject = project;
    }

    public void notifyExecutionError(@NotNull Throwable exception) {
        if (exception == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(2);
        }
        GitExecutableProblemHandler problemHandler = GitExecutableProblemHandlersKt.findGitExecutableProblemHandler(this.myProject);
        NotificationErrorNotifier errorNotifier = new NotificationErrorNotifier(this.myProject);
        problemHandler.showError(exception, errorNotifier);
    }

    static void notify(@NotNull Project project, @NotNull BadGitExecutableNotification notification) {
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(3);
        }
        if (notification == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(4);
        }
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            if (GitExecutableProblemsNotifier.ensureSingularOfType(project, ((Object)((Object)notification)).getClass())) {
                notification.notify(project);
            }
        });
    }

    private static boolean ensureSingularOfType(@NotNull Project project, @NotNull Class<? extends BadGitExecutableNotification> notificationType) {
        BadGitExecutableNotification[] currentNotifications;
        int notificationsCount;
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(5);
        }
        if (notificationType == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(6);
        }
        if ((notificationsCount = (currentNotifications = (BadGitExecutableNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(BadGitExecutableNotification.class, project)).length) <= 0) {
            return true;
        }
        for (int i = 0; i < notificationsCount - 1; ++i) {
            currentNotifications[i].expire();
        }
        BadGitExecutableNotification lastNotification = currentNotifications[notificationsCount - 1];
        if (((Object)((Object)lastNotification)).getClass() != notificationType) {
            lastNotification.expire();
            return true;
        }
        return false;
    }

    public void expireNotifications() {
        for (BadGitExecutableNotification notification : (BadGitExecutableNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(BadGitExecutableNotification.class, this.myProject)) {
            notification.expire();
        }
    }

    @Nls
    @NotNull
    public static String getPrettyErrorMessage(@NotNull Throwable exception) {
        if (exception == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(7);
        }
        String errorMessage = null;
        if (exception instanceof GitVersionIdentificationException && exception.getCause() != null) {
            Throwable cause = exception.getCause();
            errorMessage = cause instanceof NoSuchFileException ? GitBundle.message("git.executable.error.file.not.found", cause.getMessage()) : cause.getMessage();
        }
        if (errorMessage == null) {
            if (exception.getMessage() != null) {
                String string = exception.getMessage();
                if (string == null) {
                    GitExecutableProblemsNotifier.$$$reportNull$$$0(8);
                }
                return string;
            }
            String string = VcsBundle.message((String)"exception.text.unknown.error", (Object[])new Object[0]);
            if (string == null) {
                GitExecutableProblemsNotifier.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = errorMessage;
        if (string == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableProblemsNotifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableProblemsNotifier";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrettyErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notifyExecutionError";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureSingularOfType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPrettyErrorMessage";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    static class BadGitExecutableNotification
    extends Notification {
        BadGitExecutableNotification(@NotNull String groupDisplayId, @Nullable @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type) {
            if (groupDisplayId == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(0);
            }
            if (content == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(1);
            }
            if (type == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(2);
            }
            super(groupDisplayId, Objects.requireNonNullElse(title, ""), content, type);
            this.setDisplayId("git.bad.executable");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupDisplayId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/GitExecutableProblemsNotifier$BadGitExecutableNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

