/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JTable;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.data.TableCell;
import org.assertj.swing.dependency.jsr305.Nonnull;

public final class JTableCellPreconditions {
    @RunsInCurrentThread
    public static void validateCellIsEditable(@Nonnull JTable table, int row, int column) {
        if (!table.isCellEditable(row, column)) {
            String msg = String.format("Expecting cell [%d, %d] to be editable", row, column);
            throw new IllegalStateException(msg);
        }
    }

    @RunsInCurrentThread
    public static void checkCellIndicesInBounds(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull(cell);
        JTableCellPreconditions.checkCellIndicesInBounds(table, cell.row, cell.column);
    }

    @RunsInCurrentThread
    public static void checkCellIndicesInBounds(@Nonnull JTable table, int row, int column) {
        if (table.getRowCount() == 0) {
            throw new IndexOutOfBoundsException("Table does not contain any rows");
        }
        JTableCellPreconditions.checkRowInBounds(table, row);
        JTableCellPreconditions.checkColumnInBounds(table, column);
    }

    @RunsInCurrentThread
    public static void checkRowInBounds(@Nonnull JTable table, int row) {
        JTableCellPreconditions.checkIndexInBounds(row, table.getRowCount(), "row");
    }

    @RunsInCurrentThread
    public static void checkColumnInBounds(@Nonnull JTable table, int column) {
        JTableCellPreconditions.checkIndexInBounds(column, table.getColumnCount(), "column");
    }

    @RunsInCurrentThread
    private static void checkIndexInBounds(int index, int itemCount, @Nonnull String indexName) {
        if (index >= 0 && index < itemCount) {
            return;
        }
        String msg = String.format("%s <%d> should be between <0> and <%d>", indexName, index, itemCount - 1);
        throw new IndexOutOfBoundsException(msg);
    }

    private JTableCellPreconditions() {
    }
}

