/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect.bf;

import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.internal.impl.collect.DataPool;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.internal.impl.collect.PremanagedDependency;
import org.eclipse.aether.internal.impl.collect.bf.DependencyProcessingContext;
import org.eclipse.aether.internal.impl.collect.bf.DependencyResolutionSkipper;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.concurrency.ExecutorUtils;
import org.eclipse.aether.version.Version;

@Singleton
@Named(value="bf")
public class BfDependencyCollector
extends DependencyCollectorDelegate
implements Service {
    public static final String NAME = "bf";
    static final String CONFIG_PROP_SKIPPER = "aether.dependencyCollector.bf.skipper";
    static final boolean CONFIG_PROP_SKIPPER_DEFAULT = true;
    static final String CONFIG_PROP_THREADS = "aether.dependencyCollector.bf.threads";

    @Deprecated
    public BfDependencyCollector() {
    }

    @Inject
    public BfDependencyCollector(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        super(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver);
    }

    @Override
    protected void doCollectDependencies(RepositorySystemSession session, RequestTrace trace, DataPool pool, DefaultDependencyCollectionContext context, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyNode node, List<RemoteRepository> repositories, List<Dependency> dependencies, List<Dependency> managedDependencies, DependencyCollectorDelegate.Results results) {
        boolean useSkip = ConfigUtils.getBoolean(session, true, CONFIG_PROP_SKIPPER);
        int nThreads = ExecutorUtils.threadCount(session, 5, CONFIG_PROP_THREADS, "maven.artifact.threads");
        this.logger.debug("Using thread pool with {} threads to resolve descriptors.", (Object)nThreads);
        if (useSkip) {
            this.logger.debug("Collector skip mode enabled");
        }
        try (DependencyResolutionSkipper skipper = useSkip ? DependencyResolutionSkipper.defaultSkipper() : DependencyResolutionSkipper.neverSkipper();
             ParallelDescriptorResolver parallelDescriptorResolver = new ParallelDescriptorResolver(nThreads);){
            Args args2 = new Args(session, pool, context, versionContext, request, skipper, parallelDescriptorResolver);
            DependencySelector rootDepSelector = session.getDependencySelector() != null ? session.getDependencySelector().deriveChildSelector(context) : null;
            DependencyManager rootDepManager = session.getDependencyManager() != null ? session.getDependencyManager().deriveChildManager(context) : null;
            DependencyTraverser rootDepTraverser = session.getDependencyTraverser() != null ? session.getDependencyTraverser().deriveChildTraverser(context) : null;
            VersionFilter rootVerFilter = session.getVersionFilter() != null ? session.getVersionFilter().deriveChildFilter(context) : null;
            List<DependencyNode> parents2 = Collections.singletonList(node);
            for (Dependency dependency : dependencies) {
                RequestTrace childTrace = this.collectStepTrace(trace, args2.request.getRequestContext(), parents2, dependency);
                DependencyProcessingContext processingContext = new DependencyProcessingContext(rootDepSelector, rootDepManager, rootDepTraverser, rootVerFilter, childTrace, repositories, managedDependencies, parents2, dependency, PremanagedDependency.create(rootDepManager, dependency, false, args2.premanagedState));
                if (this.filter(processingContext)) continue;
                processingContext.withDependency(processingContext.premanagedDependency.getManagedDependency());
                this.resolveArtifactDescriptorAsync(args2, processingContext, results);
                args2.dependencyProcessingQueue.add(processingContext);
            }
            while (!args2.dependencyProcessingQueue.isEmpty()) {
                this.processDependency(args2, results, args2.dependencyProcessingQueue.remove(), Collections.emptyList(), false);
            }
        }
    }

    private void processDependency(Args args2, DependencyCollectorDelegate.Results results, DependencyProcessingContext context, List<Artifact> relocations, boolean disableVersionManagement) {
        VersionRangeResult rangeResult;
        DescriptorResolutionResult resolutionResult;
        Dependency dependency = context.dependency;
        PremanagedDependency preManaged = context.premanagedDependency;
        boolean noDescriptor = BfDependencyCollector.isLackingDescriptor(dependency.getArtifact());
        boolean traverse = !noDescriptor && (context.depTraverser == null || context.depTraverser.traverseDependency(dependency));
        Future<DescriptorResolutionResult> resolutionResultFuture = args2.resolver.find(dependency.getArtifact());
        try {
            resolutionResult = resolutionResultFuture.get();
            rangeResult = resolutionResult.rangeResult;
        }
        catch (Exception e) {
            results.addException(dependency, e, context.parents);
            return;
        }
        Set<Version> versions = resolutionResult.descriptors.keySet();
        for (Version version : versions) {
            Artifact originalArtifact = dependency.getArtifact().setVersion(version.toString());
            Dependency d = dependency.setArtifact(originalArtifact);
            ArtifactDescriptorResult descriptorResult = resolutionResult.descriptors.get(version);
            if (descriptorResult != null) {
                DefaultDependencyNode child;
                int cycleEntry = DefaultDependencyCycle.find(context.parents, (d = d.setArtifact(descriptorResult.getArtifact())).getArtifact());
                if (cycleEntry >= 0) {
                    results.addCycle(context.parents, cycleEntry, d);
                    DependencyNode cycleNode = context.parents.get(cycleEntry);
                    if (cycleNode.getDependency() != null) {
                        child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult, cycleNode);
                        context.getParent().getChildren().add(child);
                        continue;
                    }
                }
                if (!descriptorResult.getRelocations().isEmpty()) {
                    boolean disableVersionManagementSubsequently = originalArtifact.getGroupId().equals(d.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d.getArtifact().getArtifactId());
                    PremanagedDependency premanagedDependency = PremanagedDependency.create(context.depManager, d, disableVersionManagementSubsequently, args2.premanagedState);
                    DependencyProcessingContext relocatedContext = new DependencyProcessingContext(context.depSelector, context.depManager, context.depTraverser, context.verFilter, context.trace, context.repositories, descriptorResult.getManagedDependencies(), context.parents, d, premanagedDependency);
                    if (!this.filter(relocatedContext)) {
                        relocatedContext.withDependency(premanagedDependency.getManagedDependency());
                        this.resolveArtifactDescriptorAsync(args2, relocatedContext, results);
                        this.processDependency(args2, results, relocatedContext, descriptorResult.getRelocations(), disableVersionManagementSubsequently);
                    }
                    return;
                }
                d = args2.pool.intern(d.setArtifact(args2.pool.intern(d.getArtifact())));
                List<RemoteRepository> repos = BfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), context.repositories);
                child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), repos, args2.request.getRequestContext());
                context.getParent().getChildren().add(child);
                boolean recurse = traverse && !descriptorResult.getDependencies().isEmpty();
                DependencyProcessingContext parentContext = context.withDependency(d);
                if (recurse) {
                    this.doRecurse(args2, parentContext, descriptorResult, child, results, disableVersionManagement);
                    continue;
                }
                if (args2.skipper.skipResolution(child, parentContext.parents)) continue;
                ArrayList<DependencyNode> parents2 = new ArrayList<DependencyNode>(parentContext.parents.size() + 1);
                parents2.addAll(parentContext.parents);
                parents2.add(child);
                args2.skipper.cache(child, parents2);
                continue;
            }
            List<RemoteRepository> repos = BfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), context.repositories);
            DefaultDependencyNode child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, null, repos, args2.request.getRequestContext());
            context.getParent().getChildren().add(child);
        }
    }

    private void doRecurse(Args args2, DependencyProcessingContext parentContext, ArtifactDescriptorResult descriptorResult, DefaultDependencyNode child, DependencyCollectorDelegate.Results results, boolean disableVersionManagement) {
        DefaultDependencyCollectionContext context = args2.collectionContext;
        context.set(parentContext.dependency, descriptorResult.getManagedDependencies());
        DependencySelector childSelector = parentContext.depSelector != null ? parentContext.depSelector.deriveChildSelector(context) : null;
        DependencyManager childManager = parentContext.depManager != null ? parentContext.depManager.deriveChildManager(context) : null;
        DependencyTraverser childTraverser = parentContext.depTraverser != null ? parentContext.depTraverser.deriveChildTraverser(context) : null;
        VersionFilter childFilter = parentContext.verFilter != null ? parentContext.verFilter.deriveChildFilter(context) : null;
        List<RemoteRepository> childRepos = args2.ignoreRepos ? parentContext.repositories : this.remoteRepositoryManager.aggregateRepositories(args2.session, parentContext.repositories, descriptorResult.getRepositories(), true);
        Object key = args2.pool.toKey(parentContext.dependency.getArtifact(), childRepos, childSelector, childManager, childTraverser, childFilter);
        List<DependencyNode> children2 = args2.pool.getChildren(key);
        if (children2 == null) {
            boolean skipResolution = args2.skipper.skipResolution(child, parentContext.parents);
            if (!skipResolution) {
                ArrayList<DependencyNode> parents2 = new ArrayList<DependencyNode>(parentContext.parents.size() + 1);
                parents2.addAll(parentContext.parents);
                parents2.add(child);
                for (Dependency dependency : descriptorResult.getDependencies()) {
                    RequestTrace childTrace = this.collectStepTrace(parentContext.trace, args2.request.getRequestContext(), parents2, dependency);
                    PremanagedDependency premanagedDependency = PremanagedDependency.create(childManager, dependency, disableVersionManagement, args2.premanagedState);
                    DependencyProcessingContext processingContext = new DependencyProcessingContext(childSelector, childManager, childTraverser, childFilter, childTrace, childRepos, descriptorResult.getManagedDependencies(), parents2, dependency, premanagedDependency);
                    if (this.filter(processingContext)) continue;
                    processingContext.withDependency(processingContext.premanagedDependency.getManagedDependency());
                    this.resolveArtifactDescriptorAsync(args2, processingContext, results);
                    args2.dependencyProcessingQueue.add(processingContext);
                }
                args2.pool.putChildren(key, child.getChildren());
                args2.skipper.cache(child, parents2);
            }
        } else {
            child.setChildren(children2);
        }
    }

    private boolean filter(DependencyProcessingContext context) {
        return context.depSelector != null && !context.depSelector.selectDependency(context.dependency);
    }

    private void resolveArtifactDescriptorAsync(Args args2, DependencyProcessingContext context, DependencyCollectorDelegate.Results results) {
        Dependency dependency = context.dependency;
        args2.resolver.resolveDescriptors(dependency.getArtifact(), () -> {
            VersionRangeRequest rangeRequest = BfDependencyCollector.createVersionRangeRequest(args2.request.getRequestContext(), context.trace, context.repositories, dependency);
            VersionRangeResult rangeResult = this.cachedResolveRangeResult(rangeRequest, args2.pool, args2.session);
            List<? extends Version> versions = BfDependencyCollector.filterVersions(dependency, rangeResult, context.verFilter, args2.versionContext);
            Collections.reverse(versions);
            ConcurrentHashMap descriptors = new ConcurrentHashMap(versions.size());
            Stream stream = versions.size() > 1 ? versions.parallelStream() : versions.stream();
            stream.forEach(version -> Optional.ofNullable(this.resolveDescriptorForVersion(args2, context, results, dependency, (Version)version)).ifPresent(r -> descriptors.put(version, r)));
            DescriptorResolutionResult resolutionResult = new DescriptorResolutionResult(dependency.getArtifact(), rangeResult);
            versions.forEach(version -> resolutionResult.descriptors.put((Version)version, (ArtifactDescriptorResult)descriptors.get(version)));
            resolutionResult.flatten().forEach(dr -> args2.resolver.cacheVersionRangeDescriptor(dr.artifact, (DescriptorResolutionResult)dr));
            return resolutionResult;
        });
    }

    private ArtifactDescriptorResult resolveDescriptorForVersion(Args args2, DependencyProcessingContext context, DependencyCollectorDelegate.Results results, Dependency dependency, Version version) {
        Artifact original = dependency.getArtifact();
        Artifact newArtifact = original.setVersion(version.toString());
        Dependency newDependency = new Dependency(newArtifact, dependency.getScope(), dependency.isOptional(), dependency.getExclusions());
        DependencyProcessingContext newContext = context.copy();
        ArtifactDescriptorRequest descriptorRequest = BfDependencyCollector.createArtifactDescriptorRequest(args2.request.getRequestContext(), context.trace, newContext.repositories, newDependency);
        return BfDependencyCollector.isLackingDescriptor(newArtifact) ? new ArtifactDescriptorResult(descriptorRequest) : this.resolveCachedArtifactDescriptor(args2.pool, descriptorRequest, args2.session, newContext.withDependency(newDependency), results);
    }

    private ArtifactDescriptorResult resolveCachedArtifactDescriptor(DataPool pool, ArtifactDescriptorRequest descriptorRequest, RepositorySystemSession session, DependencyProcessingContext context, DependencyCollectorDelegate.Results results) {
        DataPool.DescriptorKey key = pool.toKey(descriptorRequest);
        ArtifactDescriptorResult descriptorResult = pool.getDescriptor(key, descriptorRequest);
        if (descriptorResult == null) {
            try {
                descriptorResult = this.descriptorReader.readArtifactDescriptor(session, descriptorRequest);
                pool.putDescriptor(key, descriptorResult);
            }
            catch (ArtifactDescriptorException e) {
                results.addException(context.dependency, e, context.parents);
                pool.putDescriptor(key, e);
                return null;
            }
        } else if (descriptorResult == DataPool.NO_DESCRIPTOR) {
            return null;
        }
        return descriptorResult;
    }

    static class ParallelDescriptorResolver
    implements Closeable {
        private final ExecutorService executorService;
        private final Map<String, Future<DescriptorResolutionResult>> results = new ConcurrentHashMap<String, Future<DescriptorResolutionResult>>(256);

        ParallelDescriptorResolver(int threads) {
            this.executorService = ExecutorUtils.threadPool(threads, this.getClass().getSimpleName() + "-");
        }

        void resolveDescriptors(Artifact artifact, Callable<DescriptorResolutionResult> callable) {
            this.results.computeIfAbsent(ArtifactIdUtils.toId(artifact), key -> this.executorService.submit(callable));
        }

        void cacheVersionRangeDescriptor(Artifact artifact, DescriptorResolutionResult resolutionResult) {
            this.results.computeIfAbsent(ArtifactIdUtils.toId(artifact), key -> new DoneFuture<DescriptorResolutionResult>(resolutionResult));
        }

        Future<DescriptorResolutionResult> find(Artifact artifact) {
            return this.results.get(ArtifactIdUtils.toId(artifact));
        }

        @Override
        public void close() {
            this.executorService.shutdown();
        }
    }

    static class Args {
        final RepositorySystemSession session;
        final boolean ignoreRepos;
        final boolean premanagedState;
        final DataPool pool;
        final Queue<DependencyProcessingContext> dependencyProcessingQueue = new ArrayDeque<DependencyProcessingContext>(128);
        final DefaultDependencyCollectionContext collectionContext;
        final DefaultVersionFilterContext versionContext;
        final CollectRequest request;
        final DependencyResolutionSkipper skipper;
        final ParallelDescriptorResolver resolver;

        Args(RepositorySystemSession session, DataPool pool, DefaultDependencyCollectionContext collectionContext, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyResolutionSkipper skipper, ParallelDescriptorResolver resolver) {
            this.session = session;
            this.request = request;
            this.ignoreRepos = session.isIgnoreArtifactDescriptorRepositories();
            this.premanagedState = ConfigUtils.getBoolean(session, false, "aether.dependencyManager.verbose");
            this.pool = pool;
            this.collectionContext = collectionContext;
            this.versionContext = versionContext;
            this.skipper = skipper;
            this.resolver = resolver;
        }
    }

    static class DescriptorResolutionResult {
        Artifact artifact;
        VersionRangeResult rangeResult;
        Map<Version, ArtifactDescriptorResult> descriptors;

        DescriptorResolutionResult(Artifact artifact, VersionRangeResult rangeResult) {
            this.artifact = artifact;
            this.rangeResult = rangeResult;
            this.descriptors = new LinkedHashMap<Version, ArtifactDescriptorResult>(rangeResult.getVersions().size());
        }

        DescriptorResolutionResult(VersionRangeResult rangeResult, Version version, ArtifactDescriptorResult descriptor2) {
            this(descriptor2.getRequest().getArtifact(), rangeResult);
            this.descriptors.put(version, descriptor2);
        }

        List<DescriptorResolutionResult> flatten() {
            if (this.descriptors.size() > 1) {
                return this.descriptors.entrySet().stream().map(e -> new DescriptorResolutionResult(this.rangeResult, (Version)e.getKey(), (ArtifactDescriptorResult)e.getValue())).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    static class DoneFuture<V>
    implements Future<V> {
        private final V v;

        DoneFuture(V v) {
            this.v = v;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.v;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.v;
        }
    }
}

