/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.StringTableImpl;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J&\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J$\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCodegenFactory;", "Lorg/jetbrains/kotlin/codegen/CodegenFactory;", "<init>", "()V", "convertToIr", "Lorg/jetbrains/kotlin/codegen/CodegenFactory$BackendInput;", "input", "Lorg/jetbrains/kotlin/codegen/CodegenFactory$IrConversionInput;", "getModuleChunkBackendInput", "wholeBackendInput", "sourceFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "invokeLowerings", "Lorg/jetbrains/kotlin/codegen/CodegenFactory$CodegenInput;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "invokeCodegen", "", "generateModuleMetadata", "result", "generateMultifileClass", "multifileClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "files", "generatePackage", "packageFqName", "ktFiles", "OldBackendInput", "DummyOldCodegenInput", "backend"})
public final class DefaultCodegenFactory
implements CodegenFactory {
    @NotNull
    public static final DefaultCodegenFactory INSTANCE = new DefaultCodegenFactory();

    private DefaultCodegenFactory() {
    }

    @Override
    @NotNull
    public CodegenFactory.BackendInput convertToIr(@NotNull CodegenFactory.IrConversionInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new OldBackendInput(input.getFiles());
    }

    @Override
    @NotNull
    public CodegenFactory.BackendInput getModuleChunkBackendInput(@NotNull CodegenFactory.BackendInput wholeBackendInput, @NotNull Collection<? extends KtFile> sourceFiles) {
        Intrinsics.checkNotNullParameter((Object)wholeBackendInput, (String)"wholeBackendInput");
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        return new OldBackendInput(sourceFiles);
    }

    @Override
    @NotNull
    public CodegenFactory.CodegenInput invokeLowerings(@NotNull GenerationState state, @NotNull CodegenFactory.BackendInput input) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        OldBackendInput cfr_ignored_0 = (OldBackendInput)input;
        MultiMap filesInPackages = new MultiMap();
        MultiMap filesInMultifileClasses = new MultiMap();
        for (KtFile ktFile : ((OldBackendInput)input).getKtFiles()) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)ktFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                filesInMultifileClasses.putValue((Object)fileClassInfo.getFacadeClassFqName(), (Object)ktFile);
                continue;
            }
            filesInPackages.putValue((Object)ktFile.getPackageFqName(), (Object)ktFile);
        }
        HashSet obsoleteMultifileClasses = new HashSet(state.getObsoleteMultifileClasses());
        Set set = filesInMultifileClasses.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        for (FqName multifileClassFqName : SetsKt.plus((Set)set, (Iterable)obsoleteMultifileClasses)) {
            CodegenFactory.Companion.doCheckCancelled(state);
            Intrinsics.checkNotNull((Object)multifileClassFqName);
            Collection collection = filesInMultifileClasses.get((Object)multifileClassFqName);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            this.generateMultifileClass(state, multifileClassFqName, collection);
        }
        HashSet hashSet = new HashSet(state.getPackagesWithObsoleteParts());
        Set set2 = hashSet;
        Set set3 = filesInPackages.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"keySet(...)");
        for (FqName packageFqName : SetsKt.plus((Set)set2, (Iterable)set3)) {
            CodegenFactory.Companion.doCheckCancelled(state);
            Intrinsics.checkNotNull((Object)packageFqName);
            Collection collection = filesInPackages.get((Object)packageFqName);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            this.generatePackage(state, packageFqName, collection);
        }
        return new DummyOldCodegenInput(state);
    }

    @Override
    public void invokeCodegen(@NotNull CodegenFactory.CodegenInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.generateModuleMetadata(input);
    }

    private final void generateModuleMetadata(CodegenFactory.CodegenInput result) {
        JvmModuleProtoBuf.Module.Builder builder = JvmModuleProtoBuf.Module.newBuilder();
        StringTableImpl stringTable = new StringTableImpl();
        Intrinsics.checkNotNull((Object)builder);
        ClassFileUtilsKt.addDataFromCompiledModule(builder, stringTable, result.getState());
        Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = stringTable.buildProto();
        ProtoBuf.StringTable stringTableProto = (ProtoBuf.StringTable)pair.component1();
        ProtoBuf.QualifiedNameTable qualifiedNameTableProto = (ProtoBuf.QualifiedNameTable)pair.component2();
        builder.setStringTable(stringTableProto);
        builder.setQualifiedNameTable(qualifiedNameTableProto);
        result.getState().getFactory().setModuleMapping(builder.build());
    }

    private final void generateMultifileClass(GenerationState state, FqName multifileClassFqName, Collection<? extends KtFile> files) {
        state.getFactory().forMultifileClass(multifileClassFqName, files).generate();
    }

    public final void generatePackage(@NotNull GenerationState state, @NotNull FqName packageFqName, @NotNull Collection<? extends KtFile> ktFiles) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        state.getFactory().forPackage(packageFqName, ktFiles).generate();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCodegenFactory$DummyOldCodegenInput;", "Lorg/jetbrains/kotlin/codegen/CodegenFactory$CodegenInput;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "<init>", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "backend"})
    private static final class DummyOldCodegenInput
    implements CodegenFactory.CodegenInput {
        @NotNull
        private final GenerationState state;

        public DummyOldCodegenInput(@NotNull GenerationState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.state = state;
        }

        @Override
        @NotNull
        public GenerationState getState() {
            return this.state;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCodegenFactory$OldBackendInput;", "Lorg/jetbrains/kotlin/codegen/CodegenFactory$BackendInput;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Ljava/util/Collection;)V", "getKtFiles", "()Ljava/util/Collection;", "backend"})
    private static final class OldBackendInput
    implements CodegenFactory.BackendInput {
        @NotNull
        private final Collection<KtFile> ktFiles;

        public OldBackendInput(@NotNull Collection<? extends KtFile> ktFiles) {
            Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
            this.ktFiles = ktFiles;
        }

        @NotNull
        public final Collection<KtFile> getKtFiles() {
            return this.ktFiles;
        }
    }
}

